/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.james.backends.rabbitmq.QueueArguments;
import org.apache.james.events.Event;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.LocalListenerRegistry;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RoutingKeyConverter;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.scheduler.Schedulers;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.Sender;
import reactor.util.function.Tuples;

public class EventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDispatcher.class);
    private final NamingStrategy namingStrategy;
    private final EventSerializer eventSerializer;
    private final Sender sender;
    private final LocalListenerRegistry localListenerRegistry;
    private final AMQP.BasicProperties basicProperties;
    private final ListenerExecutor listenerExecutor;
    private final EventDeadLetters deadLetters;

    EventDispatcher(NamingStrategy namingStrategy, EventBusId eventBusId, EventSerializer eventSerializer, Sender sender, LocalListenerRegistry localListenerRegistry, ListenerExecutor listenerExecutor, EventDeadLetters deadLetters) {
        this.namingStrategy = namingStrategy;
        this.eventSerializer = eventSerializer;
        this.sender = sender;
        this.localListenerRegistry = localListenerRegistry;
        this.basicProperties = new AMQP.BasicProperties.Builder().headers((Map)ImmutableMap.of((Object)"eventBusId", (Object)eventBusId.asString())).deliveryMode(MessageProperties.PERSISTENT_TEXT_PLAIN.getDeliveryMode()).priority(MessageProperties.PERSISTENT_TEXT_PLAIN.getPriority()).contentType(MessageProperties.PERSISTENT_TEXT_PLAIN.getContentType()).build();
        this.listenerExecutor = listenerExecutor;
        this.deadLetters = deadLetters;
    }

    void start() {
        Flux.concat((Publisher[])new Publisher[]{this.sender.declareExchange(ExchangeSpecification.exchange((String)this.namingStrategy.exchange()).durable(true).type("direct")), this.sender.declareExchange(ExchangeSpecification.exchange((String)this.namingStrategy.deadLetterExchange()).durable(true).type("direct")), this.sender.declareQueue(this.namingStrategy.deadLetterQueue().durable(true).exclusive(false).autoDelete(false).arguments((Map)QueueArguments.NO_ARGUMENTS)), this.sender.bind(BindingSpecification.binding().exchange(this.namingStrategy.deadLetterExchange()).queue(this.namingStrategy.deadLetterQueue().getName()).routingKey(""))}).then().block();
    }

    Mono<Void> dispatch(Event event, Set<RegistrationKey> keys) {
        return (Mono)Flux.concat((Publisher[])new Publisher[]{this.dispatchToLocalListeners(event, keys), this.dispatchToRemoteListeners(event, keys)}).doOnError(throwable -> LOGGER.error("error while dispatching event", throwable)).then().subscribeWith((Subscriber)MonoProcessor.create());
    }

    private Mono<Void> dispatchToLocalListeners(Event event, Set<RegistrationKey> keys) {
        return Flux.fromIterable(keys).flatMap(key -> this.localListenerRegistry.getLocalListeners((RegistrationKey)key).map(listener -> Tuples.of((Object)key, (Object)listener)), 10).filter(pair -> ((EventListener.ReactiveEventListener)pair.getT2()).getExecutionMode() == EventListener.ExecutionMode.SYNCHRONOUS).flatMap(pair -> this.executeListener(event, (EventListener.ReactiveEventListener)pair.getT2(), (RegistrationKey)pair.getT1()), 10).then();
    }

    private Mono<Void> executeListener(Event event, EventListener.ReactiveEventListener listener, RegistrationKey registrationKey) {
        return this.listenerExecutor.execute(listener, MDCBuilder.create().addToContext("registrationKey", registrationKey.asString()), event).onErrorResume(e -> {
            this.structuredLogger(event, (Set<RegistrationKey>)ImmutableSet.of((Object)registrationKey)).log(logger -> logger.error("Exception happens when dispatching event", e));
            return Mono.empty();
        });
    }

    private StructuredLogger structuredLogger(Event event, Set<RegistrationKey> keys) {
        return MDCStructuredLogger.forLogger((Logger)LOGGER).field("eventId", event.getEventId().getId().toString()).field("eventClass", event.getClass().getCanonicalName()).field("user", event.getUsername().asString()).field("registrationKeys", keys.toString());
    }

    private Mono<Void> dispatchToRemoteListeners(Event event, Set<RegistrationKey> keys) {
        return Mono.fromCallable(() -> this.serializeEvent(event)).flatMap(serializedEvent -> Mono.zipDelayError(this.remoteGroupsDispatch((byte[])serializedEvent, event), this.remoteKeysDispatch((byte[])serializedEvent, keys))).then();
    }

    private Mono<Void> remoteGroupsDispatch(byte[] serializedEvent, Event event) {
        return this.remoteDispatchWithAcks(serializedEvent, Collections.singletonList(RoutingKeyConverter.RoutingKey.empty())).doOnError(ex -> LOGGER.error("cannot dispatch event of type '{}' belonging '{}' with id '{}' to remote groups, store it into dead letter", new Object[]{event.getClass().getSimpleName(), event.getUsername().asString(), event.getEventId().getId(), ex})).onErrorResume(ex -> this.deadLetters.store((Group)DispatchingFailureGroup.INSTANCE, event).then(Mono.error((Throwable)ex)));
    }

    private Mono<Void> remoteKeysDispatch(byte[] serializedEvent, Set<RegistrationKey> keys) {
        return this.remoteDispatch(serializedEvent, (Collection)keys.stream().map(RoutingKeyConverter.RoutingKey::of).collect(ImmutableList.toImmutableList()));
    }

    private Mono<Void> remoteDispatch(byte[] serializedEvent, Collection<RoutingKeyConverter.RoutingKey> routingKeys) {
        if (routingKeys.isEmpty()) {
            return Mono.empty();
        }
        return this.sender.send(this.toMessages(serializedEvent, routingKeys));
    }

    private Mono<Void> remoteDispatchWithAcks(byte[] serializedEvent, Collection<RoutingKeyConverter.RoutingKey> routingKeys) {
        if (routingKeys.isEmpty()) {
            return Mono.empty();
        }
        return this.sender.sendWithPublishConfirms(this.toMessages(serializedEvent, routingKeys)).subscribeOn(Schedulers.elastic()).filter(outboundMessageResult -> !outboundMessageResult.isAck()).next().handle((result, sink) -> sink.error((Throwable)new Exception("Publish was not acked")));
    }

    private Flux<OutboundMessage> toMessages(byte[] serializedEvent, Collection<RoutingKeyConverter.RoutingKey> routingKeys) {
        return Flux.fromIterable(routingKeys).map(routingKey -> new OutboundMessage(this.namingStrategy.exchange(), routingKey.asString(), this.basicProperties, serializedEvent));
    }

    private byte[] serializeEvent(Event event) {
        return this.eventSerializer.toJsonBytes(event);
    }

    public static class DispatchingFailureGroup
    extends Group {
        public static final DispatchingFailureGroup INSTANCE = new DispatchingFailureGroup();
    }
}

