/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.mailet.Mail;

public class EnqueuedItem
implements Disposable {
    private final EnqueueId enqueueId;
    private final MailQueueName mailQueueName;
    private final Mail mail;
    private final Instant enqueuedTime;
    private final MimeMessagePartsId partsId;

    public static Builder.RequireEnqueueId builder() {
        return enqueueId -> queueName -> mail -> enqueuedTime -> partsId -> new Builder.ReadyToBuild(enqueueId, queueName, mail, enqueuedTime, partsId);
    }

    EnqueuedItem(EnqueueId enqueueId, MailQueueName mailQueueName, Mail mail, Instant enqueuedTime, MimeMessagePartsId partsId) {
        this.enqueueId = enqueueId;
        this.mailQueueName = mailQueueName;
        this.mail = mail;
        this.enqueuedTime = enqueuedTime;
        this.partsId = partsId;
    }

    public EnqueueId getEnqueueId() {
        return this.enqueueId;
    }

    public MailQueueName getMailQueueName() {
        return this.mailQueueName;
    }

    public Mail getMail() {
        return this.mail;
    }

    public Instant getEnqueuedTime() {
        return this.enqueuedTime;
    }

    public MimeMessagePartsId getPartsId() {
        return this.partsId;
    }

    public void dispose() {
        LifecycleUtil.dispose((Object)this.mail);
    }

    public final boolean equals(Object o) {
        if (o instanceof EnqueuedItem) {
            EnqueuedItem that = (EnqueuedItem)o;
            return Objects.equals(this.enqueueId, that.enqueueId) && Objects.equals(this.mailQueueName, that.mailQueueName) && Objects.equals(this.mail, that.mail) && Objects.equals(this.enqueuedTime, that.enqueuedTime) && Objects.equals(this.partsId, that.partsId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.enqueueId, this.mailQueueName, this.mail, this.enqueuedTime, this.partsId);
    }

    static interface Builder {

        public static class ReadyToBuild {
            private final EnqueueId enqueueId;
            private final MailQueueName mailQueueName;
            private final Mail mail;
            private final Instant enqueuedTime;
            private final MimeMessagePartsId partsId;

            ReadyToBuild(EnqueueId enqueueId, MailQueueName mailQueueName, Mail mail, Instant enqueuedTime, MimeMessagePartsId partsId) {
                Preconditions.checkNotNull((Object)enqueueId, (Object)"'enqueueId' is mandatory");
                Preconditions.checkNotNull((Object)mailQueueName, (Object)"'mailQueueName' is mandatory");
                Preconditions.checkNotNull((Object)mail, (Object)"'mail' is mandatory");
                Preconditions.checkNotNull((Object)enqueuedTime, (Object)"'enqueuedTime' is mandatory");
                Preconditions.checkNotNull((Object)partsId, (Object)"'partsId' is mandatory");
                this.enqueueId = enqueueId;
                this.mailQueueName = mailQueueName;
                this.mail = mail;
                this.enqueuedTime = enqueuedTime;
                this.partsId = partsId;
            }

            public EnqueuedItem build() {
                return new EnqueuedItem(this.enqueueId, this.mailQueueName, this.mail, this.enqueuedTime, this.partsId);
            }
        }

        @FunctionalInterface
        public static interface RequireMimeMessagePartsId {
            public ReadyToBuild mimeMessagePartsId(MimeMessagePartsId var1);
        }

        @FunctionalInterface
        public static interface RequireEnqueuedTime {
            public RequireMimeMessagePartsId enqueuedTime(Instant var1);
        }

        @FunctionalInterface
        public static interface RequireMail {
            public RequireEnqueuedTime mail(Mail var1);
        }

        @FunctionalInterface
        public static interface RequireMailQueueName {
            public RequireMail mailQueueName(MailQueueName var1);
        }

        @FunctionalInterface
        public static interface RequireEnqueueId {
            public RequireMailQueueName enqueueId(EnqueueId var1);
        }
    }
}

