/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;

public class MailetConfigImpl
implements MailetConfig {
    private static final Pattern ATTRIBUTE_REGEX = Pattern.compile(Pattern.quote("[@") + ".+" + Pattern.quote("]"));
    private MailetContext mailetContext;
    private String name;
    private Configuration configuration;

    public String getInitParameter(String name) {
        return this.configuration.getString(name);
    }

    public Iterator<String> getInitParameterNames() {
        Iterator it = this.configuration.getKeys();
        ArrayList<String> params = new ArrayList<String>();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (params.contains(param = ATTRIBUTE_REGEX.matcher(param).replaceAll("").trim()) || param.isEmpty()) continue;
            params.add(param);
        }
        return params.iterator();
    }

    public MailetContext getMailetContext() {
        return this.mailetContext;
    }

    public void setMailetContext(MailetContext newContext) {
        this.mailetContext = newContext;
    }

    public void setConfiguration(Configuration newConfiguration) {
        BaseHierarchicalConfiguration builder = new BaseHierarchicalConfiguration();
        builder.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        Iterator keys = newConfiguration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] values = newConfiguration.getStringArray(key);
            key = key.replaceAll("\\.\\.", "\\.");
            StringBuilder valueBuilder = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                valueBuilder.append(values[i]);
                if (i + 1 >= values.length) continue;
                valueBuilder.append(",");
            }
            builder.addProperty(key, (Object)valueBuilder.toString());
        }
        this.configuration = builder;
    }

    public String getMailetName() {
        return this.name;
    }

    public void setMailetName(String newName) {
        this.name = newName;
    }
}

