/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.MethodCallId;

public class InvocationResponse {
    private final Method.Response.Name name;
    private final ObjectNode results;
    private final MethodCallId methodCallId;

    public InvocationResponse(Method.Response.Name name, ObjectNode results, MethodCallId methodCallId) {
        Preconditions.checkNotNull((Object)name, (Object)"method is mandatory");
        Preconditions.checkNotNull((Object)results, (Object)"results is mandatory");
        Preconditions.checkNotNull((Object)methodCallId, (Object)"methodCallId is mandatory");
        this.name = name;
        this.results = results;
        this.methodCallId = methodCallId;
    }

    public Method.Response.Name getResponseName() {
        return this.name;
    }

    public ObjectNode getResults() {
        return this.results;
    }

    public MethodCallId getMethodCallId() {
        return this.methodCallId;
    }

    public Object[] asProtocolSpecification() {
        return new Object[]{this.getResponseName(), this.getResults(), this.getMethodCallId()};
    }
}

