/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.dto.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.search.FieldName;
import org.apache.james.vault.search.Operator;

@JsonDeserialize(as=CriterionDTO.class)
public class CriterionDTO
implements QueryElement {
    private final String fieldName;
    private final String operator;
    private final String value;

    @VisibleForTesting
    static CriterionDTO from(FieldName fieldName, Operator operator, String value) {
        return new CriterionDTO(fieldName.getValue(), operator.getValue(), value);
    }

    @JsonCreator
    public CriterionDTO(@JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="operator") String operator, @JsonProperty(value="value") String value) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.value = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof CriterionDTO) {
            CriterionDTO that = (CriterionDTO)o;
            return Objects.equals(this.fieldName, that.getFieldName()) && Objects.equals(this.operator, that.getOperator()) && Objects.equals(this.value, that.getValue());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.fieldName, this.operator, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this.fieldName).add("operator", (Object)this.operator).add("value", (Object)this.value).toString();
    }
}

