/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.policies.PolicyPostFilter;
import org.apache.james.jspf.terms.Modifier;

public class NeutralIfNotMatchPolicy
implements PolicyPostFilter {
    public SPF1Record getSPFRecord(String currentDomain, SPF1Record spfRecord) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (spfRecord == null) {
            return null;
        }
        if (spfRecord.getDirectives().size() > 0) {
            spfRecord.getModifiers().add(new NeutralIfNotMatchModifier());
        }
        return spfRecord;
    }

    private final class NeutralIfNotMatchModifier
    implements Modifier {
        private NeutralIfNotMatchModifier() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException {
            if (spfData.getCurrentResult() == null) {
                spfData.setCurrentResult("?");
            }
            return null;
        }

        public String toString() {
            return "defaultresult";
        }

        public boolean enforceSingleInstance() {
            return false;
        }
    }
}

