/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxRecentsDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement addStatement;

    @Inject
    public CassandraMailboxRecentsDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = this.createReadStatement(session);
        this.deleteStatement = this.createDeleteStatement(session);
        this.deleteAllStatement = this.createDeleteAllStatement(session);
        this.addStatement = this.createAddStatement(session);
    }

    private PreparedStatement createReadStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"recent_mesage_uid"}).from("mailboxRecents").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement createDeleteStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxRecents").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))).and(QueryBuilder.eq((String)"recent_mesage_uid", (Object)QueryBuilder.bindMarker((String)"recent_mesage_uid"))));
    }

    private PreparedStatement createDeleteAllStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxRecents").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement createAddStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailboxRecents").value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).value("recent_mesage_uid", (Object)QueryBuilder.bindMarker((String)"recent_mesage_uid")));
    }

    public Flux<MessageUid> getRecentMessageUidsInMailbox(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> row.getLong("recent_mesage_uid")).map(MessageUid::of);
    }

    private BoundStatement bindWithMailbox(CassandraId mailboxId, PreparedStatement statement) {
        return statement.bind().setUUID("mailboxId", mailboxId.asUuid());
    }

    public Mono<Void> removeFromRecent(CassandraId mailboxId, MessageUid messageUid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("recent_mesage_uid", messageUid.asLong()));
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind().setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Void> addToRecent(CassandraId mailboxId, MessageUid messageUid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("recent_mesage_uid", messageUid.asLong()));
    }
}

