/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.BasicParseError;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.AbstractParseRunner;
import org.parboiled.support.ParsingResult;

public class ErrorLocatingParseRunner<V>
extends AbstractParseRunner<V>
implements MatchHandler {
    private final MatchHandler inner;
    private int errorIndex;

    public ErrorLocatingParseRunner(Rule rule) {
        this(rule, null);
    }

    public ErrorLocatingParseRunner(Rule rule, MatchHandler matchHandler) {
        super(rule);
        this.inner = matchHandler;
    }

    @Override
    public ParsingResult<V> run(InputBuffer inputBuffer) {
        Preconditions.checkArgNotNull(inputBuffer, "inputBuffer");
        this.resetValueStack();
        this.errorIndex = 0;
        MatcherContext matcherContext = this.createRootContext(inputBuffer, this, false);
        boolean bl = this.match(matcherContext);
        if (!bl) {
            this.getParseErrors().add(new BasicParseError(inputBuffer, this.errorIndex, null));
        }
        return this.createParsingResult(bl, matcherContext);
    }

    @Override
    public boolean match(MatcherContext<?> matcherContext) {
        if (this.inner == null && matcherContext.getMatcher().match(matcherContext) || this.inner != null && this.inner.match(matcherContext)) {
            if (this.errorIndex < matcherContext.getCurrentIndex() && this.notTestNot(matcherContext)) {
                this.errorIndex = matcherContext.getCurrentIndex();
            }
            return true;
        }
        return false;
    }

    private boolean notTestNot(MatcherContext matcherContext) {
        return !(matcherContext.getMatcher() instanceof TestNotMatcher) && (matcherContext.getParent() == null || this.notTestNot((MatcherContext)matcherContext.getParent()));
    }
}

