/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class DataChangeNotification
extends NotificationData
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=809");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=811");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=810");
    private final MonitoredItemNotification[] monitoredItems;
    private final DiagnosticInfo[] diagnosticInfos;

    public DataChangeNotification(MonitoredItemNotification[] monitoredItems, DiagnosticInfo[] diagnosticInfos) {
        this.monitoredItems = monitoredItems;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public MonitoredItemNotification[] getMonitoredItems() {
        return this.monitoredItems;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected DataChangeNotification(DataChangeNotificationBuilder<?, ?> b) {
        super((NotificationData.NotificationDataBuilder<?, ?>)b);
        this.monitoredItems = ((DataChangeNotificationBuilder)b).monitoredItems;
        this.diagnosticInfos = ((DataChangeNotificationBuilder)b).diagnosticInfos;
    }

    public static DataChangeNotificationBuilder<?, ?> builder() {
        return new DataChangeNotificationBuilderImpl();
    }

    public DataChangeNotificationBuilder<?, ?> toBuilder() {
        return new DataChangeNotificationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataChangeNotification)) {
            return false;
        }
        DataChangeNotification other = (DataChangeNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMonitoredItems(), other.getMonitoredItems())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataChangeNotification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getMonitoredItems());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "DataChangeNotification(monitoredItems=" + Arrays.deepToString(this.getMonitoredItems()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class DataChangeNotificationBuilderImpl
    extends DataChangeNotificationBuilder<DataChangeNotification, DataChangeNotificationBuilderImpl> {
        private DataChangeNotificationBuilderImpl() {
        }

        @Override
        protected DataChangeNotificationBuilderImpl self() {
            return this;
        }

        @Override
        public DataChangeNotification build() {
            return new DataChangeNotification(this);
        }
    }

    public static abstract class DataChangeNotificationBuilder<C extends DataChangeNotification, B extends DataChangeNotificationBuilder<C, B>>
    extends NotificationData.NotificationDataBuilder<C, B> {
        private MonitoredItemNotification[] monitoredItems;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataChangeNotificationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DataChangeNotification instance, DataChangeNotificationBuilder<?, ?> b) {
            b.monitoredItems(instance.monitoredItems);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B monitoredItems(MonitoredItemNotification[] monitoredItems) {
            this.monitoredItems = monitoredItems;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DataChangeNotification.DataChangeNotificationBuilder(super=" + super.toString() + ", monitoredItems=" + Arrays.deepToString(this.monitoredItems) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DataChangeNotification> {
        @Override
        public Class<DataChangeNotification> getType() {
            return DataChangeNotification.class;
        }

        @Override
        public DataChangeNotification decode(SerializationContext context, UaDecoder decoder) {
            MonitoredItemNotification[] monitoredItems = (MonitoredItemNotification[])decoder.readStructArray("MonitoredItems", MonitoredItemNotification.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new DataChangeNotification(monitoredItems, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DataChangeNotification value) {
            encoder.writeStructArray("MonitoredItems", (Object[])value.getMonitoredItems(), MonitoredItemNotification.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

