/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public class Binary
implements Comparable<Binary>,
Serializable,
Accountable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Binary.class);
    private static final long serialVersionUID = 6394197743397020735L;
    public static final Binary EMPTY_VALUE = new Binary(new byte[0]);
    private byte[] values;

    public Binary(byte[] v) {
        this.values = v;
    }

    public Binary(String s2, Charset charset) {
        this.values = s2 == null ? null : s2.getBytes(charset);
    }

    @Override
    public int compareTo(Binary other) {
        if (other == null) {
            if (this.values == null) {
                return 0;
            }
            return 1;
        }
        int len1 = this.getLength();
        int len2 = other.getLength();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            if (this.values[k] == other.values[k]) continue;
            return this.getChar(this.values, k) - this.getChar(other.values, k);
        }
        return len1 - len2;
    }

    private char getChar(byte[] val, int index) {
        return (char)(val[index] & 0xFF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary binary = (Binary)o;
        return Arrays.equals(this.values, binary.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public int getLength() {
        if (this.values == null) {
            return -1;
        }
        return this.values.length;
    }

    public String getStringValue(Charset charset) {
        return new String(this.values, charset);
    }

    public String toString() {
        return this.getStringValue(StandardCharsets.UTF_8);
    }

    public byte[] getValues() {
        return this.values;
    }

    public void setValues(byte[] values) {
        this.values = values;
    }

    @Override
    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf(this.values);
    }
}

