/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.rpc.TSStatusCode;

public class TreeViewSchema {
    public static final String ORIGINAL_NAME = "__original_name";
    public static final String TREE_PATH_PATTERN = "__tree_path_pattern";
    public static final String RESTRICT = "__restrict";

    public static boolean isTreeViewTable(TsTable table) {
        return table.getPropValue(TREE_PATH_PATTERN).isPresent();
    }

    public static PartialPath getPrefixPattern(TsTable table) {
        return table.getPropValue(TREE_PATH_PATTERN).map(TreeViewSchema::forceSeparateStringToPartialPath).orElseThrow(() -> new IoTDBRuntimeException(String.format("Failed to get the original database, because the %s is null for table %s", TREE_PATH_PATTERN, table.getTableName()), TSStatusCode.SEMANTIC_ERROR.getStatusCode()));
    }

    public static PartialPath forceSeparateStringToPartialPath(String string) {
        PartialPath partialPath;
        try {
            partialPath = new PartialPath(string);
        }
        catch (IllegalPathException e) {
            throw new IoTDBRuntimeException(String.format("Failed to parse the tree view string %s when convert to IDeviceID", string), TSStatusCode.SEMANTIC_ERROR.getStatusCode());
        }
        return partialPath;
    }

    public static String getSourceName(TsTableColumnSchema schema) {
        return Objects.nonNull(TreeViewSchema.getOriginalName(schema)) ? TreeViewSchema.getOriginalName(schema) : schema.getColumnName();
    }

    public static String getOriginalName(TsTableColumnSchema schema) {
        return schema.getProps().get(ORIGINAL_NAME);
    }

    public static void setOriginalName(TsTableColumnSchema schema, String name) {
        schema.getProps().put(ORIGINAL_NAME, name);
    }

    public static boolean isRestrict(TsTable table) {
        return table.getPropValue(RESTRICT).isPresent();
    }

    public static void setRestrict(TsTable table) {
        table.addProp(RESTRICT, "");
    }

    public static String setPathPattern(TsTable table, PartialPath pathPattern) {
        String[] nodes = pathPattern.getNodes();
        if (!PathPatternUtil.isMultiLevelMatchWildcard(nodes[nodes.length - 1])) {
            return "The last node must be '**'";
        }
        for (int i = nodes.length - 2; i >= 0; --i) {
            if (!PathPatternUtil.hasWildcard(nodes[i])) continue;
            return "The wildCard is not permitted to set before the last node";
        }
        table.addProp(TREE_PATH_PATTERN, pathPattern.toString());
        return null;
    }

    private TreeViewSchema() {
    }
}

