/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.StartsWithColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class EndsWithColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] suffix;

    public EndsWithColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String suffixStr) {
        super(returnType, childColumnTransformer);
        this.suffix = suffixStr.getBytes();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBoolean(StartsWithColumnTransformer.equalCompare(currentValue, this.suffix, currentValue.length - this.suffix.length));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBoolean(StartsWithColumnTransformer.equalCompare(currentValue, this.suffix, currentValue.length - this.suffix.length));
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

