/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;

public class CastToFloatLiteralVisitor
extends AstVisitor<Float, Void> {
    @Override
    protected Float visitLiteral(Literal node, Void context) {
        throw new UnsupportedOperationException("Unhandled literal type: " + node);
    }

    @Override
    protected Float visitBooleanLiteral(BooleanLiteral node, Void context) {
        return Float.valueOf(node.getValue() ? 1.0f : 0.0f);
    }

    @Override
    protected Float visitLongLiteral(LongLiteral node, Void context) {
        return Float.valueOf(node.getParsedValue());
    }

    @Override
    protected Float visitDoubleLiteral(DoubleLiteral node, Void context) {
        return Float.valueOf((float)node.getValue());
    }

    @Override
    protected Float visitStringLiteral(StringLiteral node, Void context) {
        try {
            return Float.valueOf(Float.parseFloat(node.getValue()));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Float visitBinaryLiteral(BinaryLiteral node, Void context) {
        return null;
    }

    @Override
    protected Float visitGenericLiteral(GenericLiteral node, Void context) {
        try {
            return Float.valueOf(Float.parseFloat(node.getValue()));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Float visitNullLiteral(NullLiteral node, Void context) {
        return null;
    }
}

