/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.utils.io.BufferSerializable;
import org.apache.iotdb.db.utils.io.StreamSerializable;
import org.apache.tsfile.annotations.TreeModel;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class ModEntry
implements StreamSerializable,
BufferSerializable,
Comparable<ModEntry> {
    protected ModType modType;
    protected TimeRange timeRange;

    protected ModEntry(ModType modType) {
        this.modType = modType;
    }

    public int serializedSize() {
        return 19;
    }

    @Override
    public long serialize(OutputStream stream) throws IOException {
        stream.write(this.modType.getTypeNum());
        long size = 1L;
        size += (long)ReadWriteIOUtils.write((long)this.timeRange.getMin(), (OutputStream)stream);
        return size += (long)ReadWriteIOUtils.write((long)this.timeRange.getMax(), (OutputStream)stream);
    }

    @Override
    public long serialize(ByteBuffer buffer) {
        buffer.put(this.modType.getTypeNum());
        long size = 1L;
        size += (long)ReadWriteIOUtils.write((long)this.timeRange.getMin(), (ByteBuffer)buffer);
        return size += (long)ReadWriteIOUtils.write((long)this.timeRange.getMax(), (ByteBuffer)buffer);
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        this.timeRange = new TimeRange(ReadWriteIOUtils.readLong((InputStream)stream), ReadWriteIOUtils.readLong((InputStream)stream));
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.timeRange = new TimeRange(ReadWriteIOUtils.readLong((ByteBuffer)buffer), ReadWriteIOUtils.readLong((ByteBuffer)buffer));
    }

    public long getStartTime() {
        return this.timeRange.getMin();
    }

    public long getEndTime() {
        return this.timeRange.getMax();
    }

    @Deprecated
    @TreeModel
    public abstract boolean matches(PartialPath var1);

    public abstract boolean affects(IDeviceID var1, long var2, long var4);

    public abstract boolean affects(IDeviceID var1);

    public abstract boolean affects(String var1);

    public abstract boolean affectsAll(IDeviceID var1);

    public abstract PartialPath keyOfPatternTree();

    public abstract ModEntry clone();

    public static ModEntry createFrom(InputStream stream) throws IOException {
        ModType modType = ModType.deserialize(stream);
        ModEntry entry = modType.newEntry();
        entry.deserialize(stream);
        return entry;
    }

    public static ModEntry createFrom(ByteBuffer buffer) {
        ModType modType = ModType.deserialize(buffer);
        ModEntry entry = modType.newEntry();
        entry.deserialize(buffer);
        return entry;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public ModType getType() {
        return this.modType;
    }

    public static enum ModType {
        TABLE_DELETION(0),
        TREE_DELETION(1);

        private final byte typeNum;

        private ModType(byte typeNum) {
            this.typeNum = typeNum;
        }

        public byte getTypeNum() {
            return this.typeNum;
        }

        public long getSerializedSize() {
            return 1L;
        }

        public ModEntry newEntry() {
            ModEntry entry;
            switch (this) {
                case TREE_DELETION: {
                    entry = new TreeDeletionEntry();
                    break;
                }
                case TABLE_DELETION: {
                    entry = new TableDeletionEntry();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported mod type: " + (Object)((Object)this));
                }
            }
            return entry;
        }

        public static ModType deserialize(ByteBuffer buffer) {
            byte typeNum = buffer.get();
            switch (typeNum) {
                case 0: {
                    return TABLE_DELETION;
                }
                case 1: {
                    return TREE_DELETION;
                }
            }
            throw new IllegalArgumentException("Unknown ModType: " + typeNum);
        }

        public static ModType deserialize(InputStream stream) throws IOException {
            byte typeNum = ReadWriteIOUtils.readByte((InputStream)stream);
            switch (typeNum) {
                case 0: {
                    return TABLE_DELETION;
                }
                case 1: {
                    return TREE_DELETION;
                }
            }
            throw new IllegalArgumentException("Unknown ModType: " + typeNum);
        }
    }
}

