/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.overview;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.pipe.metric.overview.PipeConfigNodeRemainingTimeOperator;
import org.apache.iotdb.confignode.manager.pipe.source.IoTDBConfigRegionSource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConfigNodeRemainingTimeMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConfigNodeRemainingTimeMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, PipeConfigNodeRemainingTimeOperator> remainingTimeOperatorMap = new ConcurrentHashMap<String, PipeConfigNodeRemainingTimeOperator>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.remainingTimeOperatorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String pipeID) {
        this.createAutoGauge(pipeID);
    }

    private void createAutoGauge(String pipeID) {
        PipeConfigNodeRemainingTimeOperator operator = this.remainingTimeOperatorMap.get(pipeID);
        this.metricService.createAutoGauge(Metric.PIPE_CONFIGNODE_REMAINING_TIME.toString(), MetricLevel.IMPORTANT, (Object)operator, PipeConfigNodeRemainingTimeOperator::getRemainingTime, new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.remainingTimeOperatorMap.keySet()).forEach(this::deregister);
        if (!this.remainingTimeOperatorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe remaining time metrics, RemainingTimeOperator map not empty");
        }
    }

    private void removeMetrics(String pipeID) {
        this.removeAutoGauge(pipeID);
    }

    private void removeAutoGauge(String pipeID) {
        PipeConfigNodeRemainingTimeOperator operator = this.remainingTimeOperatorMap.get(pipeID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_CONFIGNODE_REMAINING_TIME.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.remainingTimeOperatorMap.remove(pipeID);
    }

    public void register(IoTDBConfigRegionSource extractor) {
        String pipeID = extractor.getPipeName() + "_" + extractor.getCreationTime();
        this.remainingTimeOperatorMap.computeIfAbsent(pipeID, k -> new PipeConfigNodeRemainingTimeOperator(extractor.getPipeName(), extractor.getCreationTime())).register(extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(pipeID);
        }
    }

    public void thawRate(String pipeID) {
        if (!this.remainingTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingTimeOperatorMap.get(pipeID).thawRate(true);
    }

    public void freezeRate(String pipeID) {
        if (!this.remainingTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingTimeOperatorMap.get(pipeID).freezeRate(true);
    }

    public void deregister(String pipeID) {
        if (!this.remainingTimeOperatorMap.containsKey(pipeID)) {
            LOGGER.warn("Failed to deregister pipe remaining time metrics, RemainingTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(pipeID);
        }
    }

    public void markRegionCommit(String pipeID, boolean isDataRegion) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        PipeConfigNodeRemainingTimeOperator operator = this.remainingTimeOperatorMap.get(pipeID);
        if (Objects.isNull((Object)operator)) {
            LOGGER.info("Failed to mark pipe region commit, RemainingTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        operator.markConfigRegionCommit();
    }

    public double getRemainingTime(String pipeName, long creationTime) {
        return this.remainingTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeConfigNodeRemainingTimeOperator(pipeName, creationTime)).getRemainingTime();
    }

    public static PipeConfigNodeRemainingTimeMetrics getInstance() {
        return PipeConfigNodeRemainingTimeMetricsHolder.INSTANCE;
    }

    private PipeConfigNodeRemainingTimeMetrics() {
        PipeEventCommitManager.getInstance().setCommitRateMarker(this::markRegionCommit);
    }

    private static class PipeConfigNodeRemainingTimeMetricsHolder {
        private static final PipeConfigNodeRemainingTimeMetrics INSTANCE = new PipeConfigNodeRemainingTimeMetrics();

        private PipeConfigNodeRemainingTimeMetricsHolder() {
        }
    }
}

