/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.historical;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.TimeWindowStateProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSourceRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionSource;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHistoricalDataRegionTsFileSource
implements PipeHistoricalDataRegionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHistoricalDataRegionTsFileSource.class);
    private String pipeName;
    private long creationTime;
    private PipeTaskMeta pipeTaskMeta;
    private ProgressIndex startIndex;
    private int dataRegionId;
    private PipePattern pipePattern;
    private boolean isDbNameCoveredByPattern = false;
    private boolean isHistoricalSourceEnabled = false;
    private long historicalDataExtractionStartTime = Long.MIN_VALUE;
    private long historicalDataExtractionEndTime = Long.MAX_VALUE;
    private boolean sloppyTimeRange;
    private boolean sloppyPattern;
    private Pair<Boolean, Boolean> listeningOptionPair;
    private boolean shouldExtractInsertion;
    private boolean shouldTransferModFile;
    private boolean shouldTerminatePipeOnAllHistoricalEventsConsumed;
    private boolean isTerminateSignalSent = false;
    private boolean isForwardingPipeRequests;
    private volatile boolean hasBeenStarted = false;
    private Queue<TsFileResource> pendingQueue;
    private final Set<TsFileResource> filteredTsFileResources = new HashSet<TsFileResource>();

    public void validate(PipeParameterValidator validator) {
        PipeParameters parameters = validator.getParameters();
        try {
            this.listeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
        String extractorHistoryLooseRangeValue = parameters.getStringOrDefault(Arrays.asList("extractor.history.loose-range", "source.history.loose-range"), "").trim();
        if ("all".equalsIgnoreCase(extractorHistoryLooseRangeValue)) {
            this.sloppyTimeRange = true;
            this.sloppyPattern = true;
        } else {
            Set sloppyOptionSet = Arrays.stream(extractorHistoryLooseRangeValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
            this.sloppyTimeRange = sloppyOptionSet.remove("time");
            this.sloppyPattern = sloppyOptionSet.remove("path");
            if (!sloppyOptionSet.isEmpty()) {
                throw new PipeParameterNotValidException(String.format("Parameters in set %s are not allowed in 'history.loose-range'", sloppyOptionSet));
            }
        }
        if (parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time"})) {
            this.isHistoricalSourceEnabled = true;
            try {
                this.historicalDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.start-time", "extractor.start-time"})) : Long.MIN_VALUE;
                long l = this.historicalDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"source.end-time", "extractor.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.end-time", "extractor.end-time"})) : Long.MAX_VALUE;
                if (this.historicalDataExtractionStartTime > this.historicalDataExtractionEndTime) {
                    throw new PipeParameterNotValidException(String.format("%s (%s) [%s] should be less than or equal to %s (%s) [%s].", "source.start-time", "extractor.start-time", this.historicalDataExtractionStartTime, "source.end-time", "extractor.end-time", this.historicalDataExtractionEndTime));
                }
            }
            catch (PipeParameterNotValidException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PipeParameterNotValidException(e.getMessage());
            }
            return;
        }
        this.isHistoricalSourceEnabled = parameters.getBooleanOrDefault("__system.restart_or_newly_added", false) || parameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true);
        try {
            this.historicalDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"extractor.history.start-time", "source.history.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"extractor.history.start-time", "source.history.start-time"})) : Long.MIN_VALUE;
            long l = this.historicalDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"extractor.history.end-time", "source.history.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"extractor.history.end-time", "source.history.end-time"})) : Long.MAX_VALUE;
            if (this.historicalDataExtractionStartTime > this.historicalDataExtractionEndTime) {
                throw new PipeParameterNotValidException(String.format("%s (%s) [%s] should be less than or equal to %s (%s) [%s].", "extractor.history.start-time", "source.history.start-time", this.historicalDataExtractionStartTime, "extractor.history.end-time", "source.history.end-time", this.historicalDataExtractionEndTime));
            }
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws IllegalPathException {
        String databaseName;
        this.shouldExtractInsertion = (Boolean)this.listeningOptionPair.getLeft();
        if (!this.shouldExtractInsertion) {
            return;
        }
        PipeTaskSourceRuntimeEnvironment environment = (PipeTaskSourceRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.startIndex = environment.getPipeTaskMeta().getProgressIndex();
        this.dataRegionId = environment.getRegionId();
        this.pipePattern = PipePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (Objects.nonNull(dataRegion) && Objects.nonNull(databaseName = dataRegion.getDatabaseName())) {
            this.isDbNameCoveredByPattern = this.pipePattern.coversDb(databaseName);
        }
        this.shouldTransferModFile = parameters.getBooleanOrDefault(Arrays.asList("source.mods.enable", "extractor.mods.enable"), ((Boolean)this.listeningOptionPair.getRight()).booleanValue());
        this.shouldTerminatePipeOnAllHistoricalEventsConsumed = PipeTaskAgent.isSnapshotMode((PipeParameters)parameters);
        this.isForwardingPipeRequests = parameters.getBooleanOrDefault(Arrays.asList("extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"), true);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Pipe {}@{}: historical data extraction time range, start time {}({}), end time {}({}), sloppy pattern {}, sloppy time range {}, should transfer mod file {}, is forwarding pipe requests: {}", new Object[]{this.pipeName, this.dataRegionId, DateTimeUtils.convertLongToDate(this.historicalDataExtractionStartTime), this.historicalDataExtractionStartTime, DateTimeUtils.convertLongToDate(this.historicalDataExtractionEndTime), this.historicalDataExtractionEndTime, this.sloppyPattern, this.sloppyTimeRange, this.shouldTransferModFile, this.isForwardingPipeRequests});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.shouldExtractInsertion) {
            this.hasBeenStarted = true;
            return;
        }
        if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
            LOGGER.info("Pipe {}@{}: failed to start to extract historical TsFile, storage engine is not ready. Will retry later.", (Object)this.pipeName, (Object)this.dataRegionId);
            return;
        }
        this.hasBeenStarted = true;
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (Objects.isNull(dataRegion)) {
            this.pendingQueue = new ArrayDeque<TsFileResource>();
            return;
        }
        dataRegion.writeLock("Pipe: start to extract historical TsFile");
        long startHistoricalExtractionTime = System.currentTimeMillis();
        try {
            LOGGER.info("Pipe {}@{}: start to flush data region", (Object)this.pipeName, (Object)this.dataRegionId);
            if (this.pipeName.startsWith("__consensus.")) {
                dataRegion.syncCloseAllWorkingTsFileProcessors();
            } else {
                dataRegion.asyncCloseAllWorkingTsFileProcessors();
            }
            LOGGER.info("Pipe {}@{}: finish to flush data region, took {} ms", new Object[]{this.pipeName, this.dataRegionId, System.currentTimeMillis() - startHistoricalExtractionTime});
            TsFileManager tsFileManager = dataRegion.getTsFileManager();
            tsFileManager.readLock();
            try {
                int originalSequenceTsFileCount = tsFileManager.size(true);
                int originalUnSequenceTsFileCount = tsFileManager.size(false);
                ArrayList originalResourceList = new ArrayList(originalSequenceTsFileCount + originalUnSequenceTsFileCount);
                LOGGER.info("Pipe {}@{}: start to extract historical TsFile, original sequence file count {}, original unSequence file count {}, start progress index {}", new Object[]{this.pipeName, this.dataRegionId, originalSequenceTsFileCount, originalUnSequenceTsFileCount, this.startIndex});
                Collection sequenceTsFileResources = tsFileManager.getTsFileList(true).stream().peek(originalResourceList::add).filter(resource -> this.isHistoricalSourceEnabled && !resource.isDeleted() && (!resource.isGeneratedByPipe() || this.isForwardingPipeRequests) && (!resource.isClosed() && Optional.ofNullable(resource.getProcessor()).map(TsFileProcessor::alreadyMarkedClosing).orElse(true) != false || this.mayTsFileContainUnprocessedData((TsFileResource)resource) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.mayTsFileResourceOverlappedWithPattern((TsFileResource)resource))).collect(Collectors.toList());
                this.filteredTsFileResources.addAll(sequenceTsFileResources);
                Collection unSequenceTsFileResources = tsFileManager.getTsFileList(false).stream().peek(originalResourceList::add).filter(resource -> this.isHistoricalSourceEnabled && !resource.isDeleted() && (!resource.isGeneratedByPipe() || this.isForwardingPipeRequests) && (!resource.isClosed() && Optional.ofNullable(resource.getProcessor()).map(TsFileProcessor::alreadyMarkedClosing).orElse(true) != false || this.mayTsFileContainUnprocessedData((TsFileResource)resource) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.mayTsFileResourceOverlappedWithPattern((TsFileResource)resource))).collect(Collectors.toList());
                this.filteredTsFileResources.addAll(unSequenceTsFileResources);
                this.filteredTsFileResources.removeIf(resource -> {
                    try {
                        PipeDataNodeResourceManager.tsfile().pinTsFileResource((TsFileResource)resource, this.shouldTransferModFile, this.pipeName);
                        return false;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Pipe: failed to pin TsFileResource {}", (Object)resource.getTsFilePath(), (Object)e);
                        return true;
                    }
                });
                originalResourceList.sort((o1, o2) -> this.startIndex instanceof TimeWindowStateProgressIndex ? Long.compare(o1.getFileStartTime(), o2.getFileStartTime()) : o1.getMaxProgressIndex().topologicalCompareTo(o2.getMaxProgressIndex()));
                this.pendingQueue = new ArrayDeque<TsFileResource>(originalResourceList);
                LOGGER.info("Pipe {}@{}: finish to extract historical TsFile, extracted sequence file count {}/{}, extracted unsequence file count {}/{}, extracted file count {}/{}, took {} ms", new Object[]{this.pipeName, this.dataRegionId, sequenceTsFileResources.size(), originalSequenceTsFileCount, unSequenceTsFileResources.size(), originalUnSequenceTsFileCount, this.filteredTsFileResources.size(), originalSequenceTsFileCount + originalUnSequenceTsFileCount, System.currentTimeMillis() - startHistoricalExtractionTime});
            }
            finally {
                tsFileManager.readUnlock();
            }
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    private boolean mayTsFileContainUnprocessedData(TsFileResource resource) {
        if (this.startIndex instanceof TimeWindowStateProgressIndex) {
            return ((TimeWindowStateProgressIndex)this.startIndex).getMinTime() <= resource.getFileEndTime();
        }
        if (this.startIndex instanceof StateProgressIndex) {
            this.startIndex = ((StateProgressIndex)this.startIndex).getInnerProgressIndex();
        }
        if (!this.startIndex.isAfter(resource.getMaxProgressIndex()) && !this.startIndex.equals(resource.getMaxProgressIndex())) {
            LOGGER.info("Pipe {}@{}: file {} meets mayTsFileContainUnprocessedData condition, extractor progressIndex: {}, resource ProgressIndex: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath(), this.startIndex, resource.getMaxProgressIndex()});
            return true;
        }
        return false;
    }

    private boolean mayTsFileResourceOverlappedWithPattern(TsFileResource resource) {
        Set<IDeviceID> deviceSet;
        try {
            Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(resource.getTsFile(), false);
            deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : resource.getDevices();
        }
        catch (IOException e) {
            LOGGER.warn("Pipe {}@{}: failed to get devices from TsFile {}, extract it anyway", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath(), e});
            return true;
        }
        return deviceSet.stream().anyMatch(deviceID -> this.pipePattern.mayOverlapWithDevice(((PlainDeviceID)deviceID).toStringID()));
    }

    private boolean isTsFileResourceOverlappedWithTimeRange(TsFileResource resource) {
        return resource.getFileEndTime() >= this.historicalDataExtractionStartTime && this.historicalDataExtractionEndTime >= resource.getFileStartTime();
    }

    private boolean isTsFileResourceCoveredByTimeRange(TsFileResource resource) {
        return this.historicalDataExtractionStartTime <= resource.getFileStartTime() && this.historicalDataExtractionEndTime >= resource.getFileEndTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Event supply() {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent;
        if (!this.hasBeenStarted && StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
            this.start();
        }
        if (Objects.isNull(this.pendingQueue)) {
            return null;
        }
        TsFileResource resource = this.pendingQueue.poll();
        if (resource == null) {
            PipeTerminateEvent terminateEvent = new PipeTerminateEvent(this.pipeName, this.creationTime, this.pipeTaskMeta, this.dataRegionId, this.shouldTerminatePipeOnAllHistoricalEventsConsumed);
            if (!terminateEvent.increaseReferenceCount(PipeHistoricalDataRegionTsFileSource.class.getName())) {
                LOGGER.warn("Pipe {}@{}: failed to increase reference count for terminate event, will resend it", (Object)this.pipeName, (Object)this.dataRegionId);
                return null;
            }
            this.isTerminateSignalSent = true;
            return terminateEvent;
        }
        if (!this.filteredTsFileResources.contains(resource)) {
            ProgressReportEvent progressReportEvent = new ProgressReportEvent(this.pipeName, this.creationTime, this.pipeTaskMeta);
            progressReportEvent.bindProgressIndex(resource.getMaxProgressIndex());
            boolean isReferenceCountIncreased = progressReportEvent.increaseReferenceCount(PipeHistoricalDataRegionTsFileSource.class.getName());
            if (!isReferenceCountIncreased) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)progressReportEvent);
            }
            return isReferenceCountIncreased ? progressReportEvent : null;
        }
        this.filteredTsFileResources.remove(resource);
        PipeTsFileInsertionEvent event = new PipeTsFileInsertionEvent(resource, null, this.shouldTransferModFile, false, true, this.pipeName, this.creationTime, this.pipeTaskMeta, this.pipePattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime);
        if (this.sloppyPattern || this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        if (this.sloppyTimeRange || this.isTsFileResourceCoveredByTimeRange(resource)) {
            event.skipParsingTime();
        }
        try {
            boolean isReferenceCountIncreased = event.increaseReferenceCount(PipeHistoricalDataRegionTsFileSource.class.getName());
            if (!isReferenceCountIncreased) {
                LOGGER.warn("Pipe {}@{}: failed to increase reference count for historical event {}, will discard it", new Object[]{this.pipeName, this.dataRegionId, event});
            }
            pipeTsFileInsertionEvent = isReferenceCountIncreased ? event : null;
        }
        catch (Throwable throwable) {
            try {
                PipeDataNodeResourceManager.tsfile().unpinTsFileResource(resource, this.pipeName);
            }
            catch (IOException e) {
                LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after creating event, original path: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath()});
            }
            throw throwable;
        }
        try {
            PipeDataNodeResourceManager.tsfile().unpinTsFileResource(resource, this.pipeName);
        }
        catch (IOException e) {
            LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after creating event, original path: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath()});
        }
        return pipeTsFileInsertionEvent;
    }

    @Override
    public synchronized boolean hasConsumedAll() {
        return this.hasBeenStarted && (Objects.isNull(this.pendingQueue) || this.pendingQueue.isEmpty() && this.isTerminateSignalSent);
    }

    @Override
    public int getPendingQueueSize() {
        return Objects.nonNull(this.pendingQueue) ? this.pendingQueue.size() : 0;
    }

    public synchronized void close() {
        if (Objects.nonNull(this.pendingQueue)) {
            this.pendingQueue.forEach(resource -> {
                try {
                    PipeDataNodeResourceManager.tsfile().unpinTsFileResource((TsFileResource)resource, this.pipeName);
                }
                catch (IOException e) {
                    LOGGER.warn("Pipe {}@{}: failed to unpin TsFileResource after dropping pipe, original path: {}", new Object[]{this.pipeName, this.dataRegionId, resource.getTsFilePath()});
                }
            });
            this.pendingQueue.clear();
            this.pendingQueue = null;
        }
    }
}

