/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter;

import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.AndFilter;
import org.apache.iotdb.commons.schema.filter.impl.DataTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.TemplateFilter;
import org.apache.iotdb.commons.schema.filter.impl.ViewTypeFilter;
import org.apache.iotdb.commons.schema.view.ViewType;
import org.apache.tsfile.enums.TSDataType;

public class SchemaFilterFactory {
    public static SchemaFilter createTagFilter(String key, String value, boolean isContains) {
        return new TagFilter(key, value, isContains);
    }

    public static SchemaFilter createPathContainsFilter(String containString) {
        return new PathContainsFilter(containString);
    }

    public static SchemaFilter createDataTypeFilter(TSDataType dataType) {
        return new DataTypeFilter(dataType);
    }

    public static SchemaFilter createViewTypeFilter(ViewType viewType) {
        return new ViewTypeFilter(viewType);
    }

    public static SchemaFilter createTemplateNameFilter(String templateName, boolean isEqual) {
        return new TemplateFilter(templateName, isEqual);
    }

    public static SchemaFilter and(SchemaFilter left, SchemaFilter right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new AndFilter(left, right);
    }
}

