/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.manage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.monitor.NodeStatus;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;

public class QueryCoordinator {
    private static final QueryCoordinator INSTANCE = new QueryCoordinator();
    private static final NodeStatusManager STATUS_MANAGER = NodeStatusManager.getINSTANCE();
    private final Comparator<Node> nodeComparator = Comparator.comparing(this::getNodeStatus);

    private QueryCoordinator() {
    }

    public static QueryCoordinator getINSTANCE() {
        return INSTANCE;
    }

    public List<Node> reorderNodes(List<Node> nodes) {
        ArrayList<Node> reordered = new ArrayList<Node>(nodes);
        reordered.sort(this.nodeComparator);
        return reordered;
    }

    public NodeStatus getNodeStatus(Node node) {
        return STATUS_MANAGER.getNodeStatus(node, true);
    }
}

