/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.UserApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserRequest;

public class UserClient {
    private final UserApi userApi;

    public UserClient(ClientConfiguration configuration) {
        this.userApi = (UserApi)ClientUtils.createRetrofit(configuration).create(UserApi.class);
    }

    public UserInfo currentUser() {
        Response<UserInfo> response = ClientUtils.executeHttpCall(this.userApi.currentUser());
        ClientUtils.assertRespSuccess(response);
        return (UserInfo)response.getData();
    }

    public Integer register(UserRequest userInfo) {
        Preconditions.expectNotBlank((String)userInfo.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be empty");
        Preconditions.expectNotBlank((String)userInfo.getPassword(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"password cannot be empty");
        Response<Integer> response = ClientUtils.executeHttpCall(this.userApi.register(userInfo));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public UserInfo getById(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"user id cannot be null");
        Response<UserInfo> response = ClientUtils.executeHttpCall(this.userApi.getById(id));
        ClientUtils.assertRespSuccess(response);
        return (UserInfo)response.getData();
    }

    public UserInfo getByName(String name) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be null");
        Response<UserInfo> response = ClientUtils.executeHttpCall(this.userApi.getByName(name));
        ClientUtils.assertRespSuccess(response);
        return (UserInfo)response.getData();
    }

    public PageResult<UserInfo> list(UserRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Response<PageResult<UserInfo>> response = ClientUtils.executeHttpCall(this.userApi.list(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Integer update(UserRequest userInfo) {
        Preconditions.expectNotNull((Object)userInfo, (String)"userinfo cannot be null");
        Preconditions.expectNotNull((Object)userInfo.getId(), (String)"user id cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.userApi.update(userInfo));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"user id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.userApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

