/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.AuditAlertRuleApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.audit.AuditAlertRule;
import org.apache.inlong.manager.pojo.audit.AuditAlertRulePageRequest;
import org.apache.inlong.manager.pojo.audit.AuditAlertRuleRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;

public class AuditAlertRuleClient {
    private final AuditAlertRuleApi auditAlertRuleApi;

    public AuditAlertRuleClient(ClientConfiguration configuration) {
        this.auditAlertRuleApi = (AuditAlertRuleApi)ClientUtils.createRetrofit(configuration).create(AuditAlertRuleApi.class);
    }

    public Integer create(AuditAlertRuleRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"audit alert rule request cannot be null");
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong group id cannot be empty");
        Preconditions.expectNotBlank((String)request.getAuditId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"audit id cannot be empty");
        Preconditions.expectNotBlank((String)request.getAlertName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"alert name cannot be empty");
        Preconditions.expectNotNull((Object)request.getCondition(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"condition cannot be null");
        Response<Integer> response = ClientUtils.executeHttpCall(this.auditAlertRuleApi.create(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public AuditAlertRule get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"rule id cannot be null");
        Response<AuditAlertRule> response = ClientUtils.executeHttpCall(this.auditAlertRuleApi.get(id));
        ClientUtils.assertRespSuccess(response);
        return (AuditAlertRule)response.getData();
    }

    public PageResult<AuditAlertRule> listByCondition(AuditAlertRulePageRequest request) {
        Response<PageResult<AuditAlertRule>> response = ClientUtils.executeHttpCall(this.auditAlertRuleApi.listByCondition(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Boolean update(AuditAlertRuleRequest rule) {
        Preconditions.expectNotNull((Object)rule, (String)"audit alert rule cannot be null");
        Preconditions.expectNotNull((Object)rule.getId(), (String)"rule id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.auditAlertRuleApi.update(rule));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"rule id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.auditAlertRuleApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

