/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import java.util.List;
import org.apache.inlong.manager.client.api.InlongCluster;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.common.PageResult;

public class InlongClusterImpl
implements InlongCluster {
    private InlongClusterClient clusterClient;

    public InlongClusterImpl(InlongClientImpl inlongClient) {
        if (this.clusterClient == null) {
            ClientFactory clientFactory = ClientUtils.getClientFactory(inlongClient.getConfiguration());
            this.clusterClient = clientFactory.getClusterClient();
        }
    }

    @Override
    public List<ClusterNodeResponse> listNodes(String clusterName, String clusterType) {
        ClusterPageRequest request = new ClusterPageRequest();
        request.setName(clusterName);
        request.setType(clusterType);
        PageResult<ClusterNodeResponse> clusterNodePage = this.clusterClient.listNode(request);
        return clusterNodePage.getList();
    }

    @Override
    public List<ClusterNodeResponse> listNodes(String clusterName, String clusterType, List<String> clusterTags) {
        ClusterPageRequest request = new ClusterPageRequest();
        request.setName(clusterName);
        request.setType(clusterType);
        request.setClusterTagList(clusterTags);
        PageResult<ClusterNodeResponse> clusterNodePage = this.clusterClient.listNode(request);
        return clusterNodePage.getList();
    }

    @Override
    public List<ClusterNodeResponse> listNodes(String clusterName, String clusterType, String clusterTag) {
        ClusterPageRequest request = new ClusterPageRequest();
        request.setName(clusterName);
        request.setType(clusterType);
        request.setClusterTag(clusterTag);
        PageResult<ClusterNodeResponse> clusterNodePage = this.clusterClient.listNode(request);
        return clusterNodePage.getList();
    }

    @Override
    public ClusterInfo saveCluster(ClusterRequest clusterRequest) {
        int clusterIndex = this.clusterClient.saveCluster(clusterRequest);
        return this.clusterClient.get(clusterIndex);
    }
}

