/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import java.nio.charset.StandardCharsets;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.MsgSenderSingleFactory;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.sender.tcp.InLongTcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientExample {
    private static final Logger logger = LoggerFactory.getLogger(TcpClientExample.class);

    public static void main(String[] args) throws InterruptedException {
        String inlongGroupId = "test_group_id";
        String inlongStreamId = "test_stream_id";
        String configBasePath = "";
        String inLongManagerAddr = "127.0.0.1";
        String inLongManagerPort = "8083";
        int msgType = 7;
        String messageBody = "inglong-message-random-body!";
        MsgSenderSingleFactory senderFactory = new MsgSenderSingleFactory();
        TcpClientExample tcpClientExample = new TcpClientExample();
        TcpMsgSender sender = tcpClientExample.getMessageSender(senderFactory, false, inLongManagerAddr, inLongManagerPort, inlongGroupId, msgType, false, configBasePath);
        tcpClientExample.sendTcpMessage(sender, inlongGroupId, inlongStreamId, System.currentTimeMillis(), messageBody);
        senderFactory.shutdownAll();
    }

    public TcpMsgSender getMessageSender(MsgSenderFactory senderFactory, boolean visitMgrByHttps, String managerAddr, String managerPort, String inlongGroupId, int msgType, boolean useLocalMetaConfig, String configBasePath) {
        InLongTcpMsgSender messageSender = null;
        try {
            TcpMsgSenderConfig tcpConfig = new TcpMsgSenderConfig(visitMgrByHttps, managerAddr, Integer.parseInt(managerPort), inlongGroupId, "admin", "inlong");
            tcpConfig.setMetaStoreBasePath(configBasePath);
            tcpConfig.setOnlyUseLocalProxyConfig(useLocalMetaConfig);
            tcpConfig.setSdkMsgType(MsgType.valueOf(msgType));
            tcpConfig.setRequestTimeoutMs(20000L);
            messageSender = senderFactory.genTcpSenderByClusterId(tcpConfig);
        }
        catch (Throwable ex) {
            System.out.println("Get MessageSender throw exception, " + ex);
        }
        return messageSender;
    }

    public void sendTcpMessage(TcpMsgSender sender, String inlongGroupId, String inlongStreamId, long dt, String messageBody) {
        ProcessResult procResult = new ProcessResult();
        try {
            sender.sendMessage(new TcpEventInfo(inlongGroupId, inlongStreamId, dt, null, messageBody.getBytes(StandardCharsets.UTF_8)), procResult);
        }
        catch (Throwable ex) {
            System.out.println("Message sent throw exception, " + ex);
            return;
        }
        System.out.println("Message sent result = " + procResult);
        logger.info("Message sent result = {}", (Object)procResult);
    }
}

