/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

public class CreateCatalogFunctionOperation
implements CreateOperation {
    private final ObjectIdentifier functionIdentifier;
    private CatalogFunction catalogFunction;
    private boolean ignoreIfExists;
    private boolean isTemporary;

    public CreateCatalogFunctionOperation(ObjectIdentifier functionIdentifier, CatalogFunction catalogFunction, boolean ignoreIfExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.catalogFunction = catalogFunction;
        this.ignoreIfExists = ignoreIfExists;
        this.isTemporary = isTemporary;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogFunction", this.catalogFunction.getDetailedDescription());
        params.put("identifier", this.functionIdentifier);
        params.put("ignoreIfExists", this.ignoreIfExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("CREATE CATALOG FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }
}

