/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.util.Preconditions;

public class CatalogDatabaseImpl
implements CatalogDatabase {
    private final Map<String, String> properties;
    private final String comment;

    public CatalogDatabaseImpl(Map<String, String> properties, @Nullable String comment) {
        this.properties = (Map)Preconditions.checkNotNull(properties, (String)"properties cannot be null");
        this.comment = comment;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getComment() {
        return this.comment;
    }

    public CatalogDatabase copy() {
        return this.copy(this.getProperties());
    }

    public CatalogDatabase copy(Map<String, String> properties) {
        return new CatalogDatabaseImpl(new HashMap<String, String>(properties), this.comment);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<String> getDetailedDescription() {
        return Optional.ofNullable(this.comment);
    }
}

