/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.transform;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.FuzzyScore;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.transform.TransformFunctionDocRequest;
import org.apache.inlong.manager.pojo.transform.TransformFunctionDocResponse;
import org.apache.inlong.manager.service.transform.TransformFunctionDocService;
import org.apache.inlong.sdk.transform.process.function.FunctionTools;
import org.apache.inlong.sdk.transform.process.pojo.FunctionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransformFunctionDocServiceImpl
implements TransformFunctionDocService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformFunctionDocServiceImpl.class);
    private final Map<String, Set<FunctionInfo>> functionDocMap = FunctionTools.getFunctionDoc();
    private final FuzzyScore fuzzyScore = new FuzzyScore(Locale.ENGLISH);
    private static final int FUZZY_THRESHOLD = 5;

    @Override
    public PageResult<TransformFunctionDocResponse> listByCondition(TransformFunctionDocRequest request) {
        String type = request.getType();
        String name = request.getName();
        int pageNum = request.getPageNum();
        int pageSize = request.getPageSize();
        LOGGER.info("begin to query transform function info: {}", (Object)request);
        List filteredFunctionInfos = Optional.ofNullable(this.filterFunctionInfos(type, name, false)).filter(list -> !list.isEmpty()).orElseGet(() -> {
            LOGGER.info("do not found transform function name: {}, fuzzy match enabled", (Object)name);
            return this.filterFunctionInfos(type, name, true);
        });
        return this.paginateFunctionInfos(filteredFunctionInfos, pageNum, pageSize);
    }

    private List<FunctionInfo> filterFunctionInfos(String type, String name, boolean fuzzyMatch) {
        List<FunctionInfo> functionInfos = this.functionDocMap.entrySet().stream().filter(entry -> Optional.ofNullable(type).map(t -> ((String)entry.getKey()).equals(t)).orElse(true)).flatMap(entry -> ((Set)entry.getValue()).stream()).filter(functionInfo -> Optional.ofNullable(name).map(n -> fuzzyMatch ? this.isFuzzyMatch((String)n, functionInfo.getFunctionName()) : functionInfo.getFunctionName().toLowerCase().contains(n.toLowerCase())).orElse(true)).collect(Collectors.toList());
        return fuzzyMatch ? functionInfos.stream().sorted(Comparator.comparingInt(f -> this.fuzzyScore.fuzzyScore((CharSequence)f.getFunctionName(), (CharSequence)name)).reversed()).collect(Collectors.toList()) : functionInfos;
    }

    private boolean isFuzzyMatch(String input, String target) {
        return this.fuzzyScore.fuzzyScore((CharSequence)target, (CharSequence)input) >= 5;
    }

    private PageResult<TransformFunctionDocResponse> paginateFunctionInfos(List<FunctionInfo> functionInfos, int pageNum, int pageSize) {
        int totalItems = functionInfos.size();
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, totalItems);
        return Optional.of(startIndex).filter(index -> index < totalItems).map(index -> {
            List responseList = functionInfos.subList(startIndex, endIndex).stream().map(functionInfo -> new TransformFunctionDocResponse(functionInfo.getFunctionName(), functionInfo.getExplanation(), functionInfo.getExample())).collect(Collectors.toList());
            LOGGER.info("Transform function list query success. Total results: {}", (Object)totalItems);
            return new PageResult(responseList, Long.valueOf(totalItems), Integer.valueOf(pageNum), Integer.valueOf(pageSize));
        }).orElseGet(() -> {
            LOGGER.error("Error in transform function query pagination, startIndex: {}, totalItems: {}", (Object)startIndex, (Object)totalItems);
            return PageResult.empty((Long)Long.valueOf(totalItems));
        });
    }
}

