/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink;

import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.sink.StreamSinkOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinkOperatorFactory {
    @Autowired
    private List<StreamSinkOperator> sinkOperatorList;

    public StreamSinkOperator getInstance(String sinkType) {
        return this.sinkOperatorList.stream().filter(inst -> inst.accept(sinkType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage(), sinkType)));
    }
}

