/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.schedule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.ScheduleStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.ScheduleEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.ScheduleEntityMapper;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfoRequest;
import org.apache.inlong.manager.service.schedule.ScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static Logger LOGGER = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private ScheduleEntityMapper scheduleEntityMapper;
    private Map<ScheduleStatus, Set<ScheduleStatus>> fsm;

    @Override
    public int save(ScheduleInfoRequest request, String operator) {
        LOGGER.debug("begin to save schedule info, scheduleInfo={}, operator={}", (Object)request, (Object)operator);
        String groupId = request.getInlongGroupId();
        this.checkGroupExist(groupId);
        if (this.scheduleEntityMapper.selectByGroupId(groupId) != null) {
            LOGGER.error("schedule info for group={} already exists", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.SCHEDULE_DUPLICATE);
        }
        ScheduleEntity scheduleEntity = (ScheduleEntity)CommonBeanUtils.copyProperties((Object)request, ScheduleEntity::new);
        scheduleEntity.setStatus(ScheduleStatus.NEW.getCode());
        scheduleEntity.setCreator(operator);
        scheduleEntity.setModifier(operator);
        this.scheduleEntityMapper.insert(scheduleEntity);
        return scheduleEntity.getId();
    }

    @Override
    public Boolean exist(String groupId) {
        this.checkGroupExist(groupId);
        return this.scheduleEntityMapper.selectByGroupId(groupId) != null;
    }

    @Override
    public ScheduleInfo get(String groupId) {
        LOGGER.debug("begin to get schedule info by groupId={}", (Object)groupId);
        ScheduleEntity entity = this.getScheduleEntity(groupId);
        return (ScheduleInfo)CommonBeanUtils.copyProperties((Object)entity, ScheduleInfo::new);
    }

    @Override
    public Boolean update(ScheduleInfoRequest request, String operator) {
        LOGGER.debug("begin to update schedule info={}", (Object)request);
        String groupId = request.getInlongGroupId();
        ScheduleEntity entity = this.getScheduleEntity(groupId);
        String errMsg = String.format("schedule info has already been updated with groupId=%s, curVersion=%s, expectVersion=%s", entity.getInlongGroupId(), request.getVersion(), entity.getVersion());
        if (!Objects.equals(entity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)entity, (boolean)true);
        entity.setModifier(operator);
        this.updateScheduleInfo(entity, errMsg);
        LOGGER.info("success to update schedule info for groupId={}", (Object)groupId);
        return true;
    }

    @Override
    public Boolean updateStatus(String groupId, ScheduleStatus newStatus, String operator) {
        LOGGER.debug("begin to update schedule status for groupId={}", (Object)groupId);
        ScheduleEntity entity = this.getScheduleEntity(groupId);
        ScheduleStatus preStatus = ScheduleStatus.forCode((int)entity.getStatus());
        if (!this.isAllowedTransition(preStatus, newStatus)) {
            String errorMsg = String.format("Schedule status transition is not allowed from %s to %s for group %s", preStatus, newStatus, groupId);
            LOGGER.error(errorMsg);
            throw new BusinessException(ErrorCodeEnum.SCHEDULE_STATUS_TRANSITION_NOT_ALLOWED);
        }
        entity.setStatus(newStatus.getCode());
        entity.setModifier(operator);
        this.updateScheduleInfo(entity, String.format("update schedule status from %s to %s failed for groupId=%s", preStatus.getCode(), newStatus.getCode(), entity.getInlongGroupId()));
        LOGGER.info("success to update schedule status from {} to {} for groupId={}", new Object[]{preStatus.getCode(), newStatus.getCode(), groupId});
        return true;
    }

    private void initFSMIfNeed() {
        if (this.fsm != null) {
            return;
        }
        this.fsm = new HashMap<ScheduleStatus, Set<ScheduleStatus>>();
        this.fsm.put(ScheduleStatus.NEW, new HashSet<ScheduleStatus>(Arrays.asList(ScheduleStatus.APPROVED, ScheduleStatus.DELETED)));
        this.fsm.put(ScheduleStatus.APPROVED, new HashSet<ScheduleStatus>(Arrays.asList(ScheduleStatus.REGISTERED, ScheduleStatus.DELETED)));
        this.fsm.put(ScheduleStatus.REGISTERED, new HashSet<ScheduleStatus>(Arrays.asList(ScheduleStatus.UPDATED, ScheduleStatus.DELETED)));
        this.fsm.put(ScheduleStatus.UPDATED, new HashSet<ScheduleStatus>(Arrays.asList(ScheduleStatus.REGISTERED, ScheduleStatus.DELETED)));
    }

    private boolean isAllowedTransition(ScheduleStatus preStatus, ScheduleStatus newStatus) {
        this.initFSMIfNeed();
        return this.fsm.get(preStatus).contains(newStatus);
    }

    @Override
    public Boolean deleteByGroupId(String groupId, String operator) {
        LOGGER.debug("begin to delete schedule info for groupId={}", (Object)groupId);
        this.checkGroupExist(groupId);
        ScheduleEntity entity = this.scheduleEntityMapper.selectByGroupId(groupId);
        if (entity == null) {
            LOGGER.error("schedule info for groupId={} does not exist", (Object)groupId);
            return false;
        }
        entity.setPreviousStatus(entity.getStatus());
        entity.setStatus(ScheduleStatus.DELETED.getCode());
        entity.setModifier(operator);
        entity.setIsDeleted(entity.getId());
        this.updateScheduleInfo(entity, String.format("schedule info has already been updated with groupId=%s, curVersion=%s", entity.getInlongGroupId(), entity.getVersion()));
        LOGGER.info("success to delete schedule info for groupId={}", (Object)groupId);
        return true;
    }

    private void checkGroupExist(String groupId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            LOGGER.error("inlong group not found by groupId={}", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
    }

    private ScheduleEntity getScheduleEntity(String groupId) {
        this.checkGroupExist(groupId);
        ScheduleEntity entity = this.scheduleEntityMapper.selectByGroupId(groupId);
        if (entity == null) {
            LOGGER.error("schedule info for group={} not found", (Object)groupId);
            throw new BusinessException(ErrorCodeEnum.SCHEDULE_NOT_FOUND);
        }
        return entity;
    }

    private void updateScheduleInfo(ScheduleEntity entity, String errorMsg) {
        if (this.scheduleEntityMapper.updateByIdSelective(entity) != InlongConstants.AFFECTED_ONE_ROW.intValue()) {
            LOGGER.error(errorMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }
}

