/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.queue;

import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.workflow.form.process.ClusterResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.cluster.ClusterConfigService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.ClusterOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterConfigListener
implements ClusterOperateListener {
    private static final Logger log = LoggerFactory.getLogger(ClusterConfigListener.class);
    @Autowired
    private ClusterConfigService clusterConfigService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        return processForm instanceof ClusterResourceProcessForm;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ClusterResourceProcessForm clusterProcessForm = (ClusterResourceProcessForm)context.getProcessForm();
        log.info("begin to execute ClusterConfigListener for clusterTag={}", (Object)clusterProcessForm.getInlongClusterTag());
        String clusterTag = clusterProcessForm.getInlongClusterTag();
        String operator = context.getOperator();
        this.clusterConfigService.refresh(clusterTag, operator);
        log.info("success to execute ClusterConfigListener for clusterTag={}", (Object)clusterProcessForm.getInlongClusterTag());
        return ListenerResult.success((String)"success");
    }
}

