/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.common.pojo.sdk.SortSourceConfigResponse;
import org.apache.inlong.common.pojo.sort.ClusterTagConfig;
import org.apache.inlong.common.pojo.sort.SortConfig;
import org.apache.inlong.common.pojo.sort.SortConfigResponse;
import org.apache.inlong.common.pojo.sort.TaskConfig;
import org.apache.inlong.common.pojo.sort.dataflow.DataFlowConfig;
import org.apache.inlong.common.pojo.sort.mq.MqClusterConfig;
import org.apache.inlong.common.pojo.sort.mq.PulsarClusterConfig;
import org.apache.inlong.common.pojo.sort.mq.TubeClusterConfig;
import org.apache.inlong.common.pojo.sort.node.NodeConfig;
import org.apache.inlong.common.pojo.sortstandalone.SortClusterResponse;
import org.apache.inlong.common.util.Utils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.plugin.Plugin;
import org.apache.inlong.manager.common.plugin.PluginBinder;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ClusterConfigEntity;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.SortConfigEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusRequest;
import org.apache.inlong.manager.service.core.ConfigLoader;
import org.apache.inlong.manager.service.core.SortClusterService;
import org.apache.inlong.manager.service.core.SortService;
import org.apache.inlong.manager.service.core.SortSourceService;
import org.apache.inlong.manager.service.core.impl.SortSourceServiceImpl;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.node.DataNodeOperator;
import org.apache.inlong.manager.service.node.DataNodeOperatorFactory;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.plugin.sort.PollerPlugin;
import org.apache.inlong.manager.workflow.plugin.sort.SortPoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Lazy
@Service
public class SortServiceImpl
implements SortService,
PluginBinder {
    private static final Logger log = LoggerFactory.getLogger(SortServiceImpl.class);
    private static final int RESPONSE_CODE_SUCCESS = 0;
    private static final int RESPONSE_CODE_NO_UPDATE = 1;
    private static final int RESPONSE_CODE_FAIL = -1;
    private static final int RESPONSE_CODE_REQUEST_PARAMS_ERROR = -101;
    @Lazy
    @Autowired
    private SortSourceService sortSourceService;
    @Lazy
    @Autowired
    private SortClusterService sortClusterService;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private ConfigLoader configLoader;
    @Autowired
    private DataNodeOperatorFactory dataNodeOperatorFactory;
    private Map<String, byte[]> sortConfigMap = new ConcurrentHashMap<String, byte[]>();
    private Map<String, String> sortConfigMd5Map = new ConcurrentHashMap<String, String>();
    private Map<String, List<MqClusterConfig>> mqClusterConfigMap = new ConcurrentHashMap<String, List<MqClusterConfig>>();
    private Map<String, NodeConfig> nodeInfoMap = new ConcurrentHashMap<String, NodeConfig>();
    private SortPoller sortPoller;

    @PostConstruct
    public void initialize() {
        log.info("create SortServiceImpl for " + SortSourceServiceImpl.class.getSimpleName());
        try {
            this.reload();
            this.setReloadTimer();
        }
        catch (Throwable t) {
            log.error("initialize SortServiceImpl error", t);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void reload() {
        log.debug("start to reload sort config.");
        try {
            this.reloadMqCluster();
            this.reloadNodeConfig();
            this.reloadDataFlowConfig();
        }
        catch (Throwable t) {
            log.error("fail to reload all sort config", t);
        }
        log.debug("end to reload config");
    }

    private void setReloadTimer() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        long reloadInterval = 60000L;
        executorService.scheduleWithFixedDelay(this::reload, reloadInterval, reloadInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public SortClusterResponse getClusterConfig(String clusterName, String md5) {
        return this.sortClusterService.getClusterConfig(clusterName, md5);
    }

    @Override
    public SortSourceConfigResponse getSourceConfig(String clusterName, String sortTaskId, String md5) {
        return this.sortSourceService.getSourceConfig(clusterName, sortTaskId, md5);
    }

    @Override
    public List<SortStatusInfo> listSortStatus(SortStatusRequest request) {
        Preconditions.expectNotNull((Object)this.sortPoller, (String)"sort status poller not initialized, please try later");
        try {
            List<InlongGroupInfo> groupInfoList = request.getInlongGroupIds().stream().map(groupId -> {
                try {
                    return this.groupService.get((String)groupId);
                }
                catch (Exception e) {
                    log.error("can not get groupId: {}, skip it", groupId, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList streamInfos = new ArrayList();
            groupInfoList.forEach(groupInfo -> streamInfos.addAll(this.streamService.list(groupInfo.getInlongGroupId())));
            List statusInfos = this.sortPoller.pollSortStatus(streamInfos, request.getCredentials());
            log.debug("success to list sort status for request={}, result={}", (Object)request, (Object)statusInfos);
            return statusInfos;
        }
        catch (Exception e) {
            log.error("poll sort status error: ", (Throwable)e);
            throw new BusinessException("poll sort status error: " + e.getMessage());
        }
    }

    public void acceptPlugin(Plugin plugin) {
        if (plugin instanceof PollerPlugin) {
            PollerPlugin pollerPlugin = (PollerPlugin)plugin;
            this.sortPoller = pollerPlugin.getSortPoller();
        }
    }

    @Override
    public SortConfigResponse getSortConfig(String clusterName, String md5) {
        if (StringUtils.isBlank((CharSequence)clusterName)) {
            String errMsg = "cluster name is blank, return nothing";
            log.debug(errMsg);
            return SortConfigResponse.builder().code(-101).msg(errMsg).build();
        }
        if (!this.sortConfigMap.containsKey(clusterName)) {
            String errMsg = String.format("there is no valid sort config of cluster %s", clusterName);
            log.debug(errMsg);
            return SortConfigResponse.builder().code(-1).msg(errMsg).build();
        }
        if (this.sortConfigMd5Map.get(clusterName).equals(md5)) {
            return SortConfigResponse.builder().code(1).msg("No update").md5(md5).build();
        }
        return SortConfigResponse.builder().code(0).data(this.sortConfigMap.get(clusterName)).md5(this.sortConfigMd5Map.get(clusterName)).build();
    }

    private void reloadMqCluster() {
        HashMap<String, List<MqClusterConfig>> tempMqClusterMap = new HashMap<String, List<MqClusterConfig>>();
        List<ClusterConfigEntity> clusterConfigEntityList = this.configLoader.loadAllClusterConfigEntity();
        clusterConfigEntityList.forEach(clusterConfigEntity -> {
            String clusterTag = clusterConfigEntity.getClusterTag();
            if ("PULSAR".equals(clusterConfigEntity.getClusterType())) {
                List pulsarClusterConfigs = JsonUtils.parseArray((String)clusterConfigEntity.getConfigParams(), PulsarClusterConfig.class);
                ArrayList list = new ArrayList(pulsarClusterConfigs);
                tempMqClusterMap.putIfAbsent(clusterTag, list);
            } else if ("TUBEMQ".equals(clusterConfigEntity.getClusterType())) {
                List tubeClusterConfigs = JsonUtils.parseArray((String)clusterConfigEntity.getConfigParams(), TubeClusterConfig.class);
                ArrayList list = new ArrayList(tubeClusterConfigs);
                tempMqClusterMap.putIfAbsent(clusterTag, list);
            }
        });
        this.mqClusterConfigMap = tempMqClusterMap;
    }

    private void reloadNodeConfig() {
        List<DataNodeEntity> dataNodeEntities = this.configLoader.loadAllDataNodeEntity();
        Map<String, NodeConfig> task2DataNodeMap = dataNodeEntities.stream().filter(entity -> StringUtils.isNotBlank((CharSequence)entity.getName())).map(entity -> {
            try {
                DataNodeOperator operator = this.dataNodeOperatorFactory.getInstance(entity.getType());
                return operator.getNodeConfig((DataNodeEntity)entity);
            }
            catch (Exception e) {
                log.error("parse node config error for data node name={}", (Object)entity.getName(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(NodeConfig::getNodeName, info -> info));
        this.nodeInfoMap = task2DataNodeMap;
    }

    private void reloadDataFlowConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, byte[]> sortConfigs = new HashMap<String, byte[]>();
        HashMap<String, String> sortConfigMd5s = new HashMap<String, String>();
        HashMap<String, List> temp = new HashMap<String, List>();
        List<SortConfigEntity> sinkConfigEntityList = this.configLoader.loadAllSortConfigEntity();
        for (SortConfigEntity sortConfigEntity : sinkConfigEntityList) {
            if (!StringUtils.isBlank((CharSequence)sortConfigEntity.getSortTaskName())) continue;
            sortConfigEntity.setSortTaskName("DEFAULT_TASK");
        }
        Map<String, Map<String, Map<String, List<SortConfigEntity>>>> cluster2SinkMap = sinkConfigEntityList.stream().collect(Collectors.groupingBy(SortConfigEntity::getInlongClusterName, Collectors.groupingBy(SortConfigEntity::getSortTaskName, Collectors.groupingBy(SortConfigEntity::getInlongClusterTag))));
        for (String sortClusterName : cluster2SinkMap.keySet()) {
            List map = temp.computeIfAbsent(sortClusterName, v -> new ArrayList());
            SortConfig sortConfig = new SortConfig();
            sortConfig.setSortClusterName(sortClusterName);
            Map<String, Map<String, List<SortConfigEntity>>> sortTaskNameMap = cluster2SinkMap.get(sortClusterName);
            for (String sortTaskName : sortTaskNameMap.keySet()) {
                Map<String, List<SortConfigEntity>> clusterTagMap = sortTaskNameMap.get(sortTaskName);
                TaskConfig sortTaskConfig = TaskConfig.builder().sortTaskName(sortTaskName).clusterTagConfigs(new ArrayList()).nodeConfig(this.nodeInfoMap.get(sortTaskName)).build();
                for (String clusterTag : clusterTagMap.keySet()) {
                    List<SortConfigEntity> sinkConfigEntities = clusterTagMap.get(clusterTag);
                    List dataFlowConfigs = sinkConfigEntities.stream().map(v -> {
                        try {
                            return (DataFlowConfig)objectMapper.readValue(v.getConfigParams(), DataFlowConfig.class);
                        }
                        catch (Exception e) {
                            log.error("parse data flow config error for sinkId={}", (Object)v.getSinkId(), (Object)e);
                            return null;
                        }
                    }).filter(Objects::nonNull).sorted(Comparator.comparingInt(x -> Integer.parseInt(x.getDataflowId()))).collect(Collectors.toList());
                    ClusterTagConfig sortClusterConfig = ClusterTagConfig.builder().mqClusterConfigs((List)this.mqClusterConfigMap.getOrDefault(clusterTag, new ArrayList())).clusterTag(clusterTag).dataFlowConfigs(dataFlowConfigs).build();
                    sortTaskConfig.getClusterTagConfigs().add(sortClusterConfig);
                }
                map.add(sortTaskConfig);
            }
            sortConfig.setTasks((List)temp.get(sortClusterName));
            try {
                String configStr = objectMapper.writeValueAsString((Object)sortConfig);
                sortConfigs.put(sortClusterName, Utils.compressGZip((byte[])configStr.getBytes()));
                String md5 = DigestUtils.md5Hex((String)configStr);
                sortConfigMd5s.put(sortClusterName, md5);
            }
            catch (Exception e) {
                log.info("parse sort config error for cluster name={}", (Object)sortClusterName, (Object)e);
            }
        }
        this.sortConfigMap = sortConfigs;
        this.sortConfigMd5Map = sortConfigMd5s;
    }
}

