/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cmd;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.service.cmd.CommandExecutor;
import org.apache.inlong.manager.service.cmd.CommandResult;
import org.apache.inlong.manager.service.cmd.shell.ShellExecutorImpl;
import org.apache.inlong.manager.service.cmd.shell.ShellTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommandExecutorImpl
implements CommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutorImpl.class);

    @Override
    public CommandResult exec(String cmd) throws Exception {
        ShellTracker shellTracker = new ShellTracker();
        ShellExecutorImpl shellExecutor = new ShellExecutorImpl(shellTracker);
        shellExecutor.syncExec("sh", "-c", cmd);
        String cmdMsg = String.join((CharSequence)" ", "sh", "-c", cmd);
        LOG.debug("run command : {}", (Object)cmdMsg);
        CommandResult commandResult = new CommandResult();
        commandResult.setCode(shellTracker.getCode());
        commandResult.setResult(String.join((CharSequence)" ", shellTracker.getResult()));
        if (commandResult.getCode() != 0) {
            throw new Exception("command " + cmdMsg + " exec failed, code = " + commandResult.getCode() + ", output = " + commandResult.getResult());
        }
        LOG.debug(commandResult.getResult());
        return commandResult;
    }

    @Override
    public CommandResult execSSHKeyGeneration() throws Exception {
        String cmdShell = "./conf/ssh_key_cmd.exp";
        ShellTracker shellTracker = new ShellTracker();
        ShellExecutorImpl shellExecutor = new ShellExecutorImpl(shellTracker);
        shellExecutor.syncExec(cmdShell, new String[0]);
        CommandResult commandResult = new CommandResult();
        commandResult.setCode(shellTracker.getCode());
        commandResult.setResult(String.join((CharSequence)" ", shellTracker.getResult()));
        LOG.debug(commandResult.getResult());
        if (commandResult.getCode() != 0) {
            throw new Exception("SSH key generation failed, code = " + commandResult.getCode() + ", output = " + commandResult.getResult());
        }
        LOG.debug(commandResult.getResult());
        return commandResult;
    }

    @Override
    public CommandResult execRemote(AgentClusterNodeRequest clusterNodeRequest, String cmd) throws Exception {
        String cmdShell = "./conf/exec_cmd.exp";
        String ip = clusterNodeRequest.getIp();
        String port = String.valueOf(clusterNodeRequest.getSshPort());
        String user = clusterNodeRequest.getUsername();
        String password = clusterNodeRequest.getPassword();
        String remoteCommandTimeout = "20000";
        if (StringUtils.isBlank((String)password)) {
            password = "";
        }
        cmd = "sh -c \"" + cmd + "\"";
        String cmdMsg = String.join((CharSequence)" ", cmdShell, ip, user, password, remoteCommandTimeout, cmd, port);
        LOG.info("run remote command : {}", (Object)cmdMsg);
        ShellTracker shellTracker = new ShellTracker();
        ShellExecutorImpl shellExecutor = new ShellExecutorImpl(shellTracker);
        shellExecutor.syncExec(cmdShell, ip, user, password, remoteCommandTimeout, cmd, port);
        CommandResult commandResult = new CommandResult();
        commandResult.setCode(shellTracker.getCode());
        commandResult.setResult(String.join((CharSequence)" ", shellTracker.getResult()));
        LOG.debug(commandResult.getResult());
        if (commandResult.getCode() != 0) {
            throw new Exception("remote command " + cmdMsg + " exec failed, code = " + commandResult.getCode() + ", output = " + commandResult.getResult());
        }
        return commandResult;
    }

    @Override
    public CommandResult modifyConfig(AgentClusterNodeRequest clusterNodeRequest, Map<String, String> configMap, String confPath) throws Exception {
        List configList = configMap.entrySet().stream().map(entry -> "grep " + (String)entry.getKey() + " " + confPath + " && sed -i 's%^" + (String)entry.getKey() + ".*%" + (String)entry.getKey() + "=" + (String)entry.getValue() + "%' " + confPath + " || echo " + (String)entry.getKey() + "=" + (String)entry.getValue() + " >> " + confPath).collect(Collectors.toList());
        String modifyCmd = StringUtils.join(configList, (String)";");
        return this.execRemote(clusterNodeRequest, modifyCmd);
    }

    @Override
    public CommandResult tarPackage(AgentClusterNodeRequest clusterNodeRequest, String fileName, String sourcePath, String tarPath) throws Exception {
        String tarCmd = "tar -zxvf " + sourcePath + fileName + " -C " + tarPath;
        return this.execRemote(clusterNodeRequest, tarCmd);
    }

    @Override
    public CommandResult downLoadPackage(AgentClusterNodeRequest clusterNodeRequest, String downLoadPath, String downLoadUrl) throws Exception {
        return this.execRemote(clusterNodeRequest, "wget -P " + downLoadPath + " " + downLoadUrl);
    }

    @Override
    public CommandResult mkdir(AgentClusterNodeRequest clusterNodeRequest, String path) throws Exception {
        return this.execRemote(clusterNodeRequest, "mkdir " + path);
    }

    @Override
    public CommandResult rmDir(AgentClusterNodeRequest clusterNodeRequest, String path) throws Exception {
        return this.execRemote(clusterNodeRequest, "rm -rf " + path);
    }

    @Override
    public CommandResult cpDir(AgentClusterNodeRequest clusterNodeRequest, String sourcePath, String targetPath) throws Exception {
        return this.execRemote(clusterNodeRequest, "if [ -e " + sourcePath + " ]; then cp " + sourcePath + " " + targetPath + "; fi");
    }
}

