/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.audit.AuditConfig;
import org.apache.inlong.common.pojo.audit.MQInfo;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeInfo;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeResponse;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.NodeStatus;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterNodeEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterTagEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.TenantClusterTagEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterNodeEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterTagEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantClusterTagEntityMapper;
import org.apache.inlong.manager.pojo.cluster.BindTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.cluster.InlongClusterTagExtParam;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagInfo;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.agent.AgentClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterDTO;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterNodeDTO;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterDTO;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarDTO;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.user.InlongRoleInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.apache.inlong.manager.service.cluster.InlongClusterOperatorFactory;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeInstallOperator;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeInstallOperatorFactory;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeOperator;
import org.apache.inlong.manager.service.cluster.node.InlongClusterNodeOperatorFactory;
import org.apache.inlong.manager.service.cmd.CommandExecutor;
import org.apache.inlong.manager.service.cmd.CommandResult;
import org.apache.inlong.manager.service.repository.DataProxyConfigRepository;
import org.apache.inlong.manager.service.tenant.InlongTenantService;
import org.apache.inlong.manager.service.user.InlongRoleService;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InlongClusterServiceImpl
implements InlongClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongClusterServiceImpl.class);
    private static final Gson GSON = new Gson();
    private final ExecutorService executorService = new ThreadPoolExecutor(10, 20, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("agent-install-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    private final LinkedBlockingQueue<ClusterNodeRequest> pendingInstallRequests = new LinkedBlockingQueue();
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongClusterOperatorFactory clusterOperatorFactory;
    @Autowired
    private InlongClusterNodeOperatorFactory clusterNodeOperatorFactory;
    @Autowired
    private InlongClusterTagEntityMapper clusterTagMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private InlongClusterNodeEntityMapper clusterNodeMapper;
    @Autowired
    private TenantClusterTagEntityMapper tenantClusterTagMapper;
    @Autowired
    private InlongTenantService tenantService;
    @Autowired
    private InlongRoleService inlongRoleService;
    @Autowired
    private TenantRoleService tenantRoleService;
    @Autowired
    private InlongClusterNodeInstallOperatorFactory clusterNodeInstallOperatorFactory;
    @Autowired
    private CommandExecutor commandExecutor;
    @Lazy
    @Autowired
    private DataProxyConfigRepository proxyRepository;

    @PostConstruct
    private void startInstallTask() {
        this.processInstall();
        this.setReloadTimer();
        LOGGER.info("install task started successfully");
    }

    private void setReloadTimer() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        long reloadInterval = 60000L;
        executorService.scheduleWithFixedDelay(this::processInstall, reloadInterval, reloadInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public Integer saveTag(ClusterTagRequest request, String operator) {
        LOGGER.debug("begin to save cluster tag {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        Preconditions.expectNotBlank((String)request.getClusterTag(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tag cannot be empty");
        String clusterTag = request.getClusterTag();
        InlongClusterTagEntity exist = this.clusterTagMapper.selectByTag(clusterTag);
        if (exist != null) {
            String errMsg = String.format("inlong cluster tag [%s] already exist", clusterTag);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongClusterTagEntity entity = (InlongClusterTagEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterTagEntity::new);
        request.setExtParams(entity.getExtParams());
        String extParam = InlongClusterTagExtParam.packExtParams((ClusterTagRequest)request);
        entity.setExtParams(extParam);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.clusterTagMapper.insert(entity);
        if (CollectionUtils.isNotEmpty((Collection)request.getTenantList())) {
            TenantClusterTagRequest tagRequest = new TenantClusterTagRequest();
            tagRequest.setClusterTag(clusterTag);
            request.getTenantList().forEach(tenant -> {
                tagRequest.setTenant(tenant);
                this.saveTenantTag(tagRequest, operator);
            });
        }
        LOGGER.info("success to save cluster tag={} by user={}", (Object)request, (Object)operator);
        return entity.getId();
    }

    @Override
    public ClusterTagResponse getTag(Integer id, String currentUser) {
        Preconditions.expectNotNull((Object)id, (String)"inlong cluster tag id cannot be empty");
        InlongClusterTagEntity entity = this.clusterTagMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong cluster tag not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        ClusterTagResponse response = (ClusterTagResponse)CommonBeanUtils.copyProperties((Object)entity, ClusterTagResponse::new);
        InlongClusterTagExtParam.unpackExtParams((ClusterTagResponse)response);
        List tenantList = this.tenantClusterTagMapper.selectByTag(entity.getClusterTag()).stream().map(TenantClusterTagEntity::getTenant).collect(Collectors.toList());
        response.setTenantList(tenantList);
        LOGGER.debug("success to get cluster tag info by id={}", (Object)id);
        return response;
    }

    @Override
    public PageResult<ClusterTagResponse> listTag(ClusterTagPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.clusterTagMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            ClusterTagResponse response = (ClusterTagResponse)CommonBeanUtils.copyProperties((Object)entity, ClusterTagResponse::new);
            InlongClusterTagExtParam.unpackExtParams((ClusterTagResponse)response);
            List tenantList = this.tenantClusterTagMapper.selectByTag(entity.getClusterTag()).stream().map(TenantClusterTagEntity::getTenant).collect(Collectors.toList());
            response.setTenantList(tenantList);
            return response;
        });
        LOGGER.debug("success to list cluster tag by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<ClusterTagResponse> listTag(ClusterTagPageRequest request, UserInfo opInfo) {
        ArrayList<InlongClusterTagEntity> filterResult = new ArrayList<InlongClusterTagEntity>();
        List clusterTagEntities = this.clusterTagMapper.selectByCondition(request);
        if (CollectionUtils.isNotEmpty((Collection)clusterTagEntities)) {
            for (InlongClusterTagEntity tagEntity : clusterTagEntities) {
                List<String> inCharges;
                if (!opInfo.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()) && !(inCharges = Arrays.asList(tagEntity.getInCharges().split(","))).contains(opInfo.getName())) continue;
                filterResult.add(tagEntity);
            }
        }
        return CommonBeanUtils.copyListProperties(filterResult, ClusterTagResponse::new);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public Boolean updateTag(ClusterTagRequest request, String operator) {
        LOGGER.debug("begin to update cluster tag={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        Integer id = request.getId();
        Preconditions.expectNotNull((Object)id, (String)"cluster tag id cannot be empty");
        InlongClusterTagEntity exist = this.clusterTagMapper.selectById(id);
        if (exist == null) {
            LOGGER.warn("inlong cluster tag was not exist for id={}", (Object)id);
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)request.getClusterTag())) {
            request.setClusterTag(exist.getClusterTag());
        }
        String newClusterTag = request.getClusterTag();
        String errMsg = String.format("cluster tag has already updated with name=%s, curVersion=%s", exist.getClusterTag(), request.getVersion());
        if (!Objects.equals(exist.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        String oldClusterTag = exist.getClusterTag();
        if (!newClusterTag.equals(oldClusterTag)) {
            InlongClusterTagEntity tagConflict = this.clusterTagMapper.selectByTag(newClusterTag);
            if (tagConflict != null) {
                String tagErrMsg = String.format("inlong cluster tag [%s] already exist", newClusterTag);
                LOGGER.error(tagErrMsg);
                throw new BusinessException(tagErrMsg);
            }
            this.assertNoInlongGroupExists(oldClusterTag);
            List clusterEntities = this.clusterMapper.selectByKey(oldClusterTag, null, null);
            if (CollectionUtils.isNotEmpty((Collection)clusterEntities)) {
                clusterEntities.forEach(entity -> {
                    HashSet tagSet = Sets.newHashSet((Object[])entity.getClusterTags().split(","));
                    tagSet.remove(oldClusterTag);
                    tagSet.add(newClusterTag);
                    String updateTags = Joiner.on((String)",").join((Iterable)tagSet);
                    entity.setClusterTags(updateTags);
                    entity.setModifier(operator);
                    if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(entity)) {
                        LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
                        throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
                    }
                });
            }
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)exist, (boolean)true);
        request.setExtParams(exist.getExtParams());
        String extParams = InlongClusterTagExtParam.packExtParams((ClusterTagRequest)request);
        exist.setExtParams(extParams);
        exist.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterTagMapper.updateByIdSelective(exist)) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getTenantList())) {
            HashSet updatedTenants = new HashSet(request.getTenantList());
            List tenantList = this.tenantClusterTagMapper.selectByTag(oldClusterTag);
            tenantList.stream().filter(entity -> !updatedTenants.contains(entity.getTenant())).forEach(entity -> {
                try {
                    this.deleteTenantTag(entity.getId(), operator);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            });
            Set currentTenants = tenantList.stream().map(TenantClusterTagEntity::getTenant).collect(Collectors.toSet());
            updatedTenants.stream().filter(tenant -> !currentTenants.contains(tenant)).forEach(tenant -> {
                try {
                    TenantClusterTagRequest tagRequest = new TenantClusterTagRequest();
                    tagRequest.setTenant(tenant);
                    tagRequest.setClusterTag(oldClusterTag);
                    this.saveTenantTag(tagRequest, operator);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            });
        }
        LOGGER.info("success to update cluster tag={}", (Object)request);
        return true;
    }

    @Override
    public Boolean deleteTag(Integer id, String operator) {
        Preconditions.expectNotNull((Object)id, (String)"cluster tag id cannot be empty");
        InlongClusterTagEntity exist = this.clusterTagMapper.selectById(id);
        if (exist == null || exist.getIsDeleted() > InlongConstants.UN_DELETED) {
            LOGGER.error("inlong cluster tag not found by id={}", (Object)id);
            return false;
        }
        String clusterTag = exist.getClusterTag();
        this.assertNoInlongGroupExists(clusterTag);
        List clusterEntities = this.clusterMapper.selectByKey(clusterTag, null, null);
        if (CollectionUtils.isNotEmpty((Collection)clusterEntities)) {
            clusterEntities.forEach(entity -> this.removeClusterTag((InlongClusterEntity)entity, clusterTag, operator));
        }
        exist.setIsDeleted(exist.getId());
        exist.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterTagMapper.updateByIdSelective(exist)) {
            LOGGER.error("cluster tag has already updated with name={}, curVersion={}", (Object)exist.getClusterTag(), (Object)exist.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        List tenantList = this.tenantClusterTagMapper.selectByTag(clusterTag);
        tenantList.forEach(entity -> {
            try {
                this.deleteTenantTag(entity.getId(), operator);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        });
        LOGGER.info("success to delete cluster tag by id={}", (Object)id);
        return true;
    }

    @Override
    public Integer save(ClusterRequest request, String operator) {
        String type;
        List exist;
        LOGGER.debug("begin to save inlong cluster={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster request cannot be empty");
        String clusterTag = request.getClusterTags();
        String name = request.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = UUID.randomUUID().toString();
            request.setName(name);
        }
        if (CollectionUtils.isNotEmpty((Collection)(exist = this.clusterMapper.selectByKey(clusterTag, name, type = request.getType())))) {
            String errMsg = String.format("inlong cluster already exist for cluster tag=%s name=%s type=%s", clusterTag, name, type);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(request.getType());
        Integer id = instance.saveOpt(request, operator);
        LOGGER.info("success to save inlong cluster={} by user={}", (Object)request, (Object)operator);
        return id;
    }

    @Override
    public ClusterInfo get(Integer id, String currentUser) {
        Preconditions.expectNotNull((Object)id, (String)"inlong cluster id cannot be empty");
        InlongClusterEntity entity = this.clusterMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong cluster not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(entity.getType());
        ClusterInfo clusterInfo = instance.getFromEntity(entity);
        LOGGER.debug("success to get inlong cluster info by id={}", (Object)id);
        return clusterInfo;
    }

    @Override
    public PageResult<ClusterInfo> list(ClusterPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.clusterMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(entity.getType());
            return instance.getFromEntity((InlongClusterEntity)entity);
        });
        LOGGER.debug("success to list inlong cluster by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<ClusterInfo> list(ClusterPageRequest request, UserInfo opInfo) {
        List clusterEntities = this.clusterMapper.selectByCondition(request);
        ArrayList<InlongClusterEntity> filterResult = new ArrayList<InlongClusterEntity>();
        for (InlongClusterEntity entity2 : clusterEntities) {
            List<String> inCharges;
            if (!opInfo.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()) && !(inCharges = Arrays.asList(entity2.getInCharges().split(","))).contains(opInfo.getName())) continue;
            filterResult.add(entity2);
        }
        return filterResult.stream().map(entity -> {
            InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(entity.getType());
            return instance.getFromEntity((InlongClusterEntity)entity);
        }).collect(Collectors.toList());
    }

    @Override
    public List<ClusterInfo> listByTagAndType(String clusterTag, String clusterType) {
        List clusterEntities = this.clusterMapper.selectByKey(clusterTag, null, clusterType);
        if (CollectionUtils.isEmpty((Collection)clusterEntities)) {
            throw new BusinessException(String.format("cannot find any cluster by tag %s and type %s", clusterTag, clusterType));
        }
        List<ClusterInfo> clusterInfos = clusterEntities.stream().map(entity -> {
            InlongClusterOperator operator = this.clusterOperatorFactory.getInstance(entity.getType());
            return operator.getFromEntity((InlongClusterEntity)entity);
        }).collect(Collectors.toList());
        LOGGER.debug("success to list inlong cluster by tag={}", (Object)clusterTag);
        return clusterInfos;
    }

    @Override
    public ClusterInfo getOne(String clusterTag, String name, String type) {
        List entityList = this.clusterMapper.selectByKey(clusterTag, name, type);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            throw new BusinessException(String.format("cluster not found by tag=%s, name=%s, type=%s", clusterTag, name, type));
        }
        InlongClusterEntity entity = (InlongClusterEntity)entityList.get(0);
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(entity.getType());
        ClusterInfo result = instance.getFromEntity(entity);
        LOGGER.debug("success to get inlong cluster by tag={}, name={}, type={}", new Object[]{clusterTag, name, type});
        return result;
    }

    @Override
    public Boolean update(ClusterRequest request, String operator) {
        LOGGER.debug("begin to update inlong cluster: {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster info cannot be empty");
        Integer id = request.getId();
        InlongClusterEntity entity = this.clusterMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong cluster not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        this.chkUnmodifiableParams(entity, request);
        String clusterTag = request.getClusterTags();
        List exist = this.clusterMapper.selectByKey(clusterTag, request.getName(), request.getType());
        if (CollectionUtils.isNotEmpty((Collection)exist) && !Objects.equals(id, ((InlongClusterEntity)exist.get(0)).getId())) {
            String errMsg = String.format("inlong cluster already exist for cluster tag=%s name=%s type=%s", clusterTag, request.getName(), request.getType());
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(request.getType());
        instance.updateOpt(request, operator);
        LOGGER.info("success to update inlong cluster: {} by {}", (Object)request, (Object)operator);
        return true;
    }

    @Override
    public UpdateResult updateByKey(ClusterRequest request, String operator) {
        LOGGER.debug("begin to update inlong cluster: {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster info cannot be null");
        String name = request.getName();
        String type = request.getType();
        InlongClusterEntity entity = this.clusterMapper.selectByNameAndType(name, type);
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND, String.format("inlong cluster not found by name=%s, type=%s", name, type));
        }
        request.setId(entity.getId());
        this.chkUnmodifiableParams(entity, request);
        InlongClusterOperator instance = this.clusterOperatorFactory.getInstance(request.getType());
        instance.updateOpt(request, operator);
        LOGGER.info("success to update inlong cluster: {} by {}", (Object)request, (Object)operator);
        return new UpdateResult(entity.getId(), Boolean.valueOf(true), Integer.valueOf(request.getVersion() + 1));
    }

    @Override
    public Boolean bindTag(BindTagRequest request, String operator) {
        LOGGER.info("begin to bind or unbind cluster tag: {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster info cannot be empty");
        String clusterTag = request.getClusterTag();
        Preconditions.expectNotBlank((String)clusterTag, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tag cannot be empty");
        InlongClusterTagEntity exist = this.clusterTagMapper.selectByTag(clusterTag);
        if (CollectionUtils.isNotEmpty((Collection)request.getBindClusters())) {
            request.getBindClusters().forEach(id -> {
                InlongClusterEntity entity = this.clusterMapper.selectById(id);
                HashSet tagSet = Sets.newHashSet((Object[])entity.getClusterTags().split(","));
                tagSet.add(clusterTag);
                String updateTags = Joiner.on((String)",").join((Iterable)tagSet);
                InlongClusterEntity updateEntity = this.clusterMapper.selectById(id);
                updateEntity.setClusterTags(updateTags);
                updateEntity.setModifier(operator);
                if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(updateEntity)) {
                    LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{updateEntity.getName(), updateEntity.getType(), updateEntity.getVersion()});
                    throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getUnbindClusters())) {
            request.getUnbindClusters().forEach(id -> {
                InlongClusterEntity entity = this.clusterMapper.selectById(id);
                this.removeClusterTag(entity, clusterTag, operator);
            });
        }
        LOGGER.info("success to bind or unbind cluster tag {} by {}", (Object)request, (Object)operator);
        return true;
    }

    @Override
    public Boolean deleteByKey(String name, String type, String operator) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster name should not be empty or null");
        Preconditions.expectNotBlank((String)type, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster type should not be empty or null");
        InlongClusterEntity entity = this.clusterMapper.selectByNameAndType(name, type);
        if (entity == null || entity.getIsDeleted() > InlongConstants.UN_DELETED) {
            LOGGER.error("inlong cluster not found by clusterName={}, type={} or was already deleted", (Object)name, (Object)type);
            return false;
        }
        List nodeEntities = this.clusterNodeMapper.selectByParentId(entity.getId(), null);
        if (CollectionUtils.isNotEmpty((Collection)nodeEntities)) {
            String errMsg = String.format("there are undeleted nodes under the cluster [%s], please delete the node first", entity.getName());
            throw new BusinessException(errMsg);
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(entity)) {
            LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete inlong cluster for clusterName={}, type={} by user={}", new Object[]{name, type, operator});
        return true;
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        Preconditions.expectNotNull((Object)id, (String)"cluster id cannot be empty");
        InlongClusterEntity entity = this.clusterMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.CLUSTER_NOT_FOUND, (String)ErrorCodeEnum.CLUSTER_NOT_FOUND.getMessage());
        List nodeEntities = this.clusterNodeMapper.selectByParentId(id, null);
        if (CollectionUtils.isNotEmpty((Collection)nodeEntities)) {
            String errMsg = String.format("there are undeleted nodes under the cluster [%s], please delete the node first", entity.getName());
            throw new BusinessException(errMsg);
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(entity)) {
            LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete inlong cluster for id={} by user={}", (Object)id, (Object)operator);
        return true;
    }

    @Override
    public Boolean delete(Integer id, UserInfo opInfo) {
        InlongClusterEntity entity = this.clusterMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.CLUSTER_NOT_FOUND, (String)ErrorCodeEnum.CONSUME_NOT_FOUND.getMessage());
        List nodeEntities = this.clusterNodeMapper.selectByParentId(id, null);
        if (CollectionUtils.isNotEmpty((Collection)nodeEntities)) {
            throw new BusinessException(ErrorCodeEnum.RECORD_IN_USED, String.format("there are undeleted nodes under the cluster [%s], please delete the node first", entity.getName()));
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(opInfo.getName());
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(entity)) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, String.format("cluster has already updated with name=%s, type=%s, curVersion=%s", entity.getName(), entity.getType(), entity.getVersion()));
        }
        return true;
    }

    @Override
    public Integer saveNode(ClusterNodeRequest request, String operator) {
        LOGGER.debug("begin to insert inlong cluster node={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"cluster node info cannot be empty");
        InlongClusterNodeEntity exist = this.clusterNodeMapper.selectByUniqueKey(request);
        if (exist != null) {
            String errMsg = String.format("inlong cluster node already exist for type=%s ip=%s port=%s", request.getType(), request.getIp(), request.getPort());
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        List existList = this.clusterNodeMapper.selectByIpAndType(request.getIp(), request.getType());
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            InlongClusterEntity currentCluster = this.clusterMapper.selectById(((InlongClusterNodeEntity)existList.get(0)).getParentId());
            InlongClusterEntity targetCluster = this.clusterMapper.selectById(request.getParentId());
            if (!Objects.equals(currentCluster.getId(), targetCluster.getId())) {
                throw new BusinessException(String.format("current ip can not belong to cluster %s and %s at the same time", currentCluster.getName(), targetCluster.getName()));
            }
        }
        InlongClusterNodeOperator instance = this.clusterNodeOperatorFactory.getInstance(request.getType());
        Integer id = instance.saveOpt(request, operator);
        if (request.getIsInstall().booleanValue()) {
            request.setId(id);
            this.clusterNodeMapper.updateOperateLogById(id, Integer.valueOf(NodeStatus.INSTALLING.getStatus()), "begin to install");
            this.pendingInstallRequests.add(request);
        }
        return id;
    }

    @Override
    public ClusterNodeResponse getNode(Integer id, String currentUser) {
        Preconditions.expectNotNull((Object)id, (String)"cluster node id cannot be empty");
        InlongClusterNodeEntity entity = this.clusterNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong cluster node not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        InlongClusterNodeOperator instance = this.clusterNodeOperatorFactory.getInstance(entity.getType());
        return instance.getFromEntity(entity);
    }

    @Override
    public PageResult<ClusterNodeResponse> listNode(ClusterPageRequest request, String currentUser) {
        if (StringUtils.isNotBlank((CharSequence)request.getClusterTag())) {
            List<ClusterNodeResponse> nodeList = this.listNodeByClusterTag(request);
            return new PageResult(nodeList, Long.valueOf(nodeList.size()));
        }
        Integer parentId = request.getParentId();
        Preconditions.expectNotNull((Object)parentId, (String)"Cluster id cannot be empty");
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.clusterNodeMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            InlongClusterNodeOperator instance = this.clusterNodeOperatorFactory.getInstance(entity.getType());
            return instance.getFromEntity((InlongClusterNodeEntity)entity);
        });
        LOGGER.debug("success to list inlong cluster node by {}", (Object)request);
        return pageResult;
    }

    @Override
    public List<ClusterNodeResponse> listNode(ClusterPageRequest request, UserInfo opInfo) {
        if (StringUtils.isBlank((CharSequence)request.getClusterTag())) {
            if (request.getParentId() == null) {
                throw new BusinessException(ErrorCodeEnum.ID_IS_EMPTY, "Cluster id cannot be empty");
            }
            return CommonBeanUtils.copyListProperties((List)this.clusterNodeMapper.selectByCondition(request), ClusterNodeResponse::new);
        }
        ArrayList allNodeList = new ArrayList();
        List clusterList = this.clusterMapper.selectByKey(request.getClusterTag(), request.getName(), request.getType());
        for (InlongClusterEntity cluster : clusterList) {
            List<String> inCharges;
            if (!opInfo.getAccountType().equals(TenantUserTypeEnum.TENANT_ADMIN.getCode()) && !(inCharges = Arrays.asList(cluster.getInCharges().split(","))).contains(opInfo.getName())) continue;
            allNodeList.addAll(this.clusterNodeMapper.selectByParentId(cluster.getId(), null));
        }
        return CommonBeanUtils.copyListProperties(allNodeList, ClusterNodeResponse::new);
    }

    @Override
    public List<ClusterNodeResponse> listNodeByGroupId(String groupId, String clusterType, String protocolType) {
        LOGGER.debug("begin to get cluster nodes for groupId={}, clusterType={}, protocol={}", new Object[]{groupId, clusterType, protocolType});
        List<InlongClusterNodeEntity> nodeEntities = this.getClusterNodes(groupId, clusterType, protocolType);
        if (CollectionUtils.isEmpty(nodeEntities)) {
            LOGGER.debug("not any cluster node for groupId={}, clusterType={}, protocol={}", new Object[]{groupId, clusterType, protocolType});
            return Collections.emptyList();
        }
        List result = CommonBeanUtils.copyListProperties(nodeEntities, ClusterNodeResponse::new);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("success to get nodes for groupId={}, clusterType={}, protocol={}, result size={}", new Object[]{groupId, clusterType, protocolType, result});
        }
        return result;
    }

    public List<ClusterNodeResponse> listNodeByClusterTag(ClusterPageRequest request) {
        List clusterList = this.clusterMapper.selectByKey(request.getClusterTag(), request.getName(), request.getType());
        ArrayList allNodeList = new ArrayList();
        for (InlongClusterEntity cluster : clusterList) {
            List nodeList = this.clusterNodeMapper.selectByParentId(cluster.getId(), null);
            allNodeList.addAll(nodeList);
        }
        return CommonBeanUtils.copyListProperties(allNodeList, ClusterNodeResponse::new);
    }

    @Override
    public List<String> listNodeIpByType(String type) {
        Preconditions.expectNotBlank((String)type, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster type cannot be empty");
        ClusterPageRequest request = new ClusterPageRequest();
        request.setType(type);
        List nodeList = this.clusterNodeMapper.selectByCondition(request);
        if (CollectionUtils.isEmpty((Collection)nodeList)) {
            LOGGER.debug("not found any node for type={}", (Object)type);
            return Collections.emptyList();
        }
        List<String> ipList = nodeList.stream().map(node -> String.format("%s:%d", node.getIp(), node.getPort())).collect(Collectors.toList());
        LOGGER.debug("success to list node by type={}, result={}", (Object)type, ipList);
        return ipList;
    }

    @Override
    public Boolean updateNode(ClusterNodeRequest request, String operator) {
        InlongClusterNodeEntity exist;
        LOGGER.debug("begin to update inlong cluster node={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong cluster node cannot be empty");
        Integer id = request.getId();
        InlongClusterNodeEntity entity = this.clusterNodeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("cluster node not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        Preconditions.expectEquals((Object)entity.getType(), (Object)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"type not allowed modify");
        Preconditions.expectEquals((Object)entity.getVersion(), (Object)request.getVersion(), (ErrorCodeEnum)ErrorCodeEnum.CONFIG_EXPIRED, (String)String.format("record has expired with record version=%d, request version=%d", entity.getVersion(), request.getVersion()));
        if (StringUtils.isBlank((CharSequence)request.getProtocolType())) {
            request.setProtocolType(entity.getProtocolType());
        }
        if ((exist = this.clusterNodeMapper.selectByUniqueKey(request)) != null && !Objects.equals(id, exist.getId())) {
            String errMsg = "inlong cluster node already exist for " + request;
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        InlongClusterNodeOperator instance = this.clusterNodeOperatorFactory.getInstance(request.getType());
        instance.updateOpt(request, operator);
        if (request.getIsInstall().booleanValue()) {
            request.setIsInstall(Boolean.valueOf(false));
            this.clusterNodeMapper.updateOperateLogById(request.getId(), Integer.valueOf(NodeStatus.INSTALLING.getStatus()), "begin to re install");
            this.pendingInstallRequests.add(request);
        }
        return true;
    }

    @Override
    public Boolean deleteNode(Integer id, String operator) {
        Preconditions.expectNotNull((Object)id, (String)"cluster node id cannot be empty");
        InlongClusterNodeEntity entity = this.clusterNodeMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (ErrorCodeEnum)ErrorCodeEnum.CLUSTER_NOT_FOUND);
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterNodeMapper.updateById(entity)) {
            LOGGER.error("cluster node has already updated with parentId={}, type={}, ip={}, port={}, protocolType={}", new Object[]{entity.getParentId(), entity.getType(), entity.getIp(), entity.getPort(), entity.getProtocolType()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete inlong cluster node by id={}", (Object)id);
        return true;
    }

    @Override
    public Boolean unloadNode(Integer id, String operator) {
        LOGGER.info("begin to unload inlong cluster node={}, operator={}", (Object)id, (Object)operator);
        InlongClusterNodeEntity clusterNodeEntity = this.clusterNodeMapper.selectById(id);
        InlongClusterNodeInstallOperator clusterNodeInstallOperator = this.clusterNodeInstallOperatorFactory.getInstance(clusterNodeEntity.getType());
        boolean isSuccess = clusterNodeInstallOperator.unload(clusterNodeEntity, operator);
        LOGGER.info("success to unload inlong cluster node={}, operator={}", (Object)id, (Object)operator);
        return isSuccess;
    }

    @Override
    public String getManagerSSHPublicKey() {
        String homeDirectory = System.getProperty("user.home");
        String publicKeyPath = homeDirectory + "/.ssh/inlong_rsa.pub";
        try {
            Path path = Paths.get(publicKeyPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                this.commandExecutor.execSSHKeyGeneration();
            }
            return StringUtils.strip((String)new String(Files.readAllBytes(path)), (String)"\n");
        }
        catch (Exception e) {
            LOGGER.error("get manager ssh public key error", (Throwable)e);
            throw new RuntimeException("get manager ssh public key error", e);
        }
    }

    @Override
    public Boolean testSSHConnection(ClusterNodeRequest request) {
        AgentClusterNodeRequest nodeRequest = (AgentClusterNodeRequest)request;
        try {
            CommandResult commandResult = this.commandExecutor.execRemote(nodeRequest, "ls");
            return commandResult.getCode() == 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataProxyNodeResponse getDataProxyNodes(String groupId, String protocolType) {
        LOGGER.debug("begin to get data proxy nodes for groupId={}, protocol={}", (Object)groupId, (Object)protocolType);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        if (groupEntity == null) {
            String errMsg = String.format("group not found by groupId=%s", groupId);
            LOGGER.error(errMsg);
            throw new BusinessException(errMsg);
        }
        GroupStatus groupStatus = GroupStatus.forCode((int)groupEntity.getStatus());
        if (!Objects.equals(groupStatus, GroupStatus.CONFIG_SUCCESSFUL)) {
            String errMsg = String.format("current group status=%s was not allowed to get data proxy nodes", groupStatus);
            LOGGER.warn(errMsg);
            throw new BusinessException(errMsg);
        }
        List<InlongClusterNodeEntity> nodeEntities = this.getClusterNodes(groupId, "DATAPROXY", protocolType);
        DataProxyNodeResponse response = new DataProxyNodeResponse();
        if (CollectionUtils.isEmpty(nodeEntities)) {
            LOGGER.debug("not any data proxy node for groupId={}, protocol={}", (Object)groupId, (Object)protocolType);
            return response;
        }
        Integer clusterId = nodeEntities.get(0).getParentId();
        Integer maxPacketLength = null;
        response.setClusterId(clusterId);
        InlongClusterEntity dataProxyCluster = this.clusterMapper.selectById(clusterId);
        if (dataProxyCluster != null && StringUtils.isNotBlank((CharSequence)dataProxyCluster.getExtParams())) {
            DataProxyClusterDTO dataProxyClusterDTO = DataProxyClusterDTO.getFromJson((String)dataProxyCluster.getExtParams());
            maxPacketLength = dataProxyClusterDTO.getMaxPacketLength();
            response.setMaxPacketLength(maxPacketLength);
        }
        ArrayList<DataProxyNodeInfo> nodeList = new ArrayList<DataProxyNodeInfo>();
        for (InlongClusterNodeEntity nodeEntity : nodeEntities) {
            DataProxyClusterNodeDTO dataProxyClusterNodeDTO;
            if (StringUtils.isNotBlank((CharSequence)nodeEntity.getExtParams()) && Objects.equals((dataProxyClusterNodeDTO = DataProxyClusterNodeDTO.getFromJson((String)nodeEntity.getExtParams())).getEnabledOnline(), false)) continue;
            DataProxyNodeInfo nodeInfo = new DataProxyNodeInfo();
            nodeInfo.setId(nodeEntity.getId());
            nodeInfo.setIp(nodeEntity.getIp());
            nodeInfo.setPort(nodeEntity.getPort());
            nodeInfo.setProtocolType(nodeEntity.getProtocolType());
            nodeInfo.setNodeLoad(nodeEntity.getNodeLoad());
            nodeList.add(nodeInfo);
        }
        response.setNodeList(nodeList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("success to get dp nodes for groupId={}, protocol={}, result={}", new Object[]{groupId, protocolType, response});
        }
        return response;
    }

    @Override
    public DataProxyNodeResponse getDataProxyNodesByCluster(String clusterName, String protocolType, String reportSourceType) {
        List nodeEntities;
        LOGGER.debug("begin to get data proxy nodes for clusterName={}, protocol={}", (Object)clusterName, (Object)protocolType);
        InlongClusterEntity clusterEntity = this.clusterMapper.selectByNameAndType(clusterName, "DATAPROXY");
        DataProxyNodeResponse response = new DataProxyNodeResponse();
        if (clusterEntity == null) {
            LOGGER.debug("not any dataproxy cluster for clusterName={}, protocol={}", (Object)clusterName, (Object)protocolType);
            return response;
        }
        Integer maxPacketLength = null;
        if (StringUtils.isNotBlank((CharSequence)clusterEntity.getExtParams())) {
            DataProxyClusterDTO dataProxyClusterDTO = DataProxyClusterDTO.getFromJson((String)clusterEntity.getExtParams());
            maxPacketLength = dataProxyClusterDTO.getMaxPacketLength();
            response.setMaxPacketLength(maxPacketLength);
        }
        if (CollectionUtils.isEmpty((Collection)(nodeEntities = this.clusterNodeMapper.selectByParentId(clusterEntity.getId(), protocolType)))) {
            LOGGER.debug("not any data proxy node for clusterName={}, protocol={}", (Object)clusterName, (Object)protocolType);
            return response;
        }
        response.setClusterId(clusterEntity.getId());
        ArrayList<DataProxyNodeInfo> nodeList = new ArrayList<DataProxyNodeInfo>();
        for (InlongClusterNodeEntity nodeEntity : nodeEntities) {
            if (Objects.equals(nodeEntity.getStatus(), NodeStatus.HEARTBEAT_TIMEOUT.getStatus())) {
                LOGGER.debug("dataproxy node was timeout, parentId={} ip={} port={}", new Object[]{nodeEntity.getParentId(), nodeEntity.getIp(), nodeEntity.getPort()});
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)nodeEntity.getExtParams())) {
                DataProxyClusterNodeDTO dataProxyClusterNodeDTO = DataProxyClusterNodeDTO.getFromJson((String)nodeEntity.getExtParams());
                if (StringUtils.isBlank((CharSequence)dataProxyClusterNodeDTO.getReportSourceType())) {
                    dataProxyClusterNodeDTO.setReportSourceType("INLONG");
                }
                if (StringUtils.isNotBlank((CharSequence)reportSourceType) && !Objects.equals(dataProxyClusterNodeDTO.getReportSourceType(), reportSourceType) || Objects.equals(dataProxyClusterNodeDTO.getEnabledOnline(), false)) continue;
            }
            DataProxyNodeInfo nodeInfo = new DataProxyNodeInfo();
            nodeInfo.setId(nodeEntity.getId());
            nodeInfo.setIp(nodeEntity.getIp());
            nodeInfo.setPort(nodeEntity.getPort());
            nodeInfo.setProtocolType(nodeEntity.getProtocolType());
            nodeInfo.setNodeLoad(nodeEntity.getNodeLoad());
            nodeList.add(nodeInfo);
        }
        response.setNodeList(nodeList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("success to get dp nodes for clusterName={}, protocol={}, result={}", new Object[]{clusterName, protocolType, response});
        }
        return response;
    }

    private List<InlongClusterNodeEntity> getClusterNodes(String groupId, String clusterType, String protocolType) {
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        if (groupEntity == null) {
            LOGGER.warn("inlong group not exists for groupId={}", (Object)groupId);
            return Lists.newArrayList();
        }
        String clusterTag = groupEntity.getInlongClusterTag();
        if (StringUtils.isBlank((CharSequence)clusterTag)) {
            String msg = "not found any cluster tag for groupId=" + groupId;
            LOGGER.debug(msg);
            throw new BusinessException(msg);
        }
        List clusterList = this.clusterMapper.selectByKey(clusterTag, null, clusterType);
        if (CollectionUtils.isEmpty((Collection)clusterList)) {
            String msg = "not found any data proxy cluster for groupId=" + groupId + " and clusterTag=" + clusterTag;
            LOGGER.debug(msg);
            throw new BusinessException(msg);
        }
        return this.clusterNodeMapper.selectByParentId(((InlongClusterEntity)clusterList.get(0)).getId(), protocolType);
    }

    @Override
    public DataProxyConfig getDataProxyConfig(String clusterTag, String clusterName) {
        LOGGER.debug("GetDPConfig: begin to get config by cluster tag={} name={}", (Object)clusterTag, (Object)clusterName);
        ClusterPageRequest request = ClusterPageRequest.builder().clusterTag(clusterTag).name(clusterName).type("DATAPROXY").build();
        List clusterEntityList = this.clusterMapper.selectByCondition(request);
        DataProxyConfig result = new DataProxyConfig();
        if (CollectionUtils.isEmpty((Collection)clusterEntityList)) {
            LOGGER.warn("GetDPConfig: not found data proxy cluster by tag={} name={}", (Object)clusterTag, (Object)clusterName);
            return result;
        }
        HashSet tagSet = new HashSet(16);
        clusterEntityList.forEach(e -> tagSet.addAll(Arrays.asList(e.getClusterTags().split(","))));
        ArrayList clusterTagList = new ArrayList(tagSet);
        InlongGroupPageRequest groupRequest = InlongGroupPageRequest.builder().statusList(Collections.singletonList(GroupStatus.CONFIG_SUCCESSFUL.getCode())).clusterTagList(clusterTagList).build();
        List groupList = this.groupMapper.selectBriefList(groupRequest);
        if (CollectionUtils.isEmpty((Collection)groupList)) {
            LOGGER.warn("GetDPConfig: not found inlong group with success status by cluster tags={}", clusterTagList);
            return result;
        }
        LOGGER.debug("GetDPConfig: begin to get config for cluster tags={}, associated InlongGroup num={}", clusterTagList, (Object)groupList.size());
        ArrayList<DataProxyTopicInfo> topicList = new ArrayList<DataProxyTopicInfo>();
        for (InlongGroupBriefInfo groupInfo : groupList) {
            String groupId = groupInfo.getInlongGroupId();
            String mqResource = groupInfo.getMqResource();
            String realClusterTag = groupInfo.getInlongClusterTag();
            String mqType = groupInfo.getMqType();
            if ("PULSAR".equals(mqType) || "TDMQ_PULSAR".equals(mqType)) {
                InlongPulsarDTO pulsarDTO = InlongPulsarDTO.getFromJson((String)groupInfo.getExtParams());
                Object tenant = pulsarDTO.getPulsarTenant();
                if (StringUtils.isBlank((CharSequence)tenant)) {
                    List pulsarClusters = this.clusterMapper.selectByKey(realClusterTag, null, "PULSAR");
                    if (CollectionUtils.isEmpty((Collection)pulsarClusters)) {
                        LOGGER.error("GetDPConfig: not found pulsar cluster by cluster tag={}", (Object)realClusterTag);
                        continue;
                    }
                    PulsarClusterDTO cluster = PulsarClusterDTO.getFromJson((String)((InlongClusterEntity)pulsarClusters.get(0)).getExtParams());
                    tenant = cluster.getPulsarTenant();
                }
                List streamList = this.streamMapper.selectBriefList(groupId);
                for (InlongStreamBriefInfo streamInfo : streamList) {
                    String streamId = streamInfo.getInlongStreamId();
                    String topic = String.format("persistent://%s/%s/%s", tenant, mqResource, streamInfo.getMqResource());
                    DataProxyTopicInfo topicConfig = new DataProxyTopicInfo();
                    topicConfig.setInlongGroupId(groupId + "/" + streamId);
                    topicConfig.setTopic(topic);
                    topicList.add(topicConfig);
                }
                continue;
            }
            if ("TUBEMQ".equals(mqType)) {
                DataProxyTopicInfo topicConfig = new DataProxyTopicInfo();
                topicConfig.setInlongGroupId(groupId);
                topicConfig.setTopic(mqResource);
                topicList.add(topicConfig);
                continue;
            }
            if (!"KAFKA".equals(mqType)) continue;
            List streamList = this.streamMapper.selectBriefList(groupId);
            for (InlongStreamBriefInfo streamInfo : streamList) {
                String streamId = streamInfo.getInlongStreamId();
                String topic = streamInfo.getMqResource();
                if (topic.equals(streamId)) {
                    topic = String.format("%s.%s", mqResource, streamInfo.getMqResource());
                }
                DataProxyTopicInfo topicConfig = new DataProxyTopicInfo();
                topicConfig.setInlongGroupId(groupId + "/" + streamId);
                topicConfig.setTopic(topic);
                topicList.add(topicConfig);
            }
        }
        LOGGER.debug("GetDPConfig: begin to get mq clusters by tags={}", clusterTagList);
        ArrayList<MQClusterInfo> mqSet = new ArrayList<MQClusterInfo>();
        List<String> typeList = Arrays.asList("TUBEMQ", "PULSAR", "KAFKA");
        ClusterPageRequest pageRequest = ClusterPageRequest.builder().typeList(typeList).clusterTagList(clusterTagList).build();
        List mqClusterList = this.clusterMapper.selectByCondition(pageRequest);
        for (InlongClusterEntity cluster : mqClusterList) {
            MQClusterInfo clusterInfo = new MQClusterInfo();
            clusterInfo.setUrl(cluster.getUrl());
            clusterInfo.setToken(cluster.getToken());
            clusterInfo.setMqType(cluster.getType());
            Map configParams = (Map)GSON.fromJson(cluster.getExtParams(), Map.class);
            clusterInfo.setParams(configParams);
            mqSet.add(clusterInfo);
        }
        result.setMqClusterList(mqSet);
        result.setTopicList(topicList);
        return result;
    }

    @Override
    @Deprecated
    public String getAllConfig(String clusterName, String md5) {
        DataProxyConfigResponse response = new DataProxyConfigResponse();
        String configMd5 = this.proxyRepository.getProxyMd5(clusterName);
        if (configMd5 == null) {
            response.setResult(Boolean.valueOf(false));
            response.setErrCode(Integer.valueOf(-101));
            return GSON.toJson((Object)response);
        }
        if (configMd5.equals(md5)) {
            response.setResult(Boolean.valueOf(true));
            response.setErrCode(Integer.valueOf(1));
            response.setMd5(configMd5);
            response.setData(new DataProxyCluster());
            return GSON.toJson((Object)response);
        }
        String configJson = this.proxyRepository.getProxyConfigJson(clusterName);
        if (configJson == null) {
            response.setResult(Boolean.valueOf(false));
            response.setErrCode(Integer.valueOf(-101));
            return GSON.toJson((Object)response);
        }
        return configJson;
    }

    @Override
    public AuditConfig getAuditConfig(String clusterTag) {
        AuditConfig auditConfig = new AuditConfig();
        ClusterPageRequest request = ClusterPageRequest.builder().clusterTag(clusterTag).typeList(Arrays.asList("TUBEMQ", "PULSAR", "KAFKA")).build();
        List clusterEntityList = this.clusterMapper.selectByCondition(request);
        ArrayList<MQInfo> mqInfoList = new ArrayList<MQInfo>();
        for (InlongClusterEntity entity : clusterEntityList) {
            MQInfo info = new MQInfo();
            info.setUrl(entity.getUrl());
            info.setMqType(entity.getType());
            info.setParams((Map)GSON.fromJson(entity.getExtParams(), Map.class));
            mqInfoList.add(info);
        }
        auditConfig.setMqInfoList(mqInfoList);
        return auditConfig;
    }

    @Override
    public Boolean testConnection(ClusterRequest request) {
        LOGGER.info("begin test connection for: {}", (Object)request);
        InlongClusterOperator clusterOperator = this.clusterOperatorFactory.getInstance(request.getType());
        Boolean result = clusterOperator.testConnection(request);
        LOGGER.info("connection [{}] for: {}", (Object)(result != false ? "success" : "failed"), (Object)request);
        return result;
    }

    @Override
    public Integer saveTenantTag(TenantClusterTagRequest request, String operator) {
        LOGGER.debug("begin to save tenant cluster tag {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"tenant cluster request cannot be empty");
        Preconditions.expectNotBlank((String)request.getClusterTag(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"cluster tag cannot be empty");
        Preconditions.expectNotBlank((String)request.getTenant(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"tenant cannot be empty");
        InlongTenantInfo tenantInfo = this.tenantService.getByName(request.getTenant());
        Preconditions.expectNotNull((Object)tenantInfo, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"target tenant cannot be found");
        TenantClusterTagEntity entity = (TenantClusterTagEntity)CommonBeanUtils.copyProperties((Object)request, TenantClusterTagEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.tenantClusterTagMapper.insert(entity);
        LOGGER.info("success to save tenant tag, tenant={}, tag={}", (Object)request.getTenant(), (Object)request.getClusterTag());
        return entity.getId();
    }

    @Override
    public PageResult<ClusterTagResponse> listTagByTenantRole(TenantClusterTagPageRequest request) {
        ClusterTagPageRequest tagRequest = (ClusterTagPageRequest)CommonBeanUtils.copyProperties((Object)request, ClusterTagPageRequest::new);
        String loginUser = LoginUserUtils.getLoginUser().getName();
        InlongRoleInfo roleInfo = this.inlongRoleService.getByUsername(loginUser);
        if (roleInfo == null || StringUtils.isNotBlank((CharSequence)request.getTenant())) {
            request.setPageNum(1);
            request.setPageSize(Integer.MAX_VALUE);
            List tags = this.listTenantTag(request).getList().stream().map(TenantClusterTagInfo::getClusterTag).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tags) && StringUtils.isNotBlank((CharSequence)request.getTenant())) {
                return new PageResult(new ArrayList(), Long.valueOf(0L), Integer.valueOf(request.getPageNum()), Integer.valueOf(request.getPageSize()));
            }
            tagRequest.setClusterTags(tags);
        }
        return this.listTag(tagRequest);
    }

    @Override
    public PageResult<ClusterInfo> listByTenantRole(ClusterPageRequest request) {
        String loginUser = LoginUserUtils.getLoginUser().getName();
        InlongRoleInfo roleInfo = this.inlongRoleService.getByUsername(loginUser);
        if (roleInfo == null) {
            TenantClusterTagPageRequest tagRequest = new TenantClusterTagPageRequest();
            tagRequest.setPageNum(1);
            tagRequest.setPageSize(Integer.MAX_VALUE);
            List tags = this.listTenantTag(tagRequest).getList().stream().map(TenantClusterTagInfo::getClusterTag).distinct().collect(Collectors.toList());
            request.setClusterTagList(tags);
        }
        return this.list(request);
    }

    @Override
    public PageResult<TenantClusterTagInfo> listTenantTag(TenantClusterTagPageRequest request) {
        LOGGER.debug("begin to list tag by tenant {}", (Object)request);
        String loginUser = LoginUserUtils.getLoginUser().getName();
        InlongRoleInfo roleInfo = this.inlongRoleService.getByUsername(loginUser);
        if (roleInfo == null) {
            List<String> tenants = this.tenantRoleService.listTenantByUsername(loginUser);
            request.setTenantList(tenants);
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.tenantClusterTagMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> (TenantClusterTagInfo)CommonBeanUtils.copyProperties((Object)entity, TenantClusterTagInfo::new));
        LOGGER.debug("success to list tenant tag with request={}", (Object)request);
        return pageResult;
    }

    @Override
    public Boolean deleteTenantTag(Integer id, String operator) {
        LOGGER.debug("start to delete tenant tag with id={}", (Object)id);
        TenantClusterTagEntity entity = this.tenantClusterTagMapper.selectByPrimaryKey(id);
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.RECORD_NOT_FOUND.getMessage());
        entity.setModifier(operator);
        entity.setIsDeleted(id);
        int rowCount = this.tenantClusterTagMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("tenant cluster tag has already updated for tenant={} tag={}", (Object)entity.getTenant(), (Object)entity.getClusterTag());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete tenant tag of tenant={} tag={}, user={}", new Object[]{entity.getTenant(), entity.getClusterTag(), operator});
        return true;
    }

    private void removeClusterTag(InlongClusterEntity entity, String clusterTag, String operator) {
        HashSet tagSet = Sets.newHashSet((Object[])entity.getClusterTags().split(","));
        tagSet.remove(clusterTag);
        String updateTags = Joiner.on((String)",").join((Iterable)tagSet);
        entity.setClusterTags(updateTags);
        entity.setModifier(operator);
        if (InlongConstants.AFFECTED_ONE_ROW.intValue() != this.clusterMapper.updateById(entity)) {
            LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{entity.getName(), entity.getType(), entity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }

    private void assertNoInlongGroupExists(String clusterTag) {
        List groupEntities = this.groupMapper.selectByClusterTag(clusterTag);
        if (CollectionUtils.isEmpty((Collection)groupEntities)) {
            return;
        }
        List groupIds = groupEntities.stream().map(InlongGroupEntity::getInlongGroupId).collect(Collectors.toList());
        String errMsg = String.format("inlong cluster tag [%s] was used by inlong group %s", clusterTag, groupIds);
        LOGGER.error(errMsg);
        throw new BusinessException(errMsg + ", please delete them first");
    }

    private void chkUnmodifiableParams(InlongClusterEntity entity, ClusterRequest request) {
        Preconditions.expectEquals((Object)entity.getType(), (Object)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"type not allowed modify");
        Preconditions.expectEquals((Object)entity.getVersion(), (Object)request.getVersion(), (ErrorCodeEnum)ErrorCodeEnum.CONFIG_EXPIRED, (String)String.format("record has expired with record version=%d, request version=%d", entity.getVersion(), request.getVersion()));
        if (StringUtils.isBlank((CharSequence)request.getName())) {
            request.setName(entity.getName());
        } else {
            Preconditions.expectEquals((Object)entity.getName(), (Object)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"name not allowed modify");
        }
        if (StringUtils.isBlank((CharSequence)request.getClusterTags())) {
            request.setClusterTags(entity.getClusterTags());
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public void processInstall() {
        LOGGER.info("begin to process install task");
        while (!this.pendingInstallRequests.isEmpty()) {
            ClusterNodeRequest request = this.pendingInstallRequests.poll();
            InstallTaskRunnable installTaskRunnable = new InstallTaskRunnable(request);
            this.executorService.execute(installTaskRunnable);
        }
        LOGGER.info("success to process install task");
    }

    private class InstallTaskRunnable
    implements Runnable {
        private ClusterNodeRequest request;

        public InstallTaskRunnable(ClusterNodeRequest request) {
            this.request = request;
        }

        @Override
        public void run() {
            if (this.request == null) {
                return;
            }
            InlongClusterNodeInstallOperator clusterNodeInstallOperator = InlongClusterServiceImpl.this.clusterNodeInstallOperatorFactory.getInstance(this.request.getType());
            if (this.request.getIsInstall().booleanValue()) {
                clusterNodeInstallOperator.install(this.request, this.request.getCurrentUser());
            } else {
                clusterNodeInstallOperator.reInstall(this.request, this.request.getCurrentUser());
            }
        }
    }
}

