/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.Set;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueHandler;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSinkContext;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueueClusterProducer
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueueClusterProducer.class);
    private final String workerName;
    private final CacheClusterConfig config;
    private final MessageQueueZoneSinkContext sinkContext;
    private final String cacheClusterName;
    private LifecycleState state;
    private MessageQueueHandler handler;

    public MessageQueueClusterProducer(String workerName, CacheClusterConfig config, MessageQueueZoneSinkContext context) {
        this.workerName = workerName;
        this.config = config;
        this.sinkContext = context;
        this.state = LifecycleState.IDLE;
        this.cacheClusterName = config.getClusterName();
        this.handler = this.sinkContext.createMessageQueueHandler(config);
        this.handler.init(config, context);
    }

    public void start() {
        this.state = LifecycleState.START;
        this.handler.start();
    }

    public void stop() {
        this.state = LifecycleState.STOP;
        this.handler.stop();
    }

    public LifecycleState getLifecycleState() {
        return this.state;
    }

    public boolean send(PackProfile profile) {
        return this.handler.send(profile);
    }

    public String getCacheClusterName() {
        return this.cacheClusterName;
    }

    public String getWorkerName() {
        return this.workerName;
    }

    public LifecycleState getState() {
        return this.state;
    }

    public CacheClusterConfig getConfig() {
        return this.config;
    }

    public void publishTopic(Set<String> topicNames) {
        this.handler.publishTopic(topicNames);
    }
}

