/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.ArrayList;
import java.util.List;
import org.apache.flume.Event;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfileCallback;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;

public class BatchPackProfile
extends PackProfile {
    private List<ProxyEvent> events = new ArrayList<ProxyEvent>();
    private BatchPackProfileCallback callback;

    public BatchPackProfile(String uid, String inlongGroupId, String inlongStreamId, long dispatchTime) {
        super(uid, inlongGroupId, inlongStreamId, dispatchTime);
    }

    @Override
    public boolean addEvent(Event event, long maxPackCount, long maxPackSize) {
        long eventLength = event.getBody().length;
        if (this.count >= maxPackCount || this.count > 0L && this.size + eventLength > maxPackSize) {
            return false;
        }
        this.events.add((ProxyEvent)event);
        ++this.count;
        this.size += eventLength;
        return true;
    }

    public List<ProxyEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ProxyEvent> events) {
        this.events = events;
    }

    @Override
    public void ack() {
        if (this.callback != null) {
            this.callback.ack(this.events.size());
        }
    }

    @Override
    public void fail(DataProxyErrCode errCode, String errMsg) {
        if (this.callback != null) {
            this.callback.fail();
        }
    }

    @Override
    public boolean isResend() {
        return this.callback == null && this.enableRetryAfterFailure && (this.maxRetries < 0 || ++this.retries <= this.maxRetries);
    }

    public BatchPackProfileCallback getCallback() {
        return this.callback;
    }

    public void setCallback(BatchPackProfileCallback callback) {
        this.callback = callback;
    }
}

