/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.sink.mq;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.event.SimpleEvent;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfile;
import org.apache.inlong.dataproxy.sink.mq.BatchPackProfileCallback;
import org.apache.inlong.dataproxy.sink.mq.MessageQueueZoneSink;
import org.apache.inlong.dataproxy.sink.mq.PackProfile;
import org.apache.inlong.dataproxy.sink.mq.SimplePackProfile;
import org.apache.inlong.sdk.commons.protocol.InlongId;
import org.apache.inlong.sdk.commons.protocol.ProxyEvent;
import org.apache.inlong.sdk.commons.protocol.ProxyPackEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPackManager {
    private static final Logger logger = LoggerFactory.getLogger(BatchPackManager.class);
    public static final String KEY_DISPATCH_TIMEOUT = "dispatchTimeout";
    public static final String KEY_DISPATCH_MAX_PACKCOUNT = "dispatchMaxPackCount";
    public static final String KEY_DISPATCH_MAX_PACKSIZE = "dispatchMaxPackSize";
    public static final long DEFAULT_DISPATCH_TIMEOUT = 2000L;
    public static final long DEFAULT_DISPATCH_MAX_PACKCOUNT = 256L;
    public static final long DEFAULT_DISPATCH_MAX_PACKSIZE = 327680L;
    public static final long MINUTE_MS = 60000L;
    private final long dispatchTimeout;
    private final long maxPackCount;
    private final long maxPackSize;
    private final MessageQueueZoneSink mqZoneSink;
    private final ConcurrentHashMap<String, PackProfile> profileCache = new ConcurrentHashMap();
    private final AtomicBoolean needOutputOvertimeData = new AtomicBoolean(false);
    private final AtomicLong inCounter = new AtomicLong(0L);
    private final AtomicLong outCounter = new AtomicLong(0L);

    public BatchPackManager(MessageQueueZoneSink mqZoneSink, Context context) {
        this.mqZoneSink = mqZoneSink;
        this.dispatchTimeout = context.getLong(KEY_DISPATCH_TIMEOUT, Long.valueOf(2000L));
        this.maxPackCount = context.getLong(KEY_DISPATCH_MAX_PACKCOUNT, Long.valueOf(256L));
        this.maxPackSize = context.getLong(KEY_DISPATCH_MAX_PACKSIZE, Long.valueOf(327680L));
    }

    public void addEvent(ProxyEvent event) {
        String eventUid = event.getUid();
        long dispatchTime = event.getMsgTime() - event.getMsgTime() % 60000L;
        String dispatchKey = eventUid + "." + dispatchTime;
        PackProfile dispatchProfile = this.profileCache.get(dispatchKey);
        if (dispatchProfile == null) {
            dispatchProfile = new BatchPackProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
            this.profileCache.put(dispatchKey, dispatchProfile);
        }
        if (!dispatchProfile.addEvent((Event)event, this.maxPackCount, this.maxPackSize)) {
            BatchPackProfile newDispatchProfile = new BatchPackProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
            PackProfile oldDispatchProfile = this.profileCache.put(dispatchKey, newDispatchProfile);
            if (oldDispatchProfile != null) {
                this.mqZoneSink.acquireAndOfferDispatchedRecord(oldDispatchProfile);
            }
            this.outCounter.addAndGet(dispatchProfile.getCount());
            newDispatchProfile.addEvent((Event)event, this.maxPackCount, this.maxPackSize);
        }
        this.inCounter.incrementAndGet();
    }

    public void addPackEvent(ProxyPackEvent packEvent) {
        String eventUid = packEvent.getUid();
        long dispatchTime = packEvent.getMsgTime() - packEvent.getMsgTime() % 60000L;
        BatchPackProfile dispatchProfile = new BatchPackProfile(eventUid, packEvent.getInlongGroupId(), packEvent.getInlongStreamId(), dispatchTime);
        BatchPackProfileCallback callback = new BatchPackProfileCallback(packEvent.getEvents().size(), packEvent.getCallback());
        dispatchProfile.setCallback(callback);
        for (ProxyEvent event : packEvent.getEvents()) {
            if (!dispatchProfile.addEvent((Event)event, this.maxPackCount, this.maxPackSize)) {
                this.outCounter.addAndGet(dispatchProfile.getCount());
                this.mqZoneSink.acquireAndOfferDispatchedRecord(dispatchProfile);
                dispatchProfile = new BatchPackProfile(eventUid, event.getInlongGroupId(), event.getInlongStreamId(), dispatchTime);
                dispatchProfile.setCallback(callback);
                dispatchProfile.addEvent((Event)event, this.maxPackCount, this.maxPackSize);
            }
            this.inCounter.incrementAndGet();
        }
        if (dispatchProfile.getEvents().size() > 0) {
            this.outCounter.addAndGet(dispatchProfile.getCount());
            this.mqZoneSink.acquireAndOfferDispatchedRecord(dispatchProfile);
        }
    }

    public void addSimpleEvent(SimpleEvent event) {
        Map headers = event.getHeaders();
        String inlongGroupId = (String)headers.get("groupId");
        String inlongStreamId = (String)headers.get("streamId");
        String uid = InlongId.generateUid((String)inlongGroupId, (String)inlongStreamId);
        long msgTime = NumberUtils.toLong((String)((String)headers.get("dt")), (long)System.currentTimeMillis());
        long dispatchTime = msgTime - msgTime % 60000L;
        SimplePackProfile profile = new SimplePackProfile(uid, inlongGroupId, inlongStreamId, dispatchTime);
        profile.addEvent((Event)event, this.maxPackCount, this.maxPackSize);
        this.mqZoneSink.acquireAndOfferDispatchedRecord(profile);
        this.outCounter.addAndGet(profile.getCount());
        this.inCounter.incrementAndGet();
    }

    public void outputOvertimeData() {
        if (!this.needOutputOvertimeData.getAndSet(false)) {
            return;
        }
        int profileSize = this.profileCache.size();
        int dispatchSize = this.mqZoneSink.getDispatchQueueSize();
        long currentTime = System.currentTimeMillis();
        long createThreshold = currentTime - this.dispatchTimeout;
        ArrayList<String> removeKeys = new ArrayList<String>();
        long eventCount = 0L;
        for (Map.Entry<String, PackProfile> entry : this.profileCache.entrySet()) {
            PackProfile dispatchProfile = entry.getValue();
            eventCount += dispatchProfile.getCount();
            if (!dispatchProfile.isTimeout(createThreshold)) continue;
            removeKeys.add(entry.getKey());
        }
        removeKeys.forEach(key -> {
            PackProfile dispatchProfile = this.profileCache.remove(key);
            if (dispatchProfile != null) {
                this.mqZoneSink.acquireAndOfferDispatchedRecord(dispatchProfile);
                this.outCounter.addAndGet(dispatchProfile.getCount());
            }
        });
        long hisInCnt = this.inCounter.getAndSet(0L);
        long hisOutCnt = this.outCounter.getAndSet(0L);
        if (!removeKeys.isEmpty()) {
            logger.info("{} output overtime data, profileCacheSize: before={}, after={}, dispatchQueueSize: before={}, after={}, eventCount: {}, inCounter: {}, outCounter: {}", new Object[]{this.mqZoneSink.getName(), profileSize, this.profileCache.size(), dispatchSize, this.mqZoneSink.getDispatchQueueSize(), eventCount, hisInCnt, hisOutCnt});
        }
    }

    public long getDispatchTimeout() {
        return this.dispatchTimeout;
    }

    public long getMaxPackCount() {
        return this.maxPackCount;
    }

    public long getMaxPackSize() {
        return this.maxPackSize;
    }

    public void setNeedOutputOvertimeData() {
        this.needOutputOvertimeData.getAndSet(true);
    }
}

