/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Hasher;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.TxEngine;

public class HTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Bind.MapWithModificationListener<K, V> {
    protected static final int BUCKET_OVERFLOW = 4;
    protected static final int DIV8 = 3;
    protected static final int MOD8 = 7;
    protected final boolean hasValues;
    protected final int hashSalt;
    protected final Atomic.Long counter;
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Hasher<K> hasher;
    protected final Engine engine;
    protected final boolean expireFlag;
    protected final long expireTimeStart;
    protected final long expire;
    protected final boolean expireAccessFlag;
    protected final long expireAccess;
    protected final long expireMaxSize;
    protected final boolean expireMaxSizeFlag;
    protected final long[] expireHeads;
    protected final long[] expireTails;
    protected final Fun.Function1<V, K> valueCreator;
    protected final Serializer<LinkedNode<K, V>> LN_SERIALIZER = new Serializer<LinkedNode<K, V>>(){

        @Override
        public void serialize(DataOutput out, LinkedNode<K, V> value) throws IOException {
            DataOutput2.packLong(out, value.next);
            if (HTreeMap.this.expireFlag) {
                DataOutput2.packLong(out, value.expireLinkNodeRecid);
            }
            HTreeMap.this.keySerializer.serialize(out, value.key);
            if (HTreeMap.this.hasValues) {
                HTreeMap.this.valueSerializer.serialize(out, value.value);
            }
        }

        @Override
        public LinkedNode<K, V> deserialize(DataInput in, int available) throws IOException {
            assert (available != 0);
            return new LinkedNode(DataInput2.unpackLong(in), HTreeMap.this.expireFlag ? DataInput2.unpackLong(in) : 0L, HTreeMap.this.keySerializer.deserialize(in, -1), HTreeMap.this.hasValues ? HTreeMap.this.valueSerializer.deserialize(in, -1) : BTreeMap.EMPTY);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    protected static final Serializer<long[][]> DIR_SERIALIZER = new Serializer<long[][]>(){

        @Override
        public void serialize(DataOutput out, long[][] value) throws IOException {
            int i;
            assert (value.length == 16);
            int nulls = 0;
            block0: for (i = 0; i < 16; ++i) {
                if (value[i] == null) continue;
                for (long l : value[i]) {
                    if (l == 0L) continue;
                    nulls |= 1 << i;
                    continue block0;
                }
            }
            out.writeShort(nulls);
            for (i = 0; i < 16; ++i) {
                if (value[i] == null) continue;
                assert (value[i].length == 8);
                for (long l : value[i]) {
                    DataOutput2.packLong(out, l);
                }
            }
        }

        @Override
        public long[][] deserialize(DataInput in, int available) throws IOException {
            long[][] ret = new long[16][];
            int nulls = in.readUnsignedShort();
            for (int i = 0; i < 16; ++i) {
                if ((nulls & 1) != 0) {
                    long[] subarray = new long[8];
                    for (int j = 0; j < 8; ++j) {
                        subarray[j] = DataInput2.unpackLong(in);
                    }
                    ret[i] = subarray;
                }
                nulls >>>= 1;
            }
            return ret;
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    };
    protected final long[] segmentRecids;
    protected final ReentrantReadWriteLock[] segmentLocks = new ReentrantReadWriteLock[16];
    private final Set<K> _keySet;
    private final Collection<V> _values;
    private Set<Map.Entry<K, V>> _entrySet;
    protected final Object modListenersLock;
    protected Bind.MapListener<K, V>[] modListeners;

    public HTreeMap(Engine engine, long counterRecid, int hashSalt, long[] segmentRecids, Serializer<K> keySerializer, Serializer<V> valueSerializer, long expireTimeStart, long expire, long expireAccess, long expireMaxSize, long[] expireHeads, long[] expireTails, Fun.Function1<V, K> valueCreator, Hasher hasher) {
        for (int i = 0; i < 16; ++i) {
            this.segmentLocks[i] = new ReentrantReadWriteLock(false);
        }
        this._keySet = new KeySet();
        this._values = new AbstractCollection<V>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return HTreeMap.this.containsValue(o);
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }
        };
        this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return HTreeMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return HTreeMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object val = HTreeMap.this.get(e.getKey());
                    return val != null && val.equals(e.getValue());
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                Object key = kvEntry.getKey();
                Object value = kvEntry.getValue();
                if (key == null || value == null) {
                    throw new NullPointerException();
                }
                HTreeMap.this.put(key, value);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    Object key = e.getKey();
                    if (key == null) {
                        return false;
                    }
                    return HTreeMap.this.remove(key, e.getValue());
                }
                return false;
            }

            @Override
            public void clear() {
                HTreeMap.this.clear();
            }
        };
        this.modListenersLock = new Object();
        this.modListeners = new Bind.MapListener[0];
        if (counterRecid < 0L) {
            throw new IllegalArgumentException();
        }
        if (engine == null) {
            throw new NullPointerException();
        }
        if (segmentRecids == null) {
            throw new NullPointerException();
        }
        if (keySerializer == null) {
            throw new NullPointerException();
        }
        SerializerBase.assertSerializable(keySerializer);
        boolean bl = this.hasValues = valueSerializer != null;
        if (this.hasValues) {
            SerializerBase.assertSerializable(valueSerializer);
        }
        if (segmentRecids.length != 16) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.hashSalt = hashSalt;
        this.segmentRecids = Arrays.copyOf(segmentRecids, 16);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        Hasher hasher2 = this.hasher = hasher != null ? hasher : Hasher.BASIC;
        if (expire == 0L && expireAccess != 0L) {
            expire = expireAccess;
        }
        if (expireMaxSize != 0L && counterRecid == 0L) {
            throw new IllegalArgumentException("expireMaxSize must have counter enabled");
        }
        this.expireFlag = expire != 0L || expireAccess != 0L || expireMaxSize != 0L;
        this.expire = expire;
        this.expireTimeStart = expireTimeStart;
        this.expireAccessFlag = expireAccess != 0L || expireMaxSize != 0L;
        this.expireAccess = expireAccess;
        this.expireHeads = expireHeads == null ? null : Arrays.copyOf(expireHeads, 16);
        this.expireTails = expireTails == null ? null : Arrays.copyOf(expireTails, 16);
        this.expireMaxSizeFlag = expireMaxSize != 0L;
        this.expireMaxSize = expireMaxSize;
        this.valueCreator = valueCreator;
        if (counterRecid != 0L) {
            this.counter = new Atomic.Long(engine, counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
        if (this.expireFlag) {
            Thread t = new Thread((Runnable)new ExpireRunnable(this), "HTreeMap expirator");
            t.setDaemon(true);
            t.start();
        }
    }

    protected static long[] preallocateSegments(Engine engine) {
        long[] ret = new long[16];
        for (int i = 0; i < 16; ++i) {
            ret[i] = engine.put(new long[16][], DIR_SERIALIZER);
        }
        return ret;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getPeek(o) != null;
    }

    @Override
    public int size() {
        long size = this.sizeLong();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong() {
        if (this.counter != null) {
            return this.counter.get();
        }
        long counter = 0L;
        for (int i = 0; i < 16; ++i) {
            try {
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                counter += this.recursiveDirCount(dirRecid);
                continue;
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
        }
        return counter;
    }

    private long recursiveDirCount(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        long counter = 0L;
        for (long[] subdir : dir) {
            if (subdir == null) continue;
            for (long recid : subdir) {
                if (recid == 0L) continue;
                if ((recid & 1L) == 0L) {
                    counter += this.recursiveDirCount(recid >>>= 1);
                    continue;
                }
                recid >>>= 1;
                while (recid != 0L) {
                    LinkedNode<K, V> n = this.engine.get(recid, this.LN_SERIALIZER);
                    if (n != null) {
                        ++counter;
                        recid = n.next;
                        continue;
                    }
                    recid = 0L;
                }
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        for (int i = 0; i < 16; ++i) {
            try {
                long[][] dir;
                this.segmentLocks[i].readLock().lock();
                long dirRecid = this.segmentRecids[i];
                for (long[] d : dir = this.engine.get(dirRecid, DIR_SERIALIZER)) {
                    if (d == null) continue;
                    boolean bl = false;
                    return bl;
                }
                continue;
            }
            finally {
                this.segmentLocks[i].readLock().unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object o) {
        LinkedNode<K, V> ln;
        if (o == null) {
            return null;
        }
        int h = this.hash(o);
        int segment = h >>> 28;
        Lock lock = this.expireAccessFlag ? this.segmentLocks[segment].writeLock() : this.segmentLocks[segment].readLock();
        lock.lock();
        try {
            ln = this.getInner(o, h, segment);
            if (ln == null) {
                V v = null;
                return v;
            }
            if (this.expireAccessFlag) {
                this.expireLinkBump(segment, ln.expireLinkNodeRecid, true);
            }
        }
        finally {
            lock.unlock();
        }
        if (this.valueCreator == null || ln.value != null) {
            return ln.value;
        }
        V value = this.valueCreator.run(o);
        V prevVal = this.putIfAbsent(o, value);
        if (prevVal != null) {
            return prevVal;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getPeek(Object key) {
        if (key == null) {
            return null;
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        ReentrantReadWriteLock.ReadLock lock = this.segmentLocks[segment].readLock();
        lock.lock();
        try {
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln == null) {
                V v = null;
                return v;
            }
            Object v = ln.value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    protected LinkedNode<K, V> getInner(Object o, int h, int segment) {
        long recid = this.segmentRecids[segment];
        for (int level = 3; level >= 0; --level) {
            long[][] dir = this.engine.get(recid, DIR_SERIALIZER);
            if (dir == null) {
                return null;
            }
            int slot = h >>> level * 7 & 0x7F;
            assert (slot < 128);
            if (dir[slot >>> 3] == null) {
                return null;
            }
            recid = dir[slot >>> 3][slot & 7];
            if (recid == 0L) {
                return null;
            }
            if ((recid & 1L) != 0L) {
                recid >>>= 1;
                while (true) {
                    LinkedNode<K, V> ln;
                    if ((ln = this.engine.get(recid, this.LN_SERIALIZER)) == null) {
                        return null;
                    }
                    if (this.hasher.equals(ln.key, o)) {
                        assert (this.hash(ln.key) == h);
                        return ln;
                    }
                    if (ln.next == 0L) {
                        return null;
                    }
                    recid = ln.next;
                }
            }
            recid >>>= 1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        this.segmentLocks[segment].writeLock().lock();
        try {
            V v = this.putInner(key, value, h, segment);
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    private V putInner(K key, V value, int h, int segment) {
        long recid;
        int counter;
        int slot;
        Object dir;
        int level;
        long dirRecid;
        block12: {
            dirRecid = this.segmentRecids[segment];
            level = 3;
            while (true) {
                dir = this.engine.get(dirRecid, DIR_SERIALIZER);
                slot = h >>> 7 * level & 0x7F;
                assert (slot <= 127);
                if (dir == null) {
                    dir = new long[16][];
                }
                if (dir[slot >>> 3] == null) {
                    dir = (long[][])Arrays.copyOf(dir, 16);
                    dir[slot >>> 3] = new long[8];
                }
                counter = 0;
                recid = dir[slot >>> 3][slot & 7];
                if (recid == 0L) break block12;
                if ((recid & 1L) != 0L) break;
                dirRecid = recid >>> 1;
                --level;
            }
            LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
            while (ln != null) {
                if (this.hasher.equals(ln.key, key)) {
                    Object oldVal = ln.value;
                    ln = new LinkedNode(ln.next, ln.expireLinkNodeRecid, ln.key, value);
                    this.engine.update(recid, ln, this.LN_SERIALIZER);
                    if (this.expireFlag) {
                        this.expireLinkBump(segment, ln.expireLinkNodeRecid, false);
                    }
                    this.notify(key, oldVal, value);
                    return oldVal;
                }
                recid = ln.next;
                ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
                ++counter;
            }
        }
        if (counter >= 4 && level >= 1) {
            long[][] nextDir = new long[16][];
            long expireNodeRecid = this.expireFlag ? this.engine.preallocate() : 0L;
            LinkedNode<K, V> node = new LinkedNode<K, V>(0L, expireNodeRecid, key, value);
            long newRecid = this.engine.put(node, this.LN_SERIALIZER);
            int pos = h >>> 7 * (level - 1) & 0x7F;
            nextDir[pos >>> 3] = new long[8];
            nextDir[pos >>> 3][pos & 7] = newRecid << 1 | 1L;
            if (this.expireFlag) {
                this.expireLinkAdd(segment, expireNodeRecid, newRecid, h);
            }
            long nodeRecid = dir[slot >>> 3][slot & 7] >>> 1;
            while (nodeRecid != 0L) {
                LinkedNode<K, V> n = this.engine.get(nodeRecid, this.LN_SERIALIZER);
                long nextRecid = n.next;
                pos = this.hash(n.key) >>> 7 * (level - 1) & 0x7F;
                if (nextDir[pos >>> 3] == null) {
                    nextDir[pos >>> 3] = new long[8];
                }
                n = new LinkedNode(nextDir[pos >>> 3][pos & 7] >>> 1, n.expireLinkNodeRecid, n.key, n.value);
                nextDir[pos >>> 3][pos & 7] = nodeRecid << 1 | 1L;
                this.engine.update(nodeRecid, n, this.LN_SERIALIZER);
                nodeRecid = nextRecid;
            }
            long nextDirRecid = this.engine.put(nextDir, DIR_SERIALIZER);
            int parentPos = h >>> 7 * level & 0x7F;
            dir = (long[][])Arrays.copyOf(dir, 16);
            dir[parentPos >>> 3] = Arrays.copyOf(dir[parentPos >>> 3], 8);
            dir[parentPos >>> 3][parentPos & 7] = nextDirRecid << 1 | 0L;
            this.engine.update(dirRecid, dir, DIR_SERIALIZER);
            this.notify(key, null, value);
            return null;
        }
        recid = dir[slot >>> 3][slot & 7] >>> 1;
        long expireNodeRecid = this.expireFlag ? this.engine.put(ExpireLinkNode.EMPTY, ExpireLinkNode.SERIALIZER) : 0L;
        long newRecid = this.engine.put(new LinkedNode<K, V>(recid, expireNodeRecid, key, value), this.LN_SERIALIZER);
        dir = (long[][])Arrays.copyOf(dir, 16);
        dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
        dir[slot >>> 3][slot & 7] = newRecid << 1 | 1L;
        this.engine.update(dirRecid, dir, DIR_SERIALIZER);
        if (this.expireFlag) {
            this.expireLinkAdd(segment, expireNodeRecid, newRecid, h);
        }
        this.notify(key, null, value);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        int h = this.hash(key);
        int segment = h >>> 28;
        this.segmentLocks[segment].writeLock().lock();
        try {
            V v = this.removeInternal(key, segment, h, true);
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    protected V removeInternal(Object key, int segment, int h, boolean removeExpire) {
        block13: {
            long recid;
            int slot;
            Object dir;
            long[] dirRecids = new long[4];
            int level = 3;
            dirRecids[level] = this.segmentRecids[segment];
            assert (segment == h >>> 28);
            while (true) {
                dir = this.engine.get(dirRecids[level], DIR_SERIALIZER);
                slot = h >>> 7 * level & 0x7F;
                assert (slot <= 127);
                if (dir == null) {
                    dir = new long[16][];
                }
                if (dir[slot >>> 3] == null) {
                    dir = (long[][])Arrays.copyOf(dir, 16);
                    dir[slot >>> 3] = new long[8];
                }
                if ((recid = dir[slot >>> 3][slot & 7]) == 0L) break block13;
                if ((recid & 1L) != 0L) break;
                dirRecids[--level] = recid >>> 1;
            }
            LinkedNode<K, V> ln = this.engine.get(recid >>>= 1, this.LN_SERIALIZER);
            LinkedNode<K, V> prevLn = null;
            long prevRecid = 0L;
            while (ln != null) {
                if (this.hasher.equals(ln.key, key)) {
                    if (prevLn == null) {
                        if (ln.next == 0L) {
                            this.recursiveDirDelete(h, level, dirRecids, (long[][])dir, slot);
                        } else {
                            dir = (long[][])Arrays.copyOf(dir, 16);
                            dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
                            dir[slot >>> 3][slot & 7] = ln.next << 1 | 1L;
                            this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
                        }
                    } else {
                        prevLn = new LinkedNode(ln.next, prevLn.expireLinkNodeRecid, prevLn.key, prevLn.value);
                        this.engine.update(prevRecid, prevLn, this.LN_SERIALIZER);
                    }
                    assert (this.hash(ln.key) == h);
                    this.engine.delete(recid, this.LN_SERIALIZER);
                    if (removeExpire && this.expireFlag) {
                        this.expireLinkRemove(segment, ln.expireLinkNodeRecid);
                    }
                    this.notify(key, ln.value, null);
                    return ln.value;
                }
                prevRecid = recid;
                prevLn = ln;
                recid = ln.next;
                ln = recid == 0L ? null : this.engine.get(recid, this.LN_SERIALIZER);
            }
            return null;
        }
        return null;
    }

    private void recursiveDirDelete(int h, int level, long[] dirRecids, long[][] dir, int slot) {
        dir = (long[][])Arrays.copyOf(dir, 16);
        dir[slot >>> 3] = Arrays.copyOf(dir[slot >>> 3], 8);
        dir[slot >>> 3][slot & 7] = 0L;
        boolean allZero = true;
        for (long l : dir[slot >>> 3]) {
            if (l == 0L) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            dir[slot >>> 3] = null;
        }
        allZero = true;
        for (long[] l : dir) {
            if (l == null) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            if (level == 3) {
                this.engine.update(dirRecids[level], new long[16][], DIR_SERIALIZER);
            } else {
                this.engine.delete(dirRecids[level], DIR_SERIALIZER);
                long[][] lArray = this.engine.get(dirRecids[level + 1], DIR_SERIALIZER);
                int parentPos = h >>> 7 * (level + 1) & 0x7F;
                this.recursiveDirDelete(h, level + 1, dirRecids, lArray, parentPos);
            }
        } else {
            this.engine.update(dirRecids[level], dir, DIR_SERIALIZER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int i = 0; i < 16; ++i) {
            try {
                this.segmentLocks[i].writeLock().lock();
                long dirRecid = this.segmentRecids[i];
                this.recursiveDirClear(dirRecid);
                this.engine.update(dirRecid, new long[16][], DIR_SERIALIZER);
                if (!this.expireFlag) continue;
                while (this.expireLinkRemoveLast(i) != null) {
                }
                continue;
            }
            finally {
                this.segmentLocks[i].writeLock().unlock();
            }
        }
    }

    private void recursiveDirClear(long dirRecid) {
        long[][] dir = this.engine.get(dirRecid, DIR_SERIALIZER);
        if (dir == null) {
            return;
        }
        for (long[] subdir : dir) {
            if (subdir == null) continue;
            for (long recid : subdir) {
                if (recid == 0L) continue;
                if ((recid & 1L) == 0L) {
                    this.recursiveDirClear(recid >>>= 1);
                    this.engine.delete(recid, DIR_SERIALIZER);
                    continue;
                }
                recid >>>= 1;
                while (recid != 0L) {
                    LinkedNode<K, V> n = this.engine.get(recid, this.LN_SERIALIZER);
                    this.engine.delete(recid, this.LN_SERIALIZER);
                    this.notify(n.key, n.value, null);
                    recid = n.next;
                }
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this._keySet;
    }

    @Override
    public Collection<V> values() {
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    protected int hash(Object key) {
        int h = this.hasher.hashCode(key) ^ this.hashSalt;
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln == null) {
                V v = this.put(key, value);
                return v;
            }
            Object v = ln.value;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> otherVal = this.getInner(key, h, segment);
            if (otherVal != null && otherVal.value.equals(value)) {
                this.removeInternal(key, segment, h, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            LinkedNode<K, V> ln = this.getInner(key, h, segment);
            if (ln != null && ln.value.equals(oldValue)) {
                this.putInner(key, newValue, h, segment);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        int h = this.hash(key);
        int segment = h >>> 28;
        try {
            this.segmentLocks[segment].writeLock().lock();
            if (this.getInner(key, h, segment) != null) {
                V v = this.putInner(key, value, h, segment);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.segmentLocks[segment].writeLock().unlock();
        }
    }

    protected void expireLinkAdd(int segment, long expireNodeRecid, long keyRecid, int hash) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        assert (expireNodeRecid > 0L);
        assert (keyRecid > 0L);
        long time = this.expire == 0L ? 0L : this.expire + System.currentTimeMillis() - this.expireTimeStart;
        long head = this.engine.get(this.expireHeads[segment], Serializer.LONG);
        if (head == 0L) {
            ExpireLinkNode n = new ExpireLinkNode(0L, 0L, keyRecid, time, hash);
            this.engine.update(expireNodeRecid, n, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], expireNodeRecid, Serializer.LONG);
            this.engine.update(this.expireTails[segment], expireNodeRecid, Serializer.LONG);
        } else {
            ExpireLinkNode n = new ExpireLinkNode(head, 0L, keyRecid, time, hash);
            this.engine.update(expireNodeRecid, n, ExpireLinkNode.SERIALIZER);
            ExpireLinkNode oldHead = this.engine.get(head, ExpireLinkNode.SERIALIZER);
            oldHead = oldHead.copyNext(expireNodeRecid);
            this.engine.update(head, oldHead, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], expireNodeRecid, Serializer.LONG);
        }
    }

    protected void expireLinkBump(int segment, long nodeRecid, boolean access) {
        long newTime;
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        ExpireLinkNode n = this.engine.get(nodeRecid, ExpireLinkNode.SERIALIZER);
        long l = access ? (this.expireAccess == 0L ? 0L : this.expireAccess + System.currentTimeMillis() - this.expireTimeStart) : (newTime = this.expire == 0L ? 0L : this.expire + System.currentTimeMillis() - this.expireTimeStart);
        if (n.next == 0L) {
            n = n.copyTime(newTime);
            this.engine.update(nodeRecid, n, ExpireLinkNode.SERIALIZER);
        } else {
            if (n.prev != 0L) {
                ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
                prev = prev.copyNext(n.next);
                this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
            } else {
                this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
            }
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(n.prev);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            long oldHeadRecid = this.engine.get(this.expireHeads[segment], Serializer.LONG);
            ExpireLinkNode oldHead = this.engine.get(oldHeadRecid, ExpireLinkNode.SERIALIZER);
            oldHead = oldHead.copyNext(nodeRecid);
            this.engine.update(oldHeadRecid, oldHead, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], nodeRecid, Serializer.LONG);
            n = new ExpireLinkNode(oldHeadRecid, 0L, n.keyRecid, newTime, n.hash);
            this.engine.update(nodeRecid, n, ExpireLinkNode.SERIALIZER);
        }
    }

    protected ExpireLinkNode expireLinkRemoveLast(int segment) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        long tail = this.engine.get(this.expireTails[segment], Serializer.LONG);
        if (tail == 0L) {
            return null;
        }
        ExpireLinkNode n = this.engine.get(tail, ExpireLinkNode.SERIALIZER);
        if (n.next == 0L) {
            this.engine.update(this.expireHeads[segment], 0L, Serializer.LONG);
            this.engine.update(this.expireTails[segment], 0L, Serializer.LONG);
        } else {
            this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(0L);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
        }
        this.engine.delete(tail, ExpireLinkNode.SERIALIZER);
        return n;
    }

    protected ExpireLinkNode expireLinkRemove(int segment, long nodeRecid) {
        assert (this.segmentLocks[segment].writeLock().isHeldByCurrentThread());
        ExpireLinkNode n = this.engine.get(nodeRecid, ExpireLinkNode.SERIALIZER);
        this.engine.delete(nodeRecid, ExpireLinkNode.SERIALIZER);
        if (n.next == 0L && n.prev == 0L) {
            this.engine.update(this.expireHeads[segment], 0L, Serializer.LONG);
            this.engine.update(this.expireTails[segment], 0L, Serializer.LONG);
        } else if (n.next == 0L) {
            ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
            prev = prev.copyNext(0L);
            this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireHeads[segment], n.prev, Serializer.LONG);
        } else if (n.prev == 0L) {
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(0L);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            this.engine.update(this.expireTails[segment], n.next, Serializer.LONG);
        } else {
            ExpireLinkNode next = this.engine.get(n.next, ExpireLinkNode.SERIALIZER);
            next = next.copyPrev(n.prev);
            this.engine.update(n.next, next, ExpireLinkNode.SERIALIZER);
            ExpireLinkNode prev = this.engine.get(n.prev, ExpireLinkNode.SERIALIZER);
            prev = prev.copyNext(n.next);
            this.engine.update(n.prev, prev, ExpireLinkNode.SERIALIZER);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxExpireTime() {
        if (!this.expireFlag) {
            return 0L;
        }
        long ret = 0L;
        for (int segment = 0; segment < 16; ++segment) {
            this.segmentLocks[segment].readLock().lock();
            try {
                ExpireLinkNode ln;
                long head = this.engine.get(this.expireHeads[segment], Serializer.LONG);
                if (head == 0L || (ln = this.engine.get(head, ExpireLinkNode.SERIALIZER)) == null || ln.time == 0L) continue;
                ret = Math.max(ret, ln.time + this.expireTimeStart);
                continue;
            }
            finally {
                this.segmentLocks[segment].readLock().unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinExpireTime() {
        if (!this.expireFlag) {
            return 0L;
        }
        long ret = Long.MAX_VALUE;
        for (int segment = 0; segment < 16; ++segment) {
            this.segmentLocks[segment].readLock().lock();
            try {
                ExpireLinkNode ln;
                long tail = this.engine.get(this.expireTails[segment], Serializer.LONG);
                if (tail == 0L || (ln = this.engine.get(tail, ExpireLinkNode.SERIALIZER)) == null || ln.time == 0L) continue;
                ret = Math.min(ret, ln.time + this.expireTimeStart);
                continue;
            }
            finally {
                this.segmentLocks[segment].readLock().unlock();
            }
        }
        if (ret == Long.MAX_VALUE) {
            ret = 0L;
        }
        return ret;
    }

    protected void expirePurge() {
        long size;
        if (!this.expireFlag) {
            return;
        }
        long removePerSegment = 0L;
        if (this.expireMaxSizeFlag && (size = this.counter.get()) > this.expireMaxSize) {
            removePerSegment = 1L + (size - this.expireMaxSize) / 16L;
        }
        for (int seg = 0; seg < 16; ++seg) {
            this.exirePurgeSegment(seg, removePerSegment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exirePurgeSegment(int seg, long removePerSegment) {
        this.segmentLocks[seg].writeLock().lock();
        try {
            long recid = this.engine.get(this.expireTails[seg], Serializer.LONG);
            long counter = 0L;
            ExpireLinkNode last = null;
            ExpireLinkNode n = null;
            while (recid != 0L) {
                boolean remove;
                n = this.engine.get(recid, ExpireLinkNode.SERIALIZER);
                assert (n != ExpireLinkNode.EMPTY);
                assert (n.hash >>> 28 == seg);
                boolean bl = remove = ++counter < removePerSegment || (this.expire != 0L || this.expireAccess != 0L) && n.time + this.expireTimeStart < System.currentTimeMillis();
                if (!remove) break;
                this.engine.delete(recid, ExpireLinkNode.SERIALIZER);
                LinkedNode<K, V> ln = this.engine.get(n.keyRecid, this.LN_SERIALIZER);
                this.removeInternal(ln.key, seg, n.hash, false);
                last = n;
                recid = n.next;
            }
            if (last == null) {
                return;
            }
            if (recid == 0L) {
                this.engine.update(this.expireTails[seg], 0L, Serializer.LONG);
                this.engine.update(this.expireHeads[seg], 0L, Serializer.LONG);
            } else {
                this.engine.update(this.expireTails[seg], recid, Serializer.LONG);
                n = this.engine.get(recid, ExpireLinkNode.SERIALIZER);
                n = n.copyPrev(0L);
                this.engine.update(recid, n, ExpireLinkNode.SERIALIZER);
            }
        }
        finally {
            this.segmentLocks[seg].writeLock().unlock();
        }
    }

    protected void expireCheckSegment(int segment) {
        long current = this.engine.get(this.expireTails[segment], Serializer.LONG);
        if (current == 0L) {
            if (this.engine.get(this.expireHeads[segment], Serializer.LONG) != 0L) {
                throw new AssertionError((Object)"head not 0");
            }
            return;
        }
        long prev = 0L;
        while (current != 0L) {
            ExpireLinkNode curr = this.engine.get(current, ExpireLinkNode.SERIALIZER);
            assert (curr.prev == prev) : "wrong prev " + curr.prev + " - " + prev;
            prev = current;
            current = curr.next;
        }
        if (this.engine.get(this.expireHeads[segment], Serializer.LONG) != prev) {
            throw new AssertionError((Object)"wrong head");
        }
    }

    public Map<K, V> snapshot() {
        Engine snapshot = TxEngine.createSnapshotFor(this.engine);
        return new HTreeMap<K, V>(snapshot, this.counter == null ? 0L : this.counter.recid, this.hashSalt, this.segmentRecids, this.keySerializer, this.valueSerializer, 0L, 0L, 0L, 0L, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modListeners.length; ++i) {
                if (this.modListeners[i] != listener) continue;
                this.modListeners[i] = null;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        assert (this.segmentLocks[this.hash(key) >>> 28].isWriteLockedByCurrentThread());
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    public void close() {
        this.engine.close();
    }

    protected static class ExpireRunnable
    implements Runnable {
        final WeakReference<HTreeMap> mapRef;

        public ExpireRunnable(HTreeMap map) {
            this.mapRef = new WeakReference<HTreeMap>(map);
        }

        @Override
        public void run() {
            HTreeMap map;
            while ((map = (HTreeMap)this.mapRef.get()) != null && !map.engine.isClosed()) {
                try {
                    map.expirePurge();
                    if (map.expireMaxSizeFlag && (long)map.size() >= map.expireMaxSize) continue;
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            return;
        }
    }

    protected static final class ExpireLinkNode {
        public static ExpireLinkNode EMPTY = new ExpireLinkNode(0L, 0L, 0L, 0L, 0);
        public static final Serializer<ExpireLinkNode> SERIALIZER = new Serializer<ExpireLinkNode>(){

            @Override
            public void serialize(DataOutput out, ExpireLinkNode value) throws IOException {
                if (value == EMPTY) {
                    return;
                }
                DataOutput2.packLong(out, value.prev);
                DataOutput2.packLong(out, value.next);
                DataOutput2.packLong(out, value.keyRecid);
                DataOutput2.packLong(out, value.time);
                out.writeInt(value.hash);
            }

            @Override
            public ExpireLinkNode deserialize(DataInput in, int available) throws IOException {
                if (available == 0) {
                    return EMPTY;
                }
                return new ExpireLinkNode(DataInput2.unpackLong(in), DataInput2.unpackLong(in), DataInput2.unpackLong(in), DataInput2.unpackLong(in), in.readInt());
            }

            @Override
            public int fixedSize() {
                return -1;
            }
        };
        public final long prev;
        public final long next;
        public final long keyRecid;
        public final long time;
        public final int hash;

        public ExpireLinkNode(long prev, long next, long keyRecid, long time, int hash) {
            this.prev = prev;
            this.next = next;
            this.keyRecid = keyRecid;
            this.time = time;
            this.hash = hash;
        }

        public ExpireLinkNode copyNext(long next2) {
            return new ExpireLinkNode(this.prev, next2, this.keyRecid, this.time, this.hash);
        }

        public ExpireLinkNode copyPrev(long prev2) {
            return new ExpireLinkNode(prev2, this.next, this.keyRecid, this.time, this.hash);
        }

        public ExpireLinkNode copyTime(long time2) {
            return new ExpireLinkNode(this.prev, this.next, this.keyRecid, time2, this.hash);
        }
    }

    class Entry2
    implements Map.Entry<K, V> {
        private final K key;

        Entry2(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return HTreeMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return HTreeMap.this.put(this.key, value);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && HTreeMap.this.hasher.equals(this.key, ((Map.Entry)o).getKey());
        }

        @Override
        public int hashCode() {
            Object value = HTreeMap.this.get(this.key);
            return (this.key == null ? 0 : HTreeMap.this.hasher.hashCode(this.key)) ^ (value == null ? 0 : value.hashCode());
        }
    }

    class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos].key;
            this.moveToNext();
            return new Entry2(key);
        }
    }

    class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object value = this.currentLinkedList[this.currentLinkedListPos].value;
            this.moveToNext();
            return value;
        }
    }

    class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            if (this.currentLinkedList == null) {
                throw new NoSuchElementException();
            }
            Object key = this.currentLinkedList[this.currentLinkedListPos].key;
            this.moveToNext();
            return key;
        }
    }

    abstract class HashIterator {
        protected LinkedNode[] currentLinkedList = this.findNextLinkedNode(0);
        protected int currentLinkedListPos = 0;
        private K lastReturnedKey = null;
        private int lastSegment = 0;

        HashIterator() {
        }

        public void remove() {
            Object keyToRemove = this.lastReturnedKey;
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.lastReturnedKey = null;
            HTreeMap.this.remove(keyToRemove);
        }

        public boolean hasNext() {
            return this.currentLinkedList != null && this.currentLinkedListPos < this.currentLinkedList.length;
        }

        protected void moveToNext() {
            this.lastReturnedKey = this.currentLinkedList[this.currentLinkedListPos].key;
            ++this.currentLinkedListPos;
            if (this.currentLinkedListPos == this.currentLinkedList.length) {
                int lastHash = HTreeMap.this.hash(this.lastReturnedKey);
                this.currentLinkedList = this.advance(lastHash);
                this.currentLinkedListPos = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LinkedNode[] advance(int lastHash) {
            int segment = lastHash >>> 28;
            try {
                HTreeMap.this.segmentLocks[segment].readLock().lock();
                long dirRecid = HTreeMap.this.segmentRecids[segment];
                int level = 3;
                while (true) {
                    int pos;
                    long[][] dir;
                    if ((dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER))[(pos = lastHash >>> 7 * level & 0x7F) >>> 3] == null || dir[pos >>> 3][pos & 7] == 0L || (dir[pos >>> 3][pos & 7] & 1L) == 1L) {
                        lastHash = level != 0 ? (lastHash >>> 7 * level) + 1 << 7 * level : ++lastHash;
                        if (lastHash == 0) {
                            LinkedNode[] linkedNodeArray = null;
                            return linkedNodeArray;
                        }
                        break;
                    }
                    dirRecid = dir[pos >>> 3][pos & 7] >>> 1;
                    --level;
                }
            }
            finally {
                HTreeMap.this.segmentLocks[segment].readLock().unlock();
            }
            return this.findNextLinkedNode(lastHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LinkedNode[] findNextLinkedNode(int hash) {
            for (int segment = Math.max(hash >>> 28, this.lastSegment); segment < 16; ++segment) {
                Lock lock = HTreeMap.this.expireAccessFlag ? HTreeMap.this.segmentLocks[segment].writeLock() : HTreeMap.this.segmentLocks[segment].readLock();
                lock.lock();
                try {
                    this.lastSegment = Math.max(segment, this.lastSegment);
                    long dirRecid = HTreeMap.this.segmentRecids[segment];
                    LinkedNode[] ret = this.findNextLinkedNodeRecur(dirRecid, hash, 3);
                    if (ret != null) {
                        for (LinkedNode ln : ret) {
                            assert (HTreeMap.this.hash(ln.key) >>> 28 == segment);
                        }
                    }
                    if (ret != null) {
                        if (HTreeMap.this.expireAccessFlag) {
                            for (LinkedNode ln : ret) {
                                HTreeMap.this.expireLinkBump(segment, ln.expireLinkNodeRecid, true);
                            }
                        }
                        LinkedNode[] linkedNodeArray = ret;
                        return linkedNodeArray;
                    }
                    hash = 0;
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            return null;
        }

        private LinkedNode[] findNextLinkedNodeRecur(long dirRecid, int newHash, int level) {
            long[][] dir = HTreeMap.this.engine.get(dirRecid, DIR_SERIALIZER);
            if (dir == null) {
                return null;
            }
            boolean first = true;
            for (int pos = newHash >>> level * 7 & 0x7F; pos < 128; ++pos) {
                long recid;
                if (dir[pos >>> 3] != null && (recid = dir[pos >>> 3][pos & 7]) != 0L) {
                    if ((recid & 1L) == 1L) {
                        recid >>= 1;
                        LinkedNode[] array = new LinkedNode[1];
                        int arrayPos = 0;
                        while (recid != 0L) {
                            LinkedNode ln = HTreeMap.this.engine.get(recid, HTreeMap.this.LN_SERIALIZER);
                            if (ln == null) {
                                recid = 0L;
                                continue;
                            }
                            if (arrayPos == array.length) {
                                array = Arrays.copyOf(array, array.length + 1);
                            }
                            array[arrayPos++] = ln;
                            recid = ln.next;
                        }
                        return array;
                    }
                    LinkedNode[] ret = this.findNextLinkedNodeRecur(recid >>= 1, first ? newHash : 0, level - 1);
                    if (ret != null) {
                        return ret;
                    }
                }
                first = false;
            }
            return null;
        }
    }

    protected class KeySet
    extends AbstractSet<K> {
        protected KeySet() {
        }

        @Override
        public int size() {
            return HTreeMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return HTreeMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return HTreeMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean add(K k) {
            if (HTreeMap.this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return HTreeMap.this.put(k, BTreeMap.EMPTY) == null;
        }

        @Override
        public boolean remove(Object o) {
            return HTreeMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            HTreeMap.this.clear();
        }

        public HTreeMap<K, V> parent() {
            return HTreeMap.this;
        }

        @Override
        public int hashCode() {
            int result = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                result += HTreeMap.this.hasher.hashCode(it.next());
            }
            return result;
        }
    }

    protected static final class LinkedNode<K, V> {
        public final long next;
        public final long expireLinkNodeRecid;
        public final K key;
        public final V value;

        public LinkedNode(long next, long expireLinkNodeRecid, K key, V value) {
            this.key = key;
            this.expireLinkNodeRecid = expireLinkNodeRecid;
            this.value = value;
            this.next = next;
        }
    }
}

