/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.LockSupport;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;
import org.mapdb.TxEngine;

public class BTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Bind.MapWithModificationListener<K, V> {
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    protected static final Object EMPTY = new Object();
    protected static final int B_TREE_NODE_LEAF_LR = 180;
    protected static final int B_TREE_NODE_LEAF_L = 181;
    protected static final int B_TREE_NODE_LEAF_R = 182;
    protected static final int B_TREE_NODE_LEAF_C = 183;
    protected static final int B_TREE_NODE_DIR_LR = 184;
    protected static final int B_TREE_NODE_DIR_L = 185;
    protected static final int B_TREE_NODE_DIR_R = 186;
    protected static final int B_TREE_NODE_DIR_C = 187;
    protected final long rootRecidRef;
    protected final BTreeKeySerializer keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final Comparator comparator;
    protected final LongConcurrentHashMap<Thread> nodeLocks = new LongConcurrentHashMap();
    protected final int maxNodeSize;
    protected final Engine engine;
    protected final boolean hasValues;
    protected final boolean valsOutsideNodes;
    protected final List<Long> leftEdges;
    private final KeySet keySet;
    private final EntrySet entrySet = new EntrySet(this);
    private final Values values = new Values(this);
    private final ConcurrentNavigableMap<K, V> descendingMap = new DescendingMap(this, null, true, null, false);
    protected final Atomic.Long counter;
    protected final int numberOfNodeMetas;
    protected final Serializer<BNode> nodeSerializer;
    protected final Object modListenersLock = new Object();
    protected Bind.MapListener<K, V>[] modListeners = new Bind.MapListener[0];

    protected static SortedMap<String, Object> preinitCatalog(DB db) {
        Long rootRef = db.getEngine().get(1L, Serializer.LONG);
        if (rootRef == null) {
            if (db.getEngine().isReadOnly()) {
                return Collections.unmodifiableSortedMap(new TreeMap());
            }
            NodeSerializer rootSerializer = new NodeSerializer(false, BTreeKeySerializer.STRING, db.getDefaultSerializer(), COMPARABLE_COMPARATOR, 0);
            LeafNode root = new LeafNode(new Object[]{null, null}, new Object[0], 0L);
            rootRef = db.getEngine().put(root, rootSerializer);
            db.getEngine().update(1L, rootRef, Serializer.LONG);
            db.getEngine().commit();
        }
        return new BTreeMap<String, Object>(db.engine, 1L, 32, false, 0L, BTreeKeySerializer.STRING, db.getDefaultSerializer(), COMPARABLE_COMPARATOR, 0);
    }

    public BTreeMap(Engine engine, long rootRecidRef, int maxNodeSize, boolean valsOutsideNodes, long counterRecid, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer, Comparator<K> comparator, int numberOfNodeMetas) {
        if (maxNodeSize % 2 != 0) {
            throw new IllegalArgumentException("maxNodeSize must be dividable by 2");
        }
        if (maxNodeSize < 6) {
            throw new IllegalArgumentException("maxNodeSize too low");
        }
        if (maxNodeSize > 126) {
            throw new IllegalArgumentException("maxNodeSize too high");
        }
        if (rootRecidRef <= 0L || counterRecid < 0L || numberOfNodeMetas < 0) {
            throw new IllegalArgumentException();
        }
        if (keySerializer == null) {
            throw new NullPointerException();
        }
        if (comparator == null) {
            throw new NullPointerException();
        }
        SerializerBase.assertSerializable(keySerializer);
        SerializerBase.assertSerializable(valueSerializer);
        SerializerBase.assertSerializable(comparator);
        this.rootRecidRef = rootRecidRef;
        this.hasValues = valueSerializer != null;
        this.valsOutsideNodes = valsOutsideNodes;
        this.engine = engine;
        this.maxNodeSize = maxNodeSize;
        this.comparator = comparator;
        this.numberOfNodeMetas = numberOfNodeMetas;
        Comparator<K> requiredComparator = keySerializer.getComparator();
        if (requiredComparator != null && !requiredComparator.equals(comparator)) {
            throw new IllegalArgumentException("KeySerializers requires its own comparator");
        }
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.nodeSerializer = new NodeSerializer(valsOutsideNodes, keySerializer, valueSerializer, comparator, numberOfNodeMetas);
        this.keySet = new KeySet(this, this.hasValues);
        if (counterRecid != 0L) {
            this.counter = new Atomic.Long(engine, counterRecid);
            Bind.size(this, this.counter);
        } else {
            this.counter = null;
        }
        ArrayList<Long> leftEdges2 = new ArrayList<Long>();
        long r = engine.get(rootRecidRef, Serializer.LONG);
        while (true) {
            BNode n = engine.get(r, this.nodeSerializer);
            leftEdges2.add(r);
            if (n.isLeaf()) break;
            r = n.child()[0];
        }
        Collections.reverse(leftEdges2);
        this.leftEdges = new CopyOnWriteArrayList<Long>(leftEdges2);
    }

    protected static long createRootRef(Engine engine, BTreeKeySerializer keySer, Serializer valueSer, Comparator comparator, int numberOfNodeMetas) {
        LeafNode emptyRoot = new LeafNode(new Object[]{null, null}, new Object[0], 0L);
        long rootRecidVal = engine.put(emptyRoot, new NodeSerializer(false, keySer, valueSer, comparator, numberOfNodeMetas));
        return engine.put(rootRecidVal, Serializer.LONG);
    }

    protected final int findChildren(Object key, Object[] keys) {
        int right;
        int left = 0;
        if (keys[0] == null) {
            ++left;
        }
        int n = right = keys[keys.length - 1] == null ? keys.length - 1 : keys.length;
        do {
            int middle;
            if (keys[middle = (left + right) / 2] == null) {
                return middle;
            }
            if (this.comparator.compare(keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        } while (left < right);
        return right;
    }

    @Override
    public V get(Object key) {
        long rootRecid;
        if (key == null) {
            throw new NullPointerException();
        }
        Object v = key;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int pos = this.findChildren(v, leaf.keys);
        while (pos == leaf.keys.length) {
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
            pos = this.findChildren(v, leaf.keys);
        }
        if (pos == leaf.keys.length - 1) {
            return null;
        }
        if (leaf.keys[pos] != null && 0 == this.comparator.compare(v, leaf.keys[pos])) {
            Object ret = leaf.vals[pos - 1];
            return this.valExpand(ret);
        }
        return null;
    }

    protected V valExpand(Object ret) {
        if (this.valsOutsideNodes && ret != null) {
            long recid = ((ValRef)ret).recid;
            ret = this.engine.get(recid, this.valueSerializer);
        }
        return (V)ret;
    }

    protected long nextDir(DirNode d, Object key) {
        int pos = this.findChildren(key, d.keys) - 1;
        if (pos < 0) {
            pos = 0;
        }
        return d.child[pos];
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, false);
    }

    protected V put2(K v, V value2, boolean putOnlyIfAbsent) {
        long rootRecid;
        if (v == null) {
            throw new IllegalArgumentException("null key");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("null value");
        }
        Object value = value2;
        if (this.valsOutsideNodes) {
            long recid = this.engine.put(value2, this.valueSerializer);
            value = new ValRef(recid);
        }
        int stackPos = -1;
        long[] stackVals = new long[4];
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            long t = current;
            current = this.nextDir((DirNode)A, v);
            assert (current > 0L) : A;
            if (current != A.child()[A.child().length - 1]) {
                if (stackVals.length == ++stackPos) {
                    stackVals = Arrays.copyOf(stackVals, stackVals.length * 2);
                }
                stackVals[stackPos] = t;
            }
            A = this.engine.get(current, this.nodeSerializer);
        }
        int level = 1;
        long p = 0L;
        try {
            long q;
            BNode B;
            block28: {
                while (true) {
                    BTreeMap.lock(this.nodeLocks, current);
                    boolean found = true;
                    A = this.engine.get(current, this.nodeSerializer);
                    int pos = this.findChildren(v, A.keys());
                    if (pos < A.keys().length - 1 && v != null && A.keys()[pos] != null && 0 == this.comparator.compare(v, A.keys()[pos])) {
                        Object oldVal = A.vals()[pos - 1];
                        if (putOnlyIfAbsent) {
                            BTreeMap.unlock(this.nodeLocks, current);
                            return this.valExpand(oldVal);
                        }
                        Object[] vals = Arrays.copyOf(A.vals(), A.vals().length);
                        vals[pos - 1] = value;
                        A = new LeafNode(Arrays.copyOf(A.keys(), A.keys().length), vals, ((LeafNode)A).next);
                        assert (this.nodeLocks.get(current) == Thread.currentThread());
                        this.engine.update(current, A, this.nodeSerializer);
                        V ret = this.valExpand(oldVal);
                        this.notify(v, ret, value2);
                        BTreeMap.unlock(this.nodeLocks, current);
                        return ret;
                    }
                    if (A.highKey() != null && this.comparator.compare(v, A.highKey()) > 0) {
                        long next;
                        BTreeMap.unlock(this.nodeLocks, current);
                        found = false;
                        int pos2 = this.findChildren(v, A.keys());
                        while (A != null && pos2 == A.keys().length && (next = A.next()) != 0L) {
                            current = next;
                            A = this.engine.get(current, this.nodeSerializer);
                            pos2 = this.findChildren(v, A.keys());
                        }
                    }
                    if (!found) continue;
                    if (A.keys().length - (A.isLeaf() ? 2 : 1) < this.maxNodeSize) {
                        pos = this.findChildren(v, A.keys());
                        Object[] keys = BTreeMap.arrayPut(A.keys(), pos, v);
                        if (A.isLeaf()) {
                            Object[] vals = BTreeMap.arrayPut(A.vals(), pos - 1, value);
                            LeafNode n = new LeafNode(keys, vals, ((LeafNode)A).next);
                            assert (this.nodeLocks.get(current) == Thread.currentThread());
                            this.engine.update(current, n, this.nodeSerializer);
                        } else {
                            assert (p != 0L);
                            long[] child = BTreeMap.arrayLongPut(A.child(), pos, p);
                            DirNode d = new DirNode(keys, child);
                            assert (this.nodeLocks.get(current) == Thread.currentThread());
                            this.engine.update(current, d, this.nodeSerializer);
                        }
                        this.notify(v, null, value2);
                        BTreeMap.unlock(this.nodeLocks, current);
                        return null;
                    }
                    pos = this.findChildren(v, A.keys());
                    Object[] keys = BTreeMap.arrayPut(A.keys(), pos, v);
                    Object[] vals = A.isLeaf() ? BTreeMap.arrayPut(A.vals(), pos - 1, value) : null;
                    long[] child = A.isLeaf() ? null : BTreeMap.arrayLongPut(A.child(), pos, p);
                    int splitPos = keys.length / 2;
                    if (A.isLeaf()) {
                        Object[] vals2 = Arrays.copyOfRange(vals, splitPos, vals.length);
                        B = new LeafNode(Arrays.copyOfRange(keys, splitPos, keys.length), vals2, ((LeafNode)A).next);
                    } else {
                        B = new DirNode(Arrays.copyOfRange(keys, splitPos, keys.length), Arrays.copyOfRange(child, splitPos, keys.length));
                    }
                    q = this.engine.put(B, this.nodeSerializer);
                    if (A.isLeaf()) {
                        Object[] keys2 = Arrays.copyOf(keys, splitPos + 2);
                        keys2[keys2.length - 1] = keys2[keys2.length - 2];
                        Object[] vals2 = Arrays.copyOf(vals, splitPos);
                        A = new LeafNode(keys2, vals2, q);
                    } else {
                        long[] child2 = Arrays.copyOf(child, splitPos + 1);
                        child2[splitPos] = q;
                        A = new DirNode(Arrays.copyOf(keys, splitPos + 1), child2);
                    }
                    assert (this.nodeLocks.get(current) == Thread.currentThread());
                    this.engine.update(current, A, this.nodeSerializer);
                    if (current == rootRecid) break block28;
                    BTreeMap.unlock(this.nodeLocks, current);
                    p = q;
                    v = A.highKey();
                    current = stackPos != -1 ? stackVals[stackPos--] : this.leftEdges.get(++level - 1);
                    if (!$assertionsDisabled && current <= 0L) break;
                }
                throw new AssertionError();
            }
            DirNode R = new DirNode(new Object[]{A.keys()[0], A.highKey(), B.isLeaf() ? null : B.highKey()}, new long[]{current, q, 0L});
            BTreeMap.lock(this.nodeLocks, this.rootRecidRef);
            BTreeMap.unlock(this.nodeLocks, current);
            long newRootRecid = this.engine.put(R, this.nodeSerializer);
            assert (this.nodeLocks.get(this.rootRecidRef) == Thread.currentThread());
            this.engine.update(this.rootRecidRef, newRootRecid, Serializer.LONG);
            this.leftEdges.add(newRootRecid);
            this.notify(v, null, value2);
            BTreeMap.unlock(this.nodeLocks, this.rootRecidRef);
            return null;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public V remove(Object key) {
        return this.remove2(key, null);
    }

    private V remove2(Object key, Object value) {
        long rootRecid;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, key);
            A = this.engine.get(current, this.nodeSerializer);
        }
        try {
            block4: while (true) {
                BTreeMap.lock(this.nodeLocks, current);
                A = this.engine.get(current, this.nodeSerializer);
                int pos = this.findChildren(key, A.keys());
                if (pos < A.keys().length && key != null && A.keys()[pos] != null && 0 == this.comparator.compare(key, A.keys()[pos])) {
                    if (pos == A.keys().length - 1 && value == null) {
                        BTreeMap.unlock(this.nodeLocks, current);
                        return null;
                    }
                    Object oldVal = A.vals()[pos - 1];
                    oldVal = this.valExpand(oldVal);
                    if (value != null && !value.equals(oldVal)) {
                        BTreeMap.unlock(this.nodeLocks, current);
                        return null;
                    }
                    Object[] keys2 = new Object[A.keys().length - 1];
                    System.arraycopy(A.keys(), 0, keys2, 0, pos);
                    System.arraycopy(A.keys(), pos + 1, keys2, pos, keys2.length - pos);
                    Object[] vals2 = new Object[A.vals().length - 1];
                    System.arraycopy(A.vals(), 0, vals2, 0, pos - 1);
                    System.arraycopy(A.vals(), pos, vals2, pos - 1, vals2.length - (pos - 1));
                    A = new LeafNode(keys2, vals2, ((LeafNode)A).next);
                    assert (this.nodeLocks.get(current) == Thread.currentThread());
                    this.engine.update(current, A, this.nodeSerializer);
                    this.notify(key, oldVal, null);
                    BTreeMap.unlock(this.nodeLocks, current);
                    return (V)oldVal;
                }
                BTreeMap.unlock(this.nodeLocks, current);
                if (A.highKey() == null || this.comparator.compare(key, A.highKey()) <= 0) break;
                int pos2 = this.findChildren(key, A.keys());
                while (true) {
                    if (pos2 != A.keys().length) continue block4;
                    current = ((LeafNode)A).next;
                    A = this.engine.get(current, this.nodeSerializer);
                }
                break;
            }
            return null;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        Iterator<K> iter = this.keyIterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    protected Map.Entry<K, V> makeEntry(Object key, Object value) {
        assert (!(value instanceof ValRef));
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
    }

    @Override
    public boolean isEmpty() {
        return !this.keyIterator().hasNext();
    }

    @Override
    public int size() {
        long size = this.sizeLong();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public long sizeLong() {
        if (this.counter != null) {
            return this.counter.get();
        }
        long size = 0L;
        BTreeIterator iter = new BTreeIterator(this);
        while (iter.hasNext()) {
            iter.advance();
            ++size;
        }
        return size;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.put2(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return this.remove2(key, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        long rootRecid;
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode node = this.engine.get(current, this.nodeSerializer);
        while (!node.isLeaf()) {
            current = this.nextDir((DirNode)node, key);
            node = this.engine.get(current, this.nodeSerializer);
        }
        BTreeMap.lock(this.nodeLocks, current);
        LeafNode leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
        int pos = this.findChildren(key, node.keys());
        try {
            while (pos == leaf.keys.length) {
                BTreeMap.lock(this.nodeLocks, leaf.next);
                BTreeMap.unlock(this.nodeLocks, current);
                current = leaf.next;
                leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
                pos = this.findChildren(key, node.keys());
            }
            boolean ret = false;
            if (key != null && leaf.keys()[pos] != null && 0 == this.comparator.compare(key, leaf.keys[pos])) {
                Object val = leaf.vals[pos - 1];
                if (oldValue.equals(val = this.valExpand(val))) {
                    Object[] vals = Arrays.copyOf(leaf.vals, leaf.vals.length);
                    this.notify(key, oldValue, newValue);
                    if (this.valsOutsideNodes) {
                        long recid = this.engine.put(newValue, this.valueSerializer);
                        newValue = new ValRef(recid);
                    }
                    vals[pos - 1] = newValue;
                    leaf = new LeafNode(Arrays.copyOf(leaf.keys, leaf.keys.length), vals, leaf.next);
                    assert (this.nodeLocks.get(current) == Thread.currentThread());
                    this.engine.update(current, leaf, this.nodeSerializer);
                    ret = true;
                }
            }
            BTreeMap.unlock(this.nodeLocks, current);
            return ret;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public V replace(K key, V value) {
        long rootRecid;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode node = this.engine.get(current, this.nodeSerializer);
        while (!node.isLeaf()) {
            current = this.nextDir((DirNode)node, key);
            node = this.engine.get(current, this.nodeSerializer);
        }
        BTreeMap.lock(this.nodeLocks, current);
        LeafNode leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
        try {
            int pos = this.findChildren(key, node.keys());
            while (pos == leaf.keys.length) {
                BTreeMap.lock(this.nodeLocks, leaf.next);
                BTreeMap.unlock(this.nodeLocks, current);
                current = leaf.next;
                leaf = (LeafNode)this.engine.get(current, this.nodeSerializer);
                pos = this.findChildren(key, node.keys());
            }
            V ret = null;
            if (key != null && leaf.keys()[pos] != null && 0 == this.comparator.compare(key, leaf.keys[pos])) {
                Object[] vals = Arrays.copyOf(leaf.vals, leaf.vals.length);
                Object oldVal = vals[pos - 1];
                ret = this.valExpand(oldVal);
                this.notify(key, ret, value);
                if (this.valsOutsideNodes && value != null) {
                    long recid = this.engine.put(value, this.valueSerializer);
                    value = new ValRef(recid);
                }
                vals[pos - 1] = value;
                leaf = new LeafNode(Arrays.copyOf(leaf.keys, leaf.keys.length), vals, leaf.next);
                assert (this.nodeLocks.get(current) == Thread.currentThread());
                this.engine.update(current, leaf, this.nodeSerializer);
            }
            BTreeMap.unlock(this.nodeLocks, current);
            return ret;
        }
        catch (RuntimeException e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw e;
        }
        catch (Exception e) {
            BTreeMap.unlockAll(this.nodeLocks);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        while (!n.isLeaf()) {
            n = this.engine.get(n.child()[0], this.nodeSerializer);
        }
        LeafNode l = (LeafNode)n;
        while (l.keys.length == 2) {
            if (l.next == 0L) {
                return null;
            }
            l = (LeafNode)this.engine.get(l.next, this.nodeSerializer);
        }
        return this.makeEntry(l.keys[1], this.valExpand(l.vals[0]));
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> e;
        while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> e;
        while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
        }
        return e;
    }

    protected Map.Entry<K, V> findSmaller(K key, boolean inclusive) {
        if (key == null) {
            throw new NullPointerException();
        }
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> k = this.findSmallerRecur(n, key, inclusive);
        if (k == null || k.getValue() == null) {
            return null;
        }
        return k;
    }

    private Map.Entry<K, V> findSmallerRecur(BNode n, K key, boolean inclusive) {
        boolean leaf = n.isLeaf();
        int start = leaf ? n.keys().length - 2 : n.keys().length - 1;
        int end = leaf ? 1 : 0;
        int res = inclusive ? 1 : 0;
        for (int i = start; i >= end; --i) {
            BNode n2;
            Map.Entry<K, V> ret;
            int comp;
            Object key2 = n.keys()[i];
            int n3 = comp = key2 == null ? -1 : this.comparator.compare(key2, key);
            if (comp >= res) continue;
            if (leaf) {
                return key2 == null ? null : this.makeEntry(key2, this.valExpand(n.vals()[i - 1]));
            }
            long recid = n.child()[i];
            if (recid == 0L || (ret = this.findSmallerRecur(n2 = this.engine.get(recid, this.nodeSerializer), key, inclusive)) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG);
        BNode n = this.engine.get(rootRecid, this.nodeSerializer);
        Map.Entry<K, V> e = this.lastEntryRecur(n);
        if (e != null && e.getValue() == null) {
            return null;
        }
        return e;
    }

    private Map.Entry<K, V> lastEntryRecur(BNode n) {
        if (n.isLeaf()) {
            BNode n2;
            Map.Entry<K, V> ret;
            if (n.next() != 0L && (ret = this.lastEntryRecur(n2 = this.engine.get(n.next(), this.nodeSerializer))) != null) {
                return ret;
            }
            for (int i = n.keys().length - 2; i > 0; --i) {
                V val;
                Object k = n.keys()[i];
                if (k == null || n.vals().length <= 0 || (val = this.valExpand(n.vals()[i - 1])) == null) continue;
                return this.makeEntry(k, val);
            }
        } else {
            for (int i = n.child().length - 1; i >= 0; --i) {
                BNode n2;
                Map.Entry<K, V> ret;
                long childRecid = n.child()[i];
                if (childRecid == 0L || (ret = this.lastEntryRecur(n2 = this.engine.get(childRecid, this.nodeSerializer))) == null) continue;
                return ret;
            }
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, false);
    }

    @Override
    public K lowerKey(K key) {
        Map.Entry<K, V> n = this.lowerEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findSmaller(key, true);
    }

    @Override
    public K floorKey(K key) {
        Map.Entry<K, V> n = this.floorEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, true);
    }

    protected Map.Entry<K, V> findLarger(K key, boolean inclusive) {
        long rootRecid;
        if (key == null) {
            return null;
        }
        K v = key;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int comp = inclusive ? 1 : 0;
        while (true) {
            for (int i = 1; i < leaf.keys.length - 1; ++i) {
                if (leaf.keys[i] == null || this.comparator.compare(key, leaf.keys[i]) >= comp) continue;
                return this.makeEntry(leaf.keys[i], this.valExpand(leaf.vals[i - 1]));
            }
            if (leaf.next == 0L) {
                return null;
            }
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
        }
    }

    protected Fun.Tuple2<Integer, LeafNode> findLargerNode(K key, boolean inclusive) {
        long rootRecid;
        if (key == null) {
            return null;
        }
        K v = key;
        long current = rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG).longValue();
        BNode A = this.engine.get(current, this.nodeSerializer);
        while (!A.isLeaf()) {
            current = this.nextDir((DirNode)A, v);
            A = this.engine.get(current, this.nodeSerializer);
        }
        LeafNode leaf = (LeafNode)A;
        int comp = inclusive ? 1 : 0;
        while (true) {
            for (int i = 1; i < leaf.keys.length - 1; ++i) {
                if (leaf.keys[i] == null || this.comparator.compare(key, leaf.keys[i]) >= comp) continue;
                return Fun.t2(i, leaf);
            }
            if (leaf.next == 0L) {
                return null;
            }
            leaf = (LeafNode)this.engine.get(leaf.next, this.nodeSerializer);
        }
    }

    @Override
    public K ceilingKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.ceilingEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.findLarger(key, false);
    }

    @Override
    public K higherKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map.Entry<K, V> n = this.higherEntry(key);
        return n == null ? null : (K)n.getKey();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Iterator<V> valueIter = this.valueIterator();
        while (valueIter.hasNext()) {
            if (!value.equals(valueIter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public K firstKey() {
        Map.Entry<K, V> e = this.firstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public K lastKey() {
        Map.Entry<K, V> e = this.lastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.getKey();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    Iterator<K> keyIterator() {
        return new BTreeKeyIterator(this);
    }

    Iterator<V> valueIterator() {
        return new BTreeValueIterator(this);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new BTreeEntryIterator(this);
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        return this.descendingMap;
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap.keySet();
    }

    static final <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    public NavigableMap<K, V> snapshot() {
        Engine snapshot = TxEngine.createSnapshotFor(this.engine);
        return new BTreeMap<K, V>(snapshot, this.rootRecidRef, this.maxNodeSize, this.valsOutsideNodes, this.counter == null ? 0L : this.counter.recid, this.keySerializer, this.valueSerializer, this.comparator, this.numberOfNodeMetas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            Bind.MapListener<K, V>[] modListeners2 = Arrays.copyOf(this.modListeners, this.modListeners.length + 1);
            modListeners2[modListeners2.length - 1] = listener;
            this.modListeners = modListeners2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModificationListener(Bind.MapListener<K, V> listener) {
        Object object = this.modListenersLock;
        synchronized (object) {
            for (int i = 0; i < this.modListeners.length; ++i) {
                if (this.modListeners[i] != listener) continue;
                this.modListeners[i] = null;
            }
        }
    }

    protected void notify(K key, V oldValue, V newValue) {
        Bind.MapListener<K, V>[] modListeners2;
        assert (!(oldValue instanceof ValRef));
        assert (!(newValue instanceof ValRef));
        for (Bind.MapListener<K, V> listener : modListeners2 = this.modListeners) {
            if (listener == null) continue;
            listener.update(key, oldValue, newValue);
        }
    }

    public void close() {
        this.engine.close();
    }

    public void printTreeStructure() {
        long rootRecid = this.engine.get(this.rootRecidRef, Serializer.LONG);
        BTreeMap.printRecur(this, rootRecid, "");
    }

    private static void printRecur(BTreeMap m, long recid, String s) {
        BNode n = m.engine.get(recid, m.nodeSerializer);
        System.out.println(s + recid + "-" + n);
        if (!n.isLeaf()) {
            for (int i = 0; i < n.child().length - 1; ++i) {
                long recid2 = n.child()[i];
                if (recid2 == 0L) continue;
                BTreeMap.printRecur(m, recid2, s + "  ");
            }
        }
    }

    protected static long[] arrayLongPut(long[] array, int pos, long value) {
        long[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    protected static Object[] arrayPut(Object[] array, int pos, Object value) {
        Object[] ret = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret, pos + 1, array.length - pos);
        }
        ret[pos] = value;
        return ret;
    }

    protected static void assertNoLocks(LongConcurrentHashMap<Thread> locks) {
        LongMap.LongMapIterator<Thread> i = locks.longMapIterator();
        Thread t = null;
        while (i.moveToNext()) {
            if (t == null) {
                t = Thread.currentThread();
            }
            if (i.value() == t) {
                throw new AssertionError((Object)("Node " + i.key() + " is still locked"));
            }
        }
    }

    protected static void unlock(LongConcurrentHashMap<Thread> locks, long recid) {
        Thread t = locks.remove(recid);
        assert (t == Thread.currentThread()) : "unlocked wrong thread";
    }

    protected static void unlockAll(LongConcurrentHashMap<Thread> locks) {
        Thread t = Thread.currentThread();
        LongMap.LongMapIterator<Thread> iter = locks.longMapIterator();
        while (iter.moveToNext()) {
            if (iter.value() != t) continue;
            iter.remove();
        }
    }

    protected static void lock(LongConcurrentHashMap<Thread> locks, long recid) {
        assert (locks.get(recid) != Thread.currentThread()) : "node already locked by current thread: " + recid;
        while (locks.putIfAbsent(recid, Thread.currentThread()) != null) {
            LockSupport.parkNanos(10L);
        }
    }

    protected static class DescendingMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        protected final BTreeMap<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public DescendingMap(BTreeMap<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.comparator.compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            Iterator<K> i = this.keyIterator();
            int counter = 0;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return counter;
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!value.equals(i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> ret = this.m.floorEntry(key);
            if (ret != null && this.tooLow(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> ret = this.m.ceilingEntry(key);
            if (ret != null && this.tooHigh(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Map.Entry<K, V> r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> k = this.lo == null ? this.m.firstEntry() : this.m.findLarger(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> k = this.hi == null ? this.m.lastEntry() : this.m.findSmaller(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private DescendingMap<K, V> newSubMap(K toKey, boolean toInclusive, K fromKey, boolean fromInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.comparator.compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.comparator.compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new DescendingMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            if (this.lo == null && this.hi == null) {
                return this.m;
            }
            return this.m.subMap((Object)this.lo, this.loInclusive, (Object)this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.hasValues);
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.comparator.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.comparator.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.hasValues);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new KeySet(this.descendingMap(), this.m.hasValues);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this);
        }

        Iterator<K> keyIterator() {
            return new Iter<K>(){

                @Override
                public K next() {
                    this.advance();
                    return this.last.getKey();
                }
            };
        }

        Iterator<V> valueIterator() {
            return new Iter<V>(){

                @Override
                public V next() {
                    this.advance();
                    return this.last.getValue();
                }
            };
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new Iter<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    this.advance();
                    return this.last;
                }
            };
        }

        abstract class Iter<E>
        implements Iterator<E> {
            Map.Entry<K, V> current;
            Map.Entry<K, V> last;

            Iter() {
                this.current = DescendingMap.this.firstEntry();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            public void advance() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = DescendingMap.this.higherEntry(this.current.getKey());
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                DescendingMap.this.remove(this.last.getKey());
                this.last = null;
            }
        }
    }

    protected static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V> {
        protected final BTreeMap<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public SubMap(BTreeMap<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.comparator.compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            Iterator<K> i = this.keyIterator();
            int counter = 0;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return counter;
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!value.equals(i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry<K, V> ret = this.m.floorEntry(key);
            if (ret != null && this.tooLow(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.firstEntry();
            }
            Map.Entry<K, V> ret = this.m.ceilingEntry(key);
            if (ret != null && this.tooHigh(ret.getKey())) {
                return null;
            }
            return ret;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Map.Entry<K, V> r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> k = this.lo == null ? this.m.firstEntry() : this.m.findLarger(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> k = this.hi == null ? this.m.lastEntry() : this.m.findSmaller(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.comparator.compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.comparator.compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.hasValues);
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.comparator.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.comparator.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.hasValues);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive).keySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this);
        }

        Iterator<K> keyIterator() {
            return new BTreeKeyIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<V> valueIterator() {
            return new BTreeValueIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return new BTreeEntryIterator(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;

        EntrySet(ConcurrentNavigableMap<K1, V1> map) {
            this.m = map;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).entryIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).entryIterator();
            }
            return ((DescendingMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.m.get(key);
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            return this.m.remove(key, e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    static final class Values<E>
    extends AbstractCollection<E> {
        private final ConcurrentNavigableMap<Object, E> m;

        Values(ConcurrentNavigableMap<Object, E> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        protected final ConcurrentNavigableMap<E, Object> m;
        private final boolean hasValues;

        KeySet(ConcurrentNavigableMap<E, Object> map, boolean hasValues) {
            this.m = map;
            this.hasValues = hasValues;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).keyIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).keyIterator();
            }
            return ((DescendingMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMap.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMap.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap((Object)toElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap((Object)fromElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap(), this.hasValues);
        }

        @Override
        public boolean add(E k) {
            if (this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return this.m.put(k, EMPTY) == null;
        }
    }

    static class BTreeEntryIterator<K, V>
    extends BTreeIterator
    implements Iterator<Map.Entry<K, V>> {
        BTreeEntryIterator(BTreeMap m) {
            super(m);
        }

        BTreeEntryIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.keys[this.currentPos];
            Object val = this.currentLeaf.vals[this.currentPos - 1];
            this.advance();
            return this.m.makeEntry(ret, this.m.valExpand(val));
        }
    }

    static class BTreeValueIterator<V>
    extends BTreeIterator
    implements Iterator<V> {
        BTreeValueIterator(BTreeMap m) {
            super(m);
        }

        BTreeValueIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public V next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.vals[this.currentPos - 1];
            this.advance();
            return this.m.valExpand(ret);
        }
    }

    static class BTreeKeyIterator<K>
    extends BTreeIterator
    implements Iterator<K> {
        BTreeKeyIterator(BTreeMap m) {
            super(m);
        }

        BTreeKeyIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            super(m, lo, loInclusive, hi, hiInclusive);
        }

        @Override
        public K next() {
            if (this.currentLeaf == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.currentLeaf.keys[this.currentPos];
            this.advance();
            return (K)ret;
        }
    }

    protected static class BTreeIterator {
        final BTreeMap m;
        LeafNode currentLeaf;
        Object lastReturnedKey;
        int currentPos;
        final Object hi;
        final boolean hiInclusive;

        BTreeIterator(BTreeMap m) {
            this.m = m;
            this.hi = null;
            this.hiInclusive = false;
            this.pointToStart();
        }

        BTreeIterator(BTreeMap m, Object lo, boolean loInclusive, Object hi, boolean hiInclusive) {
            Object key;
            int c;
            this.m = m;
            if (lo == null) {
                this.pointToStart();
            } else {
                Fun.Tuple2<Integer, LeafNode> l = m.findLargerNode(lo, loInclusive);
                this.currentPos = l != null ? (Integer)l.a : -1;
                this.currentLeaf = l != null ? (LeafNode)l.b : null;
            }
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (hi != null && this.currentLeaf != null && ((c = m.comparator.compare(key = this.currentLeaf.keys[this.currentPos], hi)) > 0 || c == 0 && !hiInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }

        private void pointToStart() {
            long rootRecid = this.m.engine.get(this.m.rootRecidRef, Serializer.LONG);
            BNode node = this.m.engine.get(rootRecid, this.m.nodeSerializer);
            while (!node.isLeaf()) {
                node = this.m.engine.get(node.child()[0], this.m.nodeSerializer);
            }
            this.currentLeaf = (LeafNode)node;
            this.currentPos = 1;
            while (this.currentLeaf.keys.length == 2) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    return;
                }
                this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
            }
        }

        public boolean hasNext() {
            return this.currentLeaf != null;
        }

        public void remove() {
            if (this.lastReturnedKey == null) {
                throw new IllegalStateException();
            }
            this.m.remove(this.lastReturnedKey);
            this.lastReturnedKey = null;
        }

        protected void advance() {
            Object key;
            int c;
            if (this.currentLeaf == null) {
                return;
            }
            this.lastReturnedKey = this.currentLeaf.keys[this.currentPos];
            ++this.currentPos;
            if (this.currentPos == this.currentLeaf.keys.length - 1) {
                if (this.currentLeaf.next == 0L) {
                    this.currentLeaf = null;
                    this.currentPos = -1;
                    return;
                }
                this.currentPos = 1;
                this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
                while (this.currentLeaf.keys.length == 2) {
                    if (this.currentLeaf.next == 0L) {
                        this.currentLeaf = null;
                        this.currentPos = -1;
                        return;
                    }
                    this.currentLeaf = (LeafNode)this.m.engine.get(this.currentLeaf.next, this.m.nodeSerializer);
                }
            }
            if (this.hi != null && this.currentLeaf != null && ((c = this.m.comparator.compare(key = this.currentLeaf.keys[this.currentPos], this.hi)) > 0 || c == 0 && !this.hiInclusive)) {
                this.currentLeaf = null;
                this.currentPos = -1;
            }
        }
    }

    protected static class NodeSerializer
    implements Serializer<BNode> {
        protected final boolean hasValues;
        protected final boolean valsOutsideNodes;
        protected final BTreeKeySerializer keySerializer;
        protected final Serializer valueSerializer;
        protected final Comparator comparator;
        protected final int numberOfNodeMetas;

        public NodeSerializer(boolean valsOutsideNodes, BTreeKeySerializer keySerializer, Serializer valueSerializer, Comparator comparator, int numberOfNodeMetas) {
            assert (keySerializer != null);
            assert (comparator != null);
            this.hasValues = valueSerializer != null;
            this.valsOutsideNodes = valsOutsideNodes;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.comparator = comparator;
            this.numberOfNodeMetas = numberOfNodeMetas;
        }

        @Override
        public void serialize(DataOutput out, BNode value) throws IOException {
            boolean right;
            boolean isLeaf = value.isLeaf();
            assert (value.keys().length <= 255);
            assert (isLeaf || value.child().length == value.keys().length);
            assert (!isLeaf || !this.hasValues || value.vals().length == value.keys().length - 2);
            assert (isLeaf || value.highKey() == null || value.child()[value.child().length - 1] != 0L);
            boolean left = value.keys()[0] == null;
            boolean bl = right = value.keys()[value.keys().length - 1] == null;
            int header = isLeaf ? (right ? (left ? 180 : 182) : (left ? 181 : 183)) : (right ? (left ? 184 : 186) : (left ? 185 : 187));
            out.write(header);
            out.write(value.keys().length);
            for (int i = 0; i < this.numberOfNodeMetas; ++i) {
                DataOutput2.packLong(out, 0L);
            }
            if (isLeaf) {
                DataOutput2.packLong(out, ((LeafNode)value).next);
            } else {
                for (long child : ((DirNode)value).child) {
                    DataOutput2.packLong(out, child);
                }
            }
            this.keySerializer.serialize(out, left ? 1 : 0, right ? value.keys().length - 1 : value.keys().length, value.keys());
            if (isLeaf) {
                if (this.hasValues) {
                    for (Object val : value.vals()) {
                        assert (val != null);
                        if (this.valsOutsideNodes) {
                            long recid = ((ValRef)val).recid;
                            DataOutput2.packLong(out, recid);
                            continue;
                        }
                        this.valueSerializer.serialize(out, val);
                    }
                } else {
                    boolean[] bools = new boolean[value.vals().length];
                    for (int i = 0; i < bools.length; ++i) {
                        bools[i] = value.vals()[i] != null;
                    }
                    byte[] bb = SerializerBase.booleanToByteArray(bools);
                    out.write(bb);
                }
            }
        }

        @Override
        public BNode deserialize(DataInput in, int available) throws IOException {
            int end;
            int header = in.readUnsignedByte();
            int size = in.readUnsignedByte();
            for (int i = 0; i < this.numberOfNodeMetas; ++i) {
                DataInput2.unpackLong(in);
            }
            boolean isLeaf = header == 183 || header == 181 || header == 180 || header == 182;
            int start = header == 181 || header == 180 || header == 185 || header == 184 ? 1 : 0;
            int n = end = header == 182 || header == 180 || header == 186 || header == 184 ? size - 1 : size;
            if (isLeaf) {
                long next = DataInput2.unpackLong(in);
                Object[] keys = this.keySerializer.deserialize(in, start, end, size);
                assert (keys.length == size);
                Object[] vals = null;
                vals = new Object[size - 2];
                if (this.hasValues) {
                    for (int i = 0; i < size - 2; ++i) {
                        long recid;
                        vals[i] = this.valsOutsideNodes ? ((recid = DataInput2.unpackLong(in)) == 0L ? null : new ValRef(recid)) : this.valueSerializer.deserialize(in, -1);
                    }
                } else {
                    boolean[] bools = SerializerBase.readBooleanArray(vals.length, in);
                    for (int i = 0; i < bools.length; ++i) {
                        if (!bools[i]) continue;
                        vals[i] = EMPTY;
                    }
                }
                return new LeafNode(keys, vals, next);
            }
            long[] child = new long[size];
            for (int i = 0; i < size; ++i) {
                child[i] = DataInput2.unpackLong(in);
            }
            Object[] keys = this.keySerializer.deserialize(in, start, end, size);
            assert (keys.length == size);
            return new DirNode(keys, child);
        }

        @Override
        public int fixedSize() {
            return -1;
        }
    }

    protected static final class LeafNode
    implements BNode {
        final Object[] keys;
        final Object[] vals;
        final long next;

        LeafNode(Object[] keys, Object[] vals, long next) {
            this.keys = keys;
            this.vals = vals;
            this.next = next;
            assert (vals == null || keys.length == vals.length + 2);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Object[] keys() {
            return this.keys;
        }

        @Override
        public Object[] vals() {
            return this.vals;
        }

        @Override
        public Object highKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public long[] child() {
            return null;
        }

        @Override
        public long next() {
            return this.next;
        }

        public String toString() {
            return "Leaf(K" + Arrays.toString(this.keys) + ", V" + Arrays.toString(this.vals) + ", L=" + this.next + ")";
        }
    }

    protected static final class DirNode
    implements BNode {
        final Object[] keys;
        final long[] child;

        DirNode(Object[] keys, long[] child) {
            this.keys = keys;
            this.child = child;
        }

        DirNode(Object[] keys, List<Long> child) {
            this.keys = keys;
            this.child = new long[child.size()];
            for (int i = 0; i < child.size(); ++i) {
                this.child[i] = child.get(i);
            }
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public Object[] keys() {
            return this.keys;
        }

        @Override
        public Object[] vals() {
            return null;
        }

        @Override
        public Object highKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public long[] child() {
            return this.child;
        }

        @Override
        public long next() {
            return this.child[this.child.length - 1];
        }

        public String toString() {
            return "Dir(K" + Arrays.toString(this.keys) + ", C" + Arrays.toString(this.child) + ")";
        }
    }

    protected static interface BNode {
        public boolean isLeaf();

        public Object[] keys();

        public Object[] vals();

        public Object highKey();

        public long[] child();

        public long next();
    }

    protected static final class ValRef {
        final long recid;

        public ValRef(long recid) {
            this.recid = recid;
        }

        public boolean equals(Object obj) {
            throw new IllegalAccessError();
        }

        public int hashCode() {
            throw new IllegalAccessError();
        }

        public String toString() {
            return "BTreeMap-ValRer[" + this.recid + "]";
        }
    }
}

