/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"date_format"}, parameter="(String timestampStr, String formatStr)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return a string value that converts a timestamp (in seconds) to a date format string in the specified format.", "Note: The format string is compatible with Java\u2019s SimpleDateFormat"}, examples={"date_format('2024-08-01 22:56:56', 'yyyy/MM/dd HH:mm:ss') = \"2024/08/01 22:56:56\""})
public class DateFormatFunction
implements ValueParser {
    private ValueParser timestampParser;
    private ValueParser formatParser;
    private static final Map<String, SimpleDateFormat> SIMPLE_DATE_FORMATS = new ConcurrentHashMap<String, SimpleDateFormat>();

    public DateFormatFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.timestampParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.formatParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object timestampObj = this.timestampParser.parse(sourceData, rowIndex, context);
        Object formatObj = this.formatParser.parse(sourceData, rowIndex, context);
        if (timestampObj == null || formatObj == null) {
            return null;
        }
        Timestamp timestamp = OperatorTools.parseTimestamp(timestampObj);
        String format = OperatorTools.parseString(formatObj);
        SimpleDateFormat sdf = this.getSimpleDateFormat(format);
        Date date = new Date(timestamp.getTime());
        return sdf.format(date);
    }

    private SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat sdf = SIMPLE_DATE_FORMATS.get(pattern);
        if (sdf == null) {
            sdf = new SimpleDateFormat(pattern);
            SIMPLE_DATE_FORMATS.put(pattern, sdf);
        }
        return sdf;
    }
}

