/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"repeat", "replicate"}, parameter="(String str, Integer times)", descriptions={"- Return \"\" if any parameter is null;", "- Return a new string that repeats the 'str' by a certain number of 'times'."}, examples={"repeat('apple', 2) = \"appleapple\""})
public class RepeatFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser countParser;

    public RepeatFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.countParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object countObj = this.countParser.parse(sourceData, rowIndex, context);
        if (stringObj == null || countObj == null) {
            return null;
        }
        if (stringObj.equals("") || countObj.equals("")) {
            return "";
        }
        String str = OperatorTools.parseString(stringObj);
        double count = OperatorTools.parseBigDecimal(countObj).doubleValue();
        return this.repeat(str, count);
    }

    private String repeat(String str, double count) {
        if (count == 0.0) {
            return "";
        }
        if (count == 1.0) {
            return str;
        }
        StringBuilder repeatedStr = new StringBuilder();
        StringBuilder originStr = new StringBuilder(str);
        while (count > 0.0) {
            if (count % 2.0 != 0.0) {
                repeatedStr.append((CharSequence)originStr);
            }
            count = Math.floor(count / 2.0);
            originStr.append((CharSequence)originStr);
        }
        return repeatedStr.toString();
    }
}

