/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"is_alpha"}, parameter="(String str)", descriptions={"- Return \"\" If 'str' is NULL;", "- Return true if all characters in 'str' are letter;", "- Return false otherwise (Including cases where string is null and '')."}, examples={"is_alpha('inlong') = true", "is_alpha('inlong~') = false"})
public class IsAlphaFunction
implements ValueParser {
    private final ValueParser stringParser;

    public IsAlphaFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return false;
        }
        String string = OperatorTools.parseString(stringObject);
        if (string.isEmpty()) {
            return false;
        }
        for (char chr : string.toCharArray()) {
            if (chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z') continue;
            return false;
        }
        return true;
    }
}

