/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.nio.charset.Charset;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="string", names={"bit_length"}, parameter="(String str,[String charset])", descriptions={"- Return \"\" if the 'str' is NULL;", "- Return number of bits in 'str'.", "Note: Charset is aligned with the JVM by default."}, examples={"bit_length(\"hello world\") = 88", "bit_length(\"hello \u4f60\u597d\",\"utf-8\") = 96"})
public class BitLengthFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(BitLengthFunction.class);
    private final ValueParser stringParser;
    private final ValueParser charsetParser;
    private final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    public BitLengthFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.charsetParser = expressions.size() == 2 ? OperatorTools.buildParser((Expression)expressions.get(1)) : null;
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return null;
        }
        try {
            Object charsetObj;
            Charset charset = this.DEFAULT_CHARSET;
            if (this.charsetParser != null && (charsetObj = this.charsetParser.parse(sourceData, rowIndex, context)) != null) {
                charset = Charset.forName(OperatorTools.parseString(charsetObj));
            }
            return OperatorTools.parseString(stringObject).getBytes(charset).length * 8;
        }
        catch (Exception e) {
            log.error("Analysis failed", (Throwable)e);
            return null;
        }
    }
}

