/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_insert"}, parameter="(String json_doc, String path1, String val1[, String path2, String val2, ...] )", descriptions={"- Return \"\" if any argument is NULL or the 'json_doc' argument is not a valid JSON document or any path argument is not a valid path expression or contains a * or ** wildcard.;", "- Return the result of inserting data into 'json_doc'."}, examples={"json_insert({\"a\": {\"b\": [1, 2]}, \"c\": [3, 4]}, $.c[1][1], \"2\", \"$.c[1][1][5]\", \"1\") = {\"a\":{\"b\":[1,2]},\"c\":[3,[4,[\"2\",\"1\"]]]}"})
public class JsonInsertFunction
implements ValueParser {
    private final ValueParser jsonDocParser;
    private final List<ValueParser> pathValuePairsParser;

    public JsonInsertFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.jsonDocParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.pathValuePairsParser = new ArrayList<ValueParser>();
        for (int i = 1; i < expressions.size(); ++i) {
            this.pathValuePairsParser.add(OperatorTools.buildParser((Expression)expressions.get(i)));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object jsonDocObj = this.jsonDocParser.parse(sourceData, rowIndex, context);
        if (jsonDocObj == null) {
            return null;
        }
        ArrayList<Object> pathValuePairs = new ArrayList<Object>();
        for (ValueParser valueParser : this.pathValuePairsParser) {
            pathValuePairs.add(valueParser.parse(sourceData, rowIndex, context));
        }
        return JsonInsertFunction.jsonInsert(jsonDocObj.toString(), pathValuePairs);
    }

    private static String jsonInsert(String json, ArrayList<Object> pathValuePairs) {
        JSONObject jsonObject;
        if (json == null || pathValuePairs == null || pathValuePairs.size() % 2 != 0) {
            return null;
        }
        try {
            jsonObject = JSON.parseObject((String)json);
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < pathValuePairs.size(); i += 2) {
            JSONArray jsonArr;
            String path = (String)pathValuePairs.get(i);
            Object value = pathValuePairs.get(i + 1);
            if (path == null || value == null) {
                return null;
            }
            if (path.contains("*") || path.contains("**")) {
                throw new IllegalArgumentException("Invalid path expression: " + path);
            }
            List<Object> tokens = JsonInsertFunction.parsePath(path);
            if (tokens.isEmpty()) continue;
            Object current = jsonObject;
            JSONObject parent = null;
            Object currentToken = null;
            for (int j = 0; j < tokens.size() - 1; ++j) {
                JSONArray jsonArr2;
                Object nextToken;
                Object next;
                Object token = tokens.get(j);
                parent = current;
                currentToken = token;
                if (token instanceof String) {
                    JSONObject jsonObj;
                    String key = (String)token;
                    if (!(current instanceof JSONObject)) {
                        JSONObject newObj = new JSONObject();
                        if (parent instanceof JSONObject) {
                            parent.put((String)currentToken, (Object)newObj);
                        } else if (parent instanceof JSONArray) {
                            ((JSONArray)parent).set(((Integer)currentToken).intValue(), (Object)newObj);
                        }
                        current = newObj;
                    }
                    if ((next = (jsonObj = current).get((Object)key)) == null) {
                        nextToken = tokens.get(j + 1);
                        next = nextToken instanceof Integer ? new JSONArray() : new JSONObject();
                        jsonObj.put(key, next);
                    }
                    current = next;
                    continue;
                }
                if (!(token instanceof Integer)) continue;
                int index = (Integer)token;
                if (!(current instanceof JSONArray)) {
                    JSONArray newArr = new JSONArray();
                    newArr.add(current);
                    if (parent instanceof JSONObject) {
                        parent.put((String)currentToken, (Object)newArr);
                    } else if (parent instanceof JSONArray) {
                        ((JSONArray)parent).set(((Integer)currentToken).intValue(), (Object)newArr);
                    }
                    current = newArr;
                }
                if ((jsonArr2 = (JSONArray)current).size() <= index) {
                    index = jsonArr2.size();
                }
                if ((next = jsonArr2.get(index)) == null) {
                    nextToken = tokens.get(j + 1);
                    next = nextToken instanceof Integer ? new JSONArray() : new JSONObject();
                    jsonArr2.set(index, next);
                }
                current = next;
            }
            Object lastToken = tokens.get(tokens.size() - 1);
            if (lastToken instanceof String) {
                JSONObject jsonObj;
                String key = (String)lastToken;
                if (!(current instanceof JSONObject)) {
                    JSONObject newObj = new JSONObject();
                    if (parent instanceof JSONObject) {
                        parent.put((String)currentToken, (Object)newObj);
                    } else if (parent instanceof JSONArray) {
                        ((JSONArray)parent).set(((Integer)currentToken).intValue(), (Object)newObj);
                    }
                    current = newObj;
                }
                if ((jsonObj = current).containsKey((Object)key)) continue;
                jsonObj.put(key, JsonInsertFunction.parseValue(value));
                continue;
            }
            if (!(lastToken instanceof Integer)) continue;
            int index = (Integer)lastToken;
            if (!(current instanceof JSONArray)) {
                JSONArray newArr = new JSONArray();
                newArr.add(current);
                if (parent instanceof JSONObject) {
                    parent.put((String)currentToken, (Object)newArr);
                } else if (parent instanceof JSONArray) {
                    ((JSONArray)parent).set(((Integer)currentToken).intValue(), (Object)newArr);
                }
                current = newArr;
            }
            if (index < (jsonArr = (JSONArray)current).size() && jsonArr.get(index) != null) continue;
            if (jsonArr.size() <= index) {
                index = jsonArr.size();
            }
            jsonArr.set(index, JsonInsertFunction.parseValue(value));
        }
        return jsonObject.toJSONString();
    }

    private static Object parseValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            try {
                Object json = JSON.parse((String)str);
                if (json instanceof JSONObject || json instanceof JSONArray) {
                    return json;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private static List<Object> parsePath(String path) {
        if (path == null || !path.startsWith("$")) {
            throw new IllegalArgumentException("Invalid path expression: " + path);
        }
        ArrayList<Object> tokens = new ArrayList<Object>();
        int i = 1;
        int len = path.length();
        while (i < len) {
            int start;
            char c = path.charAt(i);
            if (c == '.') {
                start = ++i;
                while (i < len && path.charAt(i) != '.' && path.charAt(i) != '[') {
                    ++i;
                }
                if (start == i) {
                    throw new IllegalArgumentException("Invalid path expression: " + path);
                }
                String key = path.substring(start, i);
                tokens.add(key);
                continue;
            }
            if (c == '[') {
                start = ++i;
                while (i < len && path.charAt(i) != ']') {
                    ++i;
                }
                if (i == len || path.charAt(i) != ']') {
                    throw new IllegalArgumentException("Invalid path expression: " + path);
                }
                String indexStr = path.substring(start, i);
                ++i;
                try {
                    int index = Integer.parseInt(indexStr);
                    tokens.add(index);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid array index in path: " + path);
                }
            }
            throw new IllegalArgumentException("Invalid path expression: " + path);
        }
        return tokens;
    }
}

