/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.condition;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="condition", names={"if"}, parameter="(Expr expr1,Expr expr2,Expr expr3)", descriptions={"- Return 'expr2' if 'expr1' returns true;", "- Return 'expr3' otherwise."}, examples={"if(1 = 1,true,false) = true"})
public class IfFunction
implements ValueParser {
    private final ExpressionOperator expressionOperator;
    private final ValueParser tureValueParser;
    private final ValueParser falseValueParser;

    public IfFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.expressionOperator = OperatorTools.buildOperator((Expression)expressions.get(0));
        this.tureValueParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.falseValueParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        boolean condition = this.expressionOperator.check(sourceData, rowIndex, context);
        return condition ? this.tureValueParser.parse(sourceData, rowIndex, context) : this.falseValueParser.parse(sourceData, rowIndex, context);
    }
}

