/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_append"}, parameter="(Array array, Object element)", descriptions={"- Return \"\" if either argument is NULL;", "- Return the result of appends an element to the end of the 'array'."}, examples={"array_append(array('he',7,'xxd'), 'cloud') = [he, 7, xxd, cloud]"})
public class ArrayAppendFunction
implements ValueParser {
    private final ValueParser arrayParser;
    private final ValueParser elementParser;

    public ArrayAppendFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.elementParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object elementObj = this.elementParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            array.add(elementObj);
            return array;
        }
        return null;
    }
}

