/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KvUtils {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_KEY = 2;
    private static final int STATE_VALUE = 4;
    private static final int STATE_ESCAPING = 8;
    private static final int STATE_QUOTING = 16;

    public static Map<String, String> splitKv(@Nonnull String text, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        List<Map<String, String>> lines = KvUtils.splitKv(text, entryDelimiter, kvDelimiter, escapeChar, quoteChar, null);
        if (lines.size() == 0) {
            return new HashMap<String, String>();
        }
        return lines.get(0);
    }

    public static List<Map<String, String>> splitKv(@Nonnull String text, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter) {
        String value;
        HashMap<String, String> fields = new HashMap<String, String>();
        ArrayList<Map<String, String>> lines = new ArrayList<Map<String, String>>();
        StringBuilder stringBuilder = new StringBuilder();
        String key = "";
        int state = 2;
        int kvState = 2;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == kvDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        key = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        state = 4;
                        break;
                    }
                    case 4: 
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == entryDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        key = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        fields.put(key, "");
                        state = 2;
                        break;
                    }
                    case 4: {
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        stringBuilder.setLength(0);
                        state = 2;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 8;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 16;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        state = kvState;
                        break;
                    }
                }
                continue;
            }
            if (lineDelimiter != null && ch == lineDelimiter.charValue()) {
                switch (state) {
                    case 4: {
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        HashMap<String, String> copyFields = new HashMap<String, String>();
                        copyFields.putAll(fields);
                        lines.add(copyFields);
                        stringBuilder.setLength(0);
                        fields.clear();
                        state = 2;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            stringBuilder.append(ch);
        }
        switch (state) {
            case 2: {
                key = stringBuilder.toString();
                stringBuilder.setLength(0);
                fields.put(key, "");
                lines.add(fields);
                return lines;
            }
            case 4: {
                value = stringBuilder.toString();
                fields.put(key, value);
                lines.add(fields);
                return lines;
            }
        }
        if (kvState == 4) {
            key = stringBuilder.toString();
            stringBuilder.setLength(0);
            fields.put(key, "");
            lines.add(fields);
            return lines;
        }
        value = stringBuilder.toString();
        fields.put(key, value);
        lines.add(fields);
        return lines;
    }

    public static String concatKv(@Nonnull String[] fieldKeys, @Nonnull String[] fieldValues, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        if (fieldKeys.length != fieldValues.length) {
            throw new IllegalArgumentException("The keys' number " + fieldKeys.length + " doesn't match values' number " + fieldValues.length);
        }
        List<Character> delimiters = Arrays.asList(entryDelimiter, kvDelimiter);
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < fieldKeys.length; ++index) {
            KvUtils.encodeText(stringBuilder, fieldKeys[index], delimiters, escapeChar, quoteChar);
            stringBuilder.append(kvDelimiter);
            KvUtils.encodeText(stringBuilder, fieldValues[index], delimiters, escapeChar, quoteChar);
            if (index >= fieldKeys.length - 1) continue;
            stringBuilder.append(entryDelimiter);
        }
        return stringBuilder.toString();
    }

    private static void encodeText(StringBuilder stringBuilder, String text, Collection<Character> delimiters, Character escapeChar, Character quoteChar) {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (delimiters.contains(Character.valueOf(ch))) {
                if (escapeChar != null) {
                    stringBuilder.append(escapeChar);
                    stringBuilder.append(ch);
                    continue;
                }
                if (quoteChar != null) {
                    stringBuilder.append(quoteChar);
                    stringBuilder.append(ch);
                    stringBuilder.append(quoteChar);
                    continue;
                }
                throw new IllegalArgumentException("There is a delimiter in the text, but neither escape nor quote character is specified.");
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                stringBuilder.append(escapeChar);
                stringBuilder.append(ch);
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                if (escapeChar != null) {
                    stringBuilder.append(escapeChar);
                    stringBuilder.append(ch);
                    continue;
                }
                throw new IllegalArgumentException("There is a quote character in the text, but escape character is not specified.");
            }
            stringBuilder.append(ch);
        }
    }

    public static String[] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        String[][] splitResult = KvUtils.splitCsv(text, delimiter, escapeChar, quoteChar, null);
        if (splitResult.length == 0) {
            return new String[0];
        }
        return splitResult[0];
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter) {
        return KvUtils.splitCsv(text, delimiter, escapeChar, quoteChar, lineDelimiter, false);
    }

    public static String[][] splitCsv(@Nonnull String text, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar, @Nullable Character lineDelimiter, boolean deleteHeadDelimiter) {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int state = 0;
        for (int i = 0; i < text.length(); ++i) {
            String field;
            char ch = text.charAt(i);
            if (ch == delimiter.charValue()) {
                switch (state) {
                    case 0: {
                        if (deleteHeadDelimiter && fields.isEmpty() && stringBuilder.length() == 0) break;
                        field = stringBuilder.toString();
                        fields.add(field);
                        stringBuilder.setLength(0);
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                switch (state) {
                    case 0: {
                        state = 8;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                switch (state) {
                    case 0: {
                        state = 16;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (lineDelimiter != null && ch == lineDelimiter.charValue()) {
                switch (state) {
                    case 0: {
                        field = stringBuilder.toString();
                        fields.add(field);
                        lines.add(fields.toArray(new String[0]));
                        stringBuilder.setLength(0);
                        fields.clear();
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = 0;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (state == 8) {
                state = 0;
            }
            stringBuilder.append(ch);
        }
        switch (state) {
            case 0: {
                String field = stringBuilder.toString();
                fields.add(field);
                lines.add(fields.toArray(new String[0]));
                String[][] result = new String[lines.size()][];
                for (int i = 0; i < lines.size(); ++i) {
                    result[i] = (String[])lines.get(i);
                }
                return result;
            }
            case 8: {
                throw new IllegalArgumentException(String.format("Not closed escaping. Text=[%s].", text));
            }
            case 16: {
                throw new IllegalArgumentException(String.format("Not closed quoting. Text=[%s].", text));
            }
        }
        throw new IllegalStateException(String.format("Text=[%s].", text));
    }

    public static String concatCsv(@Nonnull String[] fields, @Nonnull Character delimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < fields.length; ++index) {
            String field = fields[index];
            for (int i = 0; i < field.length(); ++i) {
                char ch = field.charAt(i);
                if (ch == delimiter.charValue() || escapeChar != null && ch == escapeChar.charValue() || quoteChar != null && ch == quoteChar.charValue()) {
                    if (escapeChar != null) {
                        stringBuilder.append(escapeChar);
                        stringBuilder.append(ch);
                        continue;
                    }
                    if (quoteChar != null && ch != quoteChar.charValue()) {
                        stringBuilder.append(quoteChar);
                        stringBuilder.append(ch);
                        stringBuilder.append(quoteChar);
                        continue;
                    }
                    throw new IllegalArgumentException("There exist special characters in the text, but neither escape character nor quote character is configured.");
                }
                stringBuilder.append(ch);
            }
            if (index >= fields.length - 1) continue;
            stringBuilder.append(delimiter);
        }
        return stringBuilder.toString();
    }
}

