/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="starRocksLoad")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StarRocksLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -8002903269814211382L;
    @JsonProperty(value="jdbc-url")
    @Nonnull
    private String jdbcUrl;
    @JsonProperty(value="load-url")
    @Nonnull
    private String loadUrl;
    @JsonProperty(value="username")
    @Nonnull
    private String username;
    @JsonProperty(value="password")
    @Nonnull
    private String password;
    @JsonProperty(value="database-name")
    @Nullable
    private String databaseName;
    @JsonProperty(value="table-name")
    private String tableName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @Nullable
    @JsonProperty(value="sinkMultipleEnable")
    private Boolean sinkMultipleEnable = false;
    @Nullable
    @JsonProperty(value="sinkMultipleFormat")
    private Format sinkMultipleFormat;
    @Nullable
    @JsonProperty(value="databasePattern")
    private String databasePattern;
    @Nullable
    @JsonProperty(value="tablePattern")
    private String tablePattern;

    @JsonCreator
    public StarRocksLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="jdbc-url") String jdbcUrl, @Nonnull @JsonProperty(value="load-url") String loadUrl, @Nonnull @JsonProperty(value="username") String userName, @Nonnull @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="database-name") String databaseName, @JsonProperty(value="table-name") String tableName, @JsonProperty(value="primaryKey") String primaryKey, @Nullable @JsonProperty(value="sinkMultipleEnable", defaultValue="false") Boolean sinkMultipleEnable, @Nullable @JsonProperty(value="sinkMultipleFormat") Format sinkMultipleFormat, @Nullable @JsonProperty(value="databasePattern") String databasePattern, @Nullable @JsonProperty(value="tablePattern") String tablePattern) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.jdbcUrl = (String)Preconditions.checkNotNull((Object)jdbcUrl, (Object)"jdbc-url is null");
        this.loadUrl = (String)Preconditions.checkNotNull((Object)loadUrl, (Object)"load-url is null");
        this.username = (String)Preconditions.checkNotNull((Object)userName, (Object)"username is null");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password is null");
        this.databaseName = (String)Preconditions.checkNotNull((Object)databaseName, (Object)"database-name is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"table-name is null");
        this.primaryKey = primaryKey;
        this.sinkMultipleEnable = sinkMultipleEnable;
        if (sinkMultipleEnable != null && sinkMultipleEnable.booleanValue()) {
            this.databasePattern = (String)Preconditions.checkNotNull((Object)databasePattern, (Object)"databasePattern is null");
            this.tablePattern = (String)Preconditions.checkNotNull((Object)tablePattern, (Object)"tablePattern is null");
            this.sinkMultipleFormat = (Format)Preconditions.checkNotNull((Object)sinkMultipleFormat, (Object)"sinkMultipleFormat is null");
        }
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        if (this.getProperties() != null && !this.getProperties().isEmpty()) {
            options.putAll(this.getProperties());
        }
        options.put("connector", "starrocks-inlong");
        options.put("jdbc-url", this.jdbcUrl);
        options.put("load-url", this.loadUrl);
        options.put("username", this.username);
        options.put("password", this.password);
        options.put("database-name", this.databaseName);
        options.put("table-name", this.tableName);
        if (this.sinkMultipleEnable != null && this.sinkMultipleEnable.booleanValue()) {
            options.put("sink.multiple.enable", this.sinkMultipleEnable.toString());
            options.put("sink.multiple.format", Objects.requireNonNull(this.sinkMultipleFormat).identifier());
            options.put("sink.multiple.database-pattern", this.databasePattern);
            options.put("sink.multiple.table-pattern", this.tablePattern);
        } else {
            options.put("sink.multiple.enable", "false");
        }
        options.put("sink.properties.format", "json");
        options.put("sink.properties.strip_outer_array", "true");
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", super.getId());
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarRocksLoadNode)) {
            return false;
        }
        StarRocksLoadNode other = (StarRocksLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$loadUrl = this.getLoadUrl();
        String other$loadUrl = other.getLoadUrl();
        if (this$loadUrl == null ? other$loadUrl != null : !this$loadUrl.equals(other$loadUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Format this$sinkMultipleFormat = this.getSinkMultipleFormat();
        Format other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        return !(this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StarRocksLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $loadUrl = this.getLoadUrl();
        result = result * 59 + ($loadUrl == null ? 43 : $loadUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Format $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        return result;
    }

    @Nonnull
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Nonnull
    public String getLoadUrl() {
        return this.loadUrl;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Nullable
    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    @Nullable
    public Format getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    @Nullable
    public String getDatabasePattern() {
        return this.databasePattern;
    }

    @Nullable
    public String getTablePattern() {
        return this.tablePattern;
    }

    public void setJdbcUrl(@Nonnull String jdbcUrl) {
        if (jdbcUrl == null) {
            throw new NullPointerException("jdbcUrl is marked non-null but is null");
        }
        this.jdbcUrl = jdbcUrl;
    }

    public void setLoadUrl(@Nonnull String loadUrl) {
        if (loadUrl == null) {
            throw new NullPointerException("loadUrl is marked non-null but is null");
        }
        this.loadUrl = loadUrl;
    }

    public void setUsername(@Nonnull String username) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setDatabaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(@Nullable Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(@Nullable Format sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(@Nullable String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(@Nullable String tablePattern) {
        this.tablePattern = tablePattern;
    }

    @Override
    public String toString() {
        return "StarRocksLoadNode(jdbcUrl=" + this.getJdbcUrl() + ", loadUrl=" + this.getLoadUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ")";
    }

    public StarRocksLoadNode() {
    }
}

