/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.format;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.node.format.Format;

@JsonTypeName(value="rawFormat")
public class RawFormat
implements Format {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "raw";
    @JsonProperty(value="rawCharset", defaultValue="UTF-8")
    private String rawCharset;
    @JsonProperty(value="rawEndianness", defaultValue="big-endian")
    private String rawEndianness;

    @JsonCreator
    public RawFormat(@JsonProperty(value="rawCharset", defaultValue="UTF-8") String rawCharset, @JsonProperty(value="rawEndianness", defaultValue="big-endian") String rawEndianness) {
        this.rawCharset = rawCharset;
        this.rawEndianness = rawEndianness;
    }

    @JsonCreator
    public RawFormat() {
        this("UTF-8", "big-endian");
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return IDENTIFIER;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Map<String, String> generateOptions() {
        HashMap<String, String> options = new HashMap<String, String>(16);
        options.put("format", this.getFormat());
        options.put("raw.charset", this.rawCharset);
        options.put("raw.endianness", this.rawEndianness);
        return options;
    }

    public String getRawCharset() {
        return this.rawCharset;
    }

    public String getRawEndianness() {
        return this.rawEndianness;
    }

    public void setRawCharset(String rawCharset) {
        this.rawCharset = rawCharset;
    }

    public void setRawEndianness(String rawEndianness) {
        this.rawEndianness = rawEndianness;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawFormat)) {
            return false;
        }
        RawFormat other = (RawFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rawCharset = this.getRawCharset();
        String other$rawCharset = other.getRawCharset();
        if (this$rawCharset == null ? other$rawCharset != null : !this$rawCharset.equals(other$rawCharset)) {
            return false;
        }
        String this$rawEndianness = this.getRawEndianness();
        String other$rawEndianness = other.getRawEndianness();
        return !(this$rawEndianness == null ? other$rawEndianness != null : !this$rawEndianness.equals(other$rawEndianness));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rawCharset = this.getRawCharset();
        result = result * 59 + ($rawCharset == null ? 43 : $rawCharset.hashCode());
        String $rawEndianness = this.getRawEndianness();
        result = result * 59 + ($rawEndianness == null ? 43 : $rawEndianness.hashCode());
        return result;
    }

    public String toString() {
        return "RawFormat(rawCharset=" + this.getRawCharset() + ", rawEndianness=" + this.getRawEndianness() + ")";
    }
}

