/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.selector.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.selector.api.Selector;
import org.apache.inlong.audit.service.selector.api.SelectorConfig;
import org.apache.inlong.audit.service.selector.impl.DBDataSource;
import org.apache.inlong.audit.service.selector.impl.SelectorImpl;
import org.apache.inlong.audit.service.selector.task.DBMonitorTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorImpl
extends Selector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectorImpl.class);
    private final SelectorConfig selectorConfig;
    private final ExecutorService fixedThreadPool;
    private boolean canElector = true;
    private final DBDataSource dbDataSource;
    private long sleepTime = 0L;
    private boolean running = true;

    public SelectorImpl(SelectorConfig selectorConfig) {
        this.selectorConfig = selectorConfig;
        this.dbDataSource = new DBDataSource(selectorConfig);
        this.fixedThreadPool = Executors.newFixedThreadPool(Configuration.getInstance().get("selector.thread.pool.size", 3));
    }

    public void init() throws Exception {
        try {
            LOGGER.info("Init selector impl...");
            this.dbDataSource.init(true);
            this.fixedThreadPool.execute((Runnable)new ElectorWorkerThread(this));
            this.fixedThreadPool.execute((Runnable)new DBMonitorTask(this.selectorConfig, this.dbDataSource));
        }
        catch (Exception exception) {
            LOGGER.error("Failed to init selector", (Throwable)exception);
        }
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void releaseLeader() {
        if (this.isLeader) {
            try {
                this.dbDataSource.releaseLeader();
            }
            catch (Exception exception) {
                LOGGER.error("Exception :{}", (Object)exception.getMessage());
            }
        }
        try {
            TimeUnit.SECONDS.sleep(Configuration.getInstance().get("release.leader.interval", 40));
        }
        catch (Exception exception) {
            LOGGER.error("Exception :{}", (Object)exception.getMessage());
        }
    }

    public void replaceLeader(String newLeaderId) {
        this.sleepTime = (long)this.selectorConfig.getTryToBeLeaderInterval() * 2L;
        this.dbDataSource.replaceLeader(newLeaderId);
    }

    public String getLeader(String serviceId) {
        return this.dbDataSource.getCurrentLeader();
    }

    public void canSelect(boolean canElector) {
        this.canElector = canElector;
    }

    public boolean rebuildSelectorDBSource() {
        this.canSelect(false);
        try {
            this.releaseLeader();
            this.dbDataSource.close();
            this.dbDataSource.init(false);
            this.canSelect(true);
        }
        catch (Exception exception) {
            LOGGER.error("Exception :{}", (Object)exception.getMessage());
            return false;
        }
        return true;
    }

    public void close() {
        this.running = false;
        this.dbDataSource.close();
        this.fixedThreadPool.shutdown();
    }

    static /* synthetic */ boolean access$000(SelectorImpl x0) {
        return x0.running;
    }

    static /* synthetic */ boolean access$100(SelectorImpl x0) {
        return x0.canElector;
    }

    static /* synthetic */ DBDataSource access$200(SelectorImpl x0) {
        return x0.dbDataSource;
    }

    static /* synthetic */ SelectorConfig access$300(SelectorImpl x0) {
        return x0.selectorConfig;
    }

    static /* synthetic */ boolean access$400(SelectorImpl x0) {
        return x0.isLeader;
    }

    static /* synthetic */ boolean access$502(SelectorImpl x0, boolean x1) {
        x0.isLeader = x1;
        return x0.isLeader;
    }

    static /* synthetic */ long access$602(SelectorImpl x0, long x1) {
        x0.sleepTime = x1;
        return x0.sleepTime;
    }

    static /* synthetic */ boolean access$700(SelectorImpl x0) {
        return x0.isLeader;
    }

    static /* synthetic */ boolean access$802(SelectorImpl x0, boolean x1) {
        x0.isLeader = x1;
        return x0.isLeader;
    }

    static /* synthetic */ long access$600(SelectorImpl x0) {
        return x0.sleepTime;
    }

    static /* synthetic */ Logger access$900() {
        return LOGGER;
    }
}

