/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.metric;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.ApiType;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.metric.MetricItem;
import org.apache.inlong.audit.service.metric.MetricStat;
import org.apache.inlong.audit.service.metric.MetricsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsManager.class);
    private AbstractMetric metric;
    private final MetricItem metricItem = new MetricItem();
    protected final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        try {
            String metricClassName = Configuration.getInstance().get("audit.service.metric.classname", "org.apache.inlong.audit.service.metric.prometheus.ServicePrometheusMetric");
            LOGGER.info("Metric class name: {}", (Object)metricClassName);
            Constructor<?> constructor = Class.forName(metricClassName).getDeclaredConstructor(MetricItem.class);
            constructor.setAccessible(true);
            this.metric = (AbstractMetric)constructor.newInstance(this.metricItem);
            this.timer.scheduleWithFixedDelay(() -> {
                this.metric.report();
                this.metricItem.resetAllMetrics();
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            LOGGER.error("Init metrics manager has exception: ", (Throwable)exception);
        }
    }

    public static MetricsManager getInstance() {
        return Holder.access$000();
    }

    public void addApiMetric(ApiType apiType, long duration) {
        MetricStat metricStat = this.metricItem.getMetricStat(apiType.name());
        metricStat.getCount().addAndGet(1L);
        metricStat.getDuration().addAndGet(duration);
    }

    public void addApiMetricNoCache(AuditCycle auditCycle, long duration) {
        MetricStat metricStat = this.metricItem.getMetricStat(auditCycle.toString());
        metricStat.getCount().addAndGet(1L);
        metricStat.getDuration().addAndGet(duration);
    }

    public void shutdown() {
        this.timer.shutdown();
        this.metric.stop();
    }
}

