/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.inlong.audit.entity.AuditComponent;
import org.apache.inlong.audit.entity.AuditProxy;
import org.apache.inlong.audit.service.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditProxyCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditProxyCache.class);
    private static final AuditProxyCache instance = new AuditProxyCache();
    private final Map<String, List<AuditProxy>> auditProxyCache = new HashMap();

    private AuditProxyCache() {
    }

    public boolean init() {
        return this.initializeAuditProxyCache();
    }

    private boolean initializeAuditProxyCache() {
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        Map proxyConfigs = this.getProxyConfigs();
        proxyConfigs.forEach((component, proxyList) -> {
            List auditProxies = this.createAuditProxySet(proxyList);
            if (auditProxies.isEmpty()) {
                LOGGER.error("{} Audit Proxy config = {}, is invalid!", component, proxyList);
                isSuccess.set(false);
            } else {
                LOGGER.info("{} Audit Proxy config = {}", component, proxyList);
                this.auditProxyCache.put(component, auditProxies);
            }
        });
        return isSuccess.get();
    }

    private Map<String, String> getProxyConfigs() {
        Configuration config = Configuration.getInstance();
        HashMap<String, String> proxyConfigs = new HashMap<String, String>();
        proxyConfigs.put(AuditComponent.AGENT.getComponent(), config.get("audit.proxy.address.agent", ""));
        proxyConfigs.put(AuditComponent.DATAPROXY.getComponent(), config.get("audit.proxy.address.dataproxy", ""));
        proxyConfigs.put(AuditComponent.SORT.getComponent(), config.get("audit.proxy.address.sort", ""));
        return proxyConfigs;
    }

    private List<AuditProxy> createAuditProxySet(String proxyList) {
        return Arrays.stream(proxyList.split(";")).map(element -> element.split(":")).filter(ipPort -> ((String[])ipPort).length == 2).map(ipPort -> new AuditProxy(ipPort[0], Integer.parseInt(ipPort[1]))).collect(Collectors.toList());
    }

    public static AuditProxyCache getInstance() {
        return instance;
    }

    public List<AuditProxy> getData(String component) {
        List result = (List)this.auditProxyCache.get(component);
        if (result == null) {
            return new LinkedList<AuditProxy>();
        }
        return result;
    }
}

