/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.auditor;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.utils.AuditUtils;

public class ReconciliationData {
    public StatData srcData;
    public StatData destData;

    public double getDiffRatio() {
        if (this.srcData == null && this.destData == null) {
            return 0.0;
        }
        if (this.srcData == null || this.destData == null) {
            return 1.0;
        }
        return AuditUtils.calculateDiffRatio((long)this.srcData.getCount(), (long)this.destData.getCount());
    }

    public List<StatData> getCombinedData() {
        ArrayList<StatData> result = new ArrayList<StatData>();
        if (this.srcData != null) {
            result.add(this.srcData);
        }
        if (this.destData != null) {
            result.add(this.destData);
        }
        return result;
    }

    public boolean isNotEmpty() {
        return this.srcData != null || this.destData != null;
    }

    public StatData getSrcData() {
        return this.srcData;
    }

    public StatData getDestData() {
        return this.destData;
    }

    public void setSrcData(StatData srcData) {
        this.srcData = srcData;
    }

    public void setDestData(StatData destData) {
        this.destData = destData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReconciliationData)) {
            return false;
        }
        ReconciliationData other = (ReconciliationData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        StatData this$srcData = this.getSrcData();
        StatData other$srcData = other.getSrcData();
        if (this$srcData == null ? other$srcData != null : !this$srcData.equals(other$srcData)) {
            return false;
        }
        StatData this$destData = this.getDestData();
        StatData other$destData = other.getDestData();
        return !(this$destData == null ? other$destData != null : !this$destData.equals(other$destData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReconciliationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatData $srcData = this.getSrcData();
        result = result * 59 + ($srcData == null ? 43 : $srcData.hashCode());
        StatData $destData = this.getDestData();
        result = result * 59 + ($destData == null ? 43 : $destData.hashCode());
        return result;
    }

    public String toString() {
        return "ReconciliationData(srcData=" + this.getSrcData() + ", destData=" + this.getDestData() + ")";
    }

    public ReconciliationData(StatData srcData, StatData destData) {
        this.srcData = srcData;
        this.destData = destData;
    }
}

